/*****************************************************************************
 * Copyright (c) 2015 CEA LIST and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Benoit Maggi (CEA LIST) benoit.maggi@cea.fr - Initial API and implementation
 *   
 *****************************************************************************/
package org.eclipse.papyrus.sysml14.blocks;
import org.eclipse.papyrus.sysml14.blocks.internal.impl.BlocksFactoryImpl;


/**
 * 
 *
 */
public class BlocksFactoryCustomImpl extends BlocksFactoryImpl implements BlocksFactory{

	/**
	 * @see org.eclipse.papyrus.sysml14.blocks.internal.impl.BlocksFactoryImpl#createBoundReference()
	 *
	 * @return the BoundReference
	 */
	@Override
	public BoundReference createBoundReference() {
		return new BoundReferenceCustomImpl();
	}
	
	/**
	 * @see org.eclipse.papyrus.sysml14.blocks.internal.impl.BlocksFactoryImpl#createBlock()
	 *
	 * @return the Block
	 */
	@Override
	public Block createBlock() {
		return new BlockCustomImpl();
	}
	
}
