/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.complete;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Behavior;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.CompleteInheritance;
import org.eclipse.ocl.pivot.CompletePackage;
import org.eclipse.ocl.pivot.ElementExtension;
import org.eclipse.ocl.pivot.InheritanceFragment;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Region;
import org.eclipse.ocl.pivot.State;
import org.eclipse.ocl.pivot.StateMachine;
import org.eclipse.ocl.pivot.Stereotype;
import org.eclipse.ocl.pivot.StereotypeExtender;
import org.eclipse.ocl.pivot.TemplateBinding;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.pivot.TemplateParameters;
import org.eclipse.ocl.pivot.TemplateSignature;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Vertex;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.ids.PackageId;
import org.eclipse.ocl.pivot.ids.ParametersId;
import org.eclipse.ocl.pivot.internal.ClassImpl;
import org.eclipse.ocl.pivot.internal.CompleteClassImpl;
import org.eclipse.ocl.pivot.internal.complete.ClassListeners;
import org.eclipse.ocl.pivot.internal.complete.CompleteClassInternal;
import org.eclipse.ocl.pivot.internal.complete.CompleteInheritanceImpl;
import org.eclipse.ocl.pivot.internal.complete.CompleteModelInternal;
import org.eclipse.ocl.pivot.internal.complete.CompletePackageInternal;
import org.eclipse.ocl.pivot.internal.complete.PartialOperations;
import org.eclipse.ocl.pivot.internal.complete.PartialProperties;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.manager.Orphanage;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.FeatureFilter;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.ocl.pivot.utilities.TypeUtil;

public class PartialClasses
extends EObjectResolvingEList<Class>
implements ClassListeners.IClassListener {
    private static final long serialVersionUID = 1L;
    public static final @NonNull TracingOption PARTIAL_CLASSES = new TracingOption("org.eclipse.ocl.pivot", "partialClasses");
    public static final @NonNull TracingOption ADD_BASE_PROPERTY = new TracingOption("org.eclipse.ocl.pivot", "partialClasses/addBaseProperty");
    public static final @NonNull TracingOption ADD_EXTENSION_PROPERTY = new TracingOption("org.eclipse.ocl.pivot", "partialClasses/addExtensionProperty");
    public static final @NonNull TracingOption INIT_MEMBER_OPERATIONS = new TracingOption("org.eclipse.ocl.pivot", "partialClasses/initMemberOperations");
    public static final @NonNull TracingOption INIT_MEMBER_PROPERTIES = new TracingOption("org.eclipse.ocl.pivot", "partialClasses/initMemberProperties");
    private @Nullable Map<@NonNull String, @NonNull PartialOperations> name2partialOperations = null;
    private @Nullable Map<@NonNull String, @NonNull PartialProperties> name2partialProperties = null;
    private Set<@NonNull CompleteClassInternal> superCompleteClasses = null;
    private @Nullable Map<@NonNull String, @NonNull State> name2states = null;
    protected CompleteInheritanceImpl completeInheritance;
    private @Nullable Map<TemplateParameters, WeakReference<Class>> specializations = null;

    public PartialClasses(@NonNull CompleteClassImpl completeClass) {
        super(Class.class, (InternalEObject)completeClass, PivotPackage.Literals.COMPLETE_CLASS__PARTIAL_CLASSES.getFeatureID());
    }

    public void addUnique(Class partialClass) {
        assert (partialClass != null);
        this.didAdd(partialClass);
        super.addUnique((Object)partialClass);
    }

    public void addUnique(int index, Class partialClass) {
        assert (partialClass != null);
        this.didAdd(partialClass);
        super.addUnique(index, (Object)partialClass);
    }

    public @NonNull Set<@NonNull CompleteClassInternal> computeSuperCompleteClasses() {
        Set<@NonNull CompleteClassInternal> superCompleteClasses2 = this.superCompleteClasses;
        if (superCompleteClasses2 == null) {
            CompleteModelInternal completeModel = this.getCompleteModel();
            superCompleteClasses2 = this.superCompleteClasses = new HashSet<CompleteClassInternal>();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Class partialClass = (Class)iterator.next();
                for (Class partialSuperClass : ClassUtil.nullFree(partialClass.getSuperClasses())) {
                    CompleteClassInternal superCompleteClass = completeModel.getCompleteClass(PivotUtil.getUnspecializedTemplateableElement(partialSuperClass));
                    superCompleteClasses2.add(superCompleteClass);
                    superCompleteClasses2.addAll(superCompleteClass.getPartialClasses().computeSuperCompleteClasses());
                }
            }
            if (superCompleteClasses2.isEmpty()) {
                CompleteClassInternal oclAnyCompleteClass = completeModel.getCompleteClass(completeModel.getStandardLibrary().getOclAnyType());
                if (this.getCompleteClass() != oclAnyCompleteClass) {
                    superCompleteClasses2.add(oclAnyCompleteClass);
                }
            }
        }
        return superCompleteClasses2;
    }

    protected @NonNull Property createExtensionProperty(@NonNull ElementExtension stereotypeInstance, @NonNull Class baseType) {
        Iterator<Property> iterator;
        Stereotype stereotype = stereotypeInstance.getStereotype();
        Map<String, @NonNull PartialProperties> name2partialProperties2 = this.name2partialProperties;
        assert (name2partialProperties2 != null);
        String extensionPropertyName = "extension_" + stereotype.getName();
        Property extensionProperty = null;
        PartialProperties partialProperties = name2partialProperties2.get(extensionPropertyName);
        if (partialProperties == null) {
            partialProperties = new PartialProperties(this.getEnvironmentFactory());
            name2partialProperties2.put(extensionPropertyName, partialProperties);
        }
        if ((iterator = partialProperties.iterator()).hasNext()) {
            Property partialProperty;
            extensionProperty = partialProperty = iterator.next();
        }
        if (extensionProperty == null) {
            extensionProperty = PivotFactory.eINSTANCE.createProperty();
            extensionProperty.setName(extensionPropertyName);
            baseType.getOwnedProperties().add(extensionProperty);
        }
        extensionProperty.setType(stereotype);
        boolean isRequired = false;
        for (StereotypeExtender typeExtension : stereotype.getOwnedExtenders()) {
            Class metatype = typeExtension.getClass_();
            if (metatype == null || !baseType.conformsTo(this.getStandardLibrary(), metatype)) continue;
            isRequired = true;
            break;
        }
        extensionProperty.setIsRequired(isRequired);
        extensionProperty.setIsStatic(true);
        return extensionProperty;
    }

    protected @NonNull Class createSpecialization(@NonNull TemplateParameters templateArguments) {
        Class unspecializedType = this.getCompleteClass().getPrimaryClass();
        String typeName = unspecializedType.getName();
        TemplateSignature templateSignature = unspecializedType.getOwnedSignature();
        List<TemplateParameter> templateParameters = templateSignature.getOwnedParameters();
        EClass eClass = unspecializedType.eClass();
        EFactory eFactoryInstance = eClass.getEPackage().getEFactoryInstance();
        Class specializedType = (Class)eFactoryInstance.create(eClass);
        specializedType.setName(typeName);
        TemplateBinding templateBinding = PivotFactory.eINSTANCE.createTemplateBinding();
        int i = 0;
        while (i < templateParameters.size()) {
            Type templateArgument;
            TemplateParameter formalParameter = templateParameters.get(i);
            if (formalParameter != null && (templateArgument = templateArguments.get(i)) instanceof Type) {
                Type actualType = templateArgument;
                TemplateParameterSubstitution templateParameterSubstitution = CompleteInheritanceImpl.createTemplateParameterSubstitution(formalParameter, actualType);
                templateBinding.getOwnedSubstitutions().add(templateParameterSubstitution);
            }
            ++i;
        }
        specializedType.getOwnedBindings().add(templateBinding);
        this.getCompleteModel().resolveSuperClasses(specializedType, unspecializedType);
        specializedType.setUnspecializedElement(unspecializedType);
        PivotMetamodelManager metamodelManager = this.getCompleteModel().getMetamodelManager();
        Orphanage orphanage = Orphanage.getOrphanage(metamodelManager.getASResourceSet());
        specializedType.setOwningPackage(orphanage);
        return specializedType;
    }

    protected void didAdd(Class partialClass) {
        if (PARTIAL_CLASSES.isActive()) {
            PARTIAL_CLASSES.println("Do-didAdd " + this + " " + partialClass);
        }
        ((ClassImpl)partialClass).addClassListener(this);
        if (partialClass.getUnspecializedElement() == null) {
            this.getCompleteModel().didAddClass(partialClass, this.getCompleteClass());
        }
        this.dispose();
    }

    protected void didRemove(int index, Class partialClass) {
        assert (partialClass != null);
        if (PARTIAL_CLASSES.isActive()) {
            PARTIAL_CLASSES.println("Do-didRemove " + this + " " + partialClass);
        }
        super.didRemove(index, (Object)partialClass);
        ((ClassImpl)partialClass).removeClassListener(this);
        this.dispose();
    }

    @Override
    public void didAddOperation(@NonNull Operation pivotOperation) {
        String operationName;
        Map<String, PartialOperations> name2partialOperations2 = this.name2partialOperations;
        if (name2partialOperations2 != null && (operationName = pivotOperation.getName()) != null) {
            PartialOperations partialOperations = name2partialOperations2.get(operationName);
            if (partialOperations == null) {
                partialOperations = new PartialOperations(this.getCompleteClass(), operationName);
                name2partialOperations2.put(operationName, partialOperations);
            }
            partialOperations.didAddOperation(pivotOperation);
        }
    }

    @Override
    public void didAddProperty(@NonNull Property pivotProperty) {
        Map<String, @NonNull PartialProperties> name2partialProperties2 = this.name2partialProperties;
        if (name2partialProperties2 != null) {
            String propertyName = pivotProperty.getName();
            PartialProperties partials = name2partialProperties2.get(propertyName);
            if (partials == null) {
                partials = new PartialProperties(this.getEnvironmentFactory());
                name2partialProperties2.put(propertyName, partials);
            }
            partials.didAddProperty(pivotProperty);
        }
    }

    @Override
    public void didAddSuperClass(@NonNull Class partialClass) {
        if (this.completeInheritance != null) {
            this.completeInheritance.uninstall();
        }
    }

    @Override
    public void didRemoveOperation(@NonNull Operation pivotOperation) {
        String operationName;
        PartialOperations partialOperations;
        Map<String, PartialOperations> name2partialOperations2 = this.name2partialOperations;
        if (name2partialOperations2 != null && (partialOperations = name2partialOperations2.get(operationName = pivotOperation.getName())) != null && partialOperations.didRemoveOperation(pivotOperation)) {
            name2partialOperations2.remove(operationName);
        }
    }

    @Override
    public void didRemoveProperty(@NonNull Property pivotProperty) {
        String propertyName;
        PartialProperties partials;
        Map<String, @NonNull PartialProperties> name2partialProperties2 = this.name2partialProperties;
        if (name2partialProperties2 != null && (partials = name2partialProperties2.get(propertyName = pivotProperty.getName())) != null && partials.didRemoveProperty(pivotProperty)) {
            name2partialProperties2.remove(propertyName);
        }
    }

    @Override
    public void didRemoveSuperClass(@NonNull Class partialClass) {
        if (this.completeInheritance != null) {
            this.completeInheritance.uninstall();
        }
    }

    public void dispose() {
        Map<String, PartialProperties> name2partialProperties2;
        CompleteClassInternal completeClass = this.getCompleteClass();
        CompletePackageInternal owningCompletePackage = completeClass.getOwningCompletePackage();
        if (owningCompletePackage != null) {
            owningCompletePackage.getPartialPackages().uninstalled(completeClass);
        }
        this.completeInheritance = null;
        Map<String, PartialOperations> name2partialOperations2 = this.name2partialOperations;
        if (name2partialOperations2 != null) {
            name2partialOperations2.clear();
            this.name2partialOperations = null;
        }
        if ((name2partialProperties2 = this.name2partialProperties) != null) {
            name2partialProperties2.clear();
            this.name2partialProperties = null;
        }
        this.superCompleteClasses = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized @Nullable Type findSpecializedType(@NonNull TemplateParameters templateArguments) {
        TemplateSignature templateSignature = this.getCompleteClass().getPrimaryClass().getOwnedSignature();
        List<TemplateParameter> templateParameters = templateSignature.getOwnedParameters();
        int iMax = templateParameters.size();
        if (templateArguments.parametersSize() != iMax) {
            return null;
        }
        Map<TemplateParameters, WeakReference<Class>> specializations2 = this.specializations;
        if (specializations2 == null) {
            return null;
        }
        WeakReference<Class> weakReference = specializations2.get(templateArguments);
        if (weakReference == null) {
            return null;
        }
        Class type = (Class)weakReference.get();
        if (type == null) {
            Map<TemplateParameters, WeakReference<Class>> map = specializations2;
            synchronized (map) {
                type = (Class)weakReference.get();
                if (type == null) {
                    specializations2.remove(templateArguments);
                }
            }
        }
        return type;
    }

    private void gatherAllStereotypes(@NonNull Set<Stereotype> allStereotypes, @NonNull Iterable<Stereotype> moreStereotypes) {
        HashSet<Stereotype> newStereotypes = null;
        PivotMetamodelManager metamodelManager = this.getMetamodelManager();
        for (Stereotype stereotype : moreStereotypes) {
            if (!allStereotypes.add(stereotype = metamodelManager.getPrimaryElement(stereotype))) continue;
            CompleteClassInternal superCompleteClass = null;
            superCompleteClass = stereotype instanceof CompleteInheritanceImpl ? ((CompleteInheritanceImpl)((Object)stereotype)).getCompleteClass() : this.getCompleteModel().getCompleteClass(stereotype);
            if (newStereotypes == null) {
                newStereotypes = new HashSet<Stereotype>();
            }
            for (Class partialType : superCompleteClass.getPartialClasses()) {
                if (!(partialType instanceof Stereotype)) continue;
                Stereotype partialStereotype = (Stereotype)partialType;
                newStereotypes.add(partialStereotype);
                for (Class superType : partialStereotype.getSuperClasses()) {
                    if (!(superType instanceof Stereotype)) continue;
                    Stereotype superStereotype = (Stereotype)superType;
                    superType = metamodelManager.getPrimaryElement(superStereotype);
                    newStereotypes.add(superStereotype);
                }
            }
        }
        if (newStereotypes != null) {
            this.gatherAllStereotypes(allStereotypes, newStereotypes);
        }
    }

    public @NonNull CompleteClassInternal getCompleteClass() {
        return (CompleteClassImpl)this.owner;
    }

    public final @NonNull CompleteInheritanceImpl getCompleteInheritance() {
        CompleteInheritanceImpl completeInheritance2 = this.completeInheritance;
        if (completeInheritance2 == null) {
            CompleteClassInternal completeClass = this.getCompleteClass();
            CompletePackageInternal completePackage = completeClass.getOwningCompletePackage();
            this.completeInheritance = completeInheritance2 = completePackage.getCompleteInheritance(completeClass);
        }
        return completeInheritance2;
    }

    public @NonNull CompleteModelInternal getCompleteModel() {
        return this.getCompleteClass().getCompleteModel();
    }

    public @NonNull EnvironmentFactoryInternal getEnvironmentFactory() {
        return this.getCompleteClass().getEnvironmentFactory();
    }

    public @NonNull Iterable<@NonNull ? extends CompleteInheritance> getInitialSuperInheritances() {
        final @NonNull Iterator<@NonNull CompleteClassInternal> iterator = ClassUtil.nonNull(this.computeSuperCompleteClasses().iterator());
        return new Iterable<CompleteInheritance>(){

            @Override
            public @NonNull Iterator<@NonNull CompleteInheritance> iterator() {
                return new Iterator<CompleteInheritance>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public @NonNull CompleteInheritance next() {
                        CompleteClassInternal next = ClassUtil.nonNull((CompleteClassInternal)iterator.next());
                        return next.getCompleteInheritance();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public @NonNull PivotMetamodelManager getMetamodelManager() {
        return this.getCompleteClass().getMetamodelManager();
    }

    public @Nullable Operation getOperation(@NonNull OperationId operationId) {
        String operationName;
        PartialOperations partialOperations;
        Map<String, PartialOperations> name2partialOperations2 = this.name2partialOperations;
        if (name2partialOperations2 == null) {
            name2partialOperations2 = this.initMemberOperations();
        }
        if ((partialOperations = name2partialOperations2.get(operationName = operationId.getName())) == null) {
            return null;
        }
        return partialOperations.getOperation(operationId.getParametersId(), null);
    }

    public @Nullable Operation getOperation(@NonNull Operation pivotOperation) {
        String operationName;
        PartialOperations partialOperations;
        Map<String, PartialOperations> name2partialOperations2 = this.name2partialOperations;
        if (name2partialOperations2 == null) {
            name2partialOperations2 = this.initMemberOperations();
        }
        if ((partialOperations = name2partialOperations2.get(operationName = pivotOperation.getName())) == null) {
            return null;
        }
        return partialOperations.getOperation(pivotOperation.getParametersId(), pivotOperation.isIsStatic() ? FeatureFilter.SELECT_STATIC : FeatureFilter.SELECT_NON_STATIC);
    }

    public @NonNull Iterable<String> getOperationNames() {
        Map<String, PartialOperations> name2partialOperations2 = this.name2partialOperations;
        if (name2partialOperations2 == null) {
            name2partialOperations2 = this.initMemberOperations();
        }
        return name2partialOperations2.keySet();
    }

    public @Nullable Iterable<@NonNull Operation> getOperationOverloads(@NonNull Operation pivotOperation) {
        String operationName;
        PartialOperations partialOperations;
        Map<@NonNull String, @NonNull PartialOperations> name2partialOperations2 = this.name2partialOperations;
        if (name2partialOperations2 == null) {
            name2partialOperations2 = this.initMemberOperations();
        }
        if ((partialOperations = name2partialOperations2.get(operationName = pivotOperation.getName())) == null) {
            return null;
        }
        ParametersId parametersId = pivotOperation.getParametersId();
        return partialOperations.getOperationOverloads(parametersId, pivotOperation.isIsStatic() ? FeatureFilter.SELECT_STATIC : FeatureFilter.SELECT_NON_STATIC);
    }

    public @NonNull Iterable<@NonNull Operation> getOperationOverloads(@Nullable FeatureFilter featureFilter, @Nullable String name) {
        PartialOperations partialOperations;
        Map<@NonNull String, @NonNull PartialOperations> name2partialOperations2 = this.name2partialOperations;
        if (name2partialOperations2 == null) {
            name2partialOperations2 = this.initMemberOperations();
        }
        if ((partialOperations = name2partialOperations2.get(name)) == null) {
            return PivotMetamodelManager.EMPTY_OPERATION_LIST;
        }
        return partialOperations.getOperationOverloads(featureFilter);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull Iterable<@NonNull Operation> getOperations() {
        Map<@NonNull String, @NonNull PartialOperations> name2partialOperations2 = this.name2partialOperations;
        if (name2partialOperations2 == null) {
            name2partialOperations2 = this.initMemberOperations();
        }
        @NonNull Iterable transformed = Iterables.transform(name2partialOperations2.values(), PartialOperations.partialOperations2allOperations);
        @NonNull @NonNull Iterable concat = Iterables.concat((Iterable)Iterables.concat((Iterable)transformed));
        return concat;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull Iterable<@NonNull Operation> getOperations(final @Nullable FeatureFilter featureFilter) {
        Map<@NonNull String, @NonNull PartialOperations> name2partialOperations2 = this.name2partialOperations;
        if (name2partialOperations2 == null) {
            name2partialOperations2 = this.initMemberOperations();
        }
        Collection<@NonNull PartialOperations> itMapListOps = name2partialOperations2.values();
        @NonNull @NonNull Iterable itItListOps = Iterables.transform(itMapListOps, PartialOperations.partialOperations2allOperations);
        @NonNull @NonNull Iterable itListOps = Iterables.concat((Iterable)itItListOps);
        @NonNull @NonNull Iterable itOps = Iterables.concat((Iterable)itListOps);
        if (featureFilter == null) {
            return itOps;
        }
        @NonNull @NonNull Iterable subItOps = Iterables.filter((Iterable)itOps, (Predicate)new Predicate<Operation>(){

            public boolean apply(@NonNull Operation domainOperation) {
                return featureFilter.accept(domainOperation);
            }
        });
        return subItOps;
    }

    public @NonNull Iterable<@NonNull Property> getProperties(@Nullable FeatureFilter featureFilter) {
        Map<String, @NonNull PartialProperties> name2partialProperties2 = this.name2partialProperties;
        if (name2partialProperties2 == null) {
            name2partialProperties2 = this.initMemberProperties();
        }
        ArrayList<@NonNull Property> properties = new ArrayList<Property>();
        for (PartialProperties partialProperties : name2partialProperties2.values()) {
            @Nullable Property property = partialProperties.get();
            if (property == null) continue;
            if (featureFilter == null) {
                properties.add(property);
                continue;
            }
            if (!featureFilter.accept(property)) continue;
            properties.add(property);
        }
        return properties;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull Iterable<@NonNull Property> getProperties(final @Nullable FeatureFilter featureFilter, @Nullable String name) {
        PartialProperties partials;
        Map<String, @NonNull PartialProperties> name2partialProperties2 = this.name2partialProperties;
        if (name2partialProperties2 == null) {
            name2partialProperties2 = this.initMemberProperties();
        }
        if ((partials = name2partialProperties2.get(name)) == null || partials.isEmpty()) {
            return PivotMetamodelManager.EMPTY_PROPERTY_LIST;
        }
        if (featureFilter == null) {
            return partials;
        }
        @NonNull @NonNull Iterable subItOps = Iterables.filter((Iterable)partials, (Predicate)new Predicate<Property>(){

            public boolean apply(@NonNull Property domainProperty) {
                return featureFilter.accept(domainProperty);
            }
        });
        return subItOps;
    }

    public @Nullable Iterable<@NonNull Property> getProperties(@NonNull Property pivotProperty) {
        Map<String, @NonNull PartialProperties> name2partialProperties2 = this.name2partialProperties;
        if (name2partialProperties2 == null) {
            name2partialProperties2 = this.initMemberProperties();
        }
        String propertyName = pivotProperty.getName();
        return name2partialProperties2.get(propertyName);
    }

    public @Nullable Iterable<@NonNull Property> getProperties(@Nullable String propertyName) {
        Map<String, @NonNull PartialProperties> name2partialProperties2 = this.name2partialProperties;
        if (name2partialProperties2 == null) {
            name2partialProperties2 = this.initMemberProperties();
        }
        return name2partialProperties2.get(propertyName);
    }

    public @Nullable Property getProperty(@Nullable String propertyName) {
        PartialProperties partials;
        Map<String, @NonNull PartialProperties> name2partialProperties2 = this.name2partialProperties;
        if (name2partialProperties2 == null) {
            name2partialProperties2 = this.initMemberProperties();
        }
        if ((partials = name2partialProperties2.get(propertyName)) == null) {
            return null;
        }
        return partials.get();
    }

    public synchronized @NonNull Class getSpecializedType(@NonNull List<@NonNull ? extends Type> templateArguments) {
        return this.getSpecializedType(TypeUtil.createTemplateParameters(templateArguments));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized @NonNull Class getSpecializedType(@NonNull TemplateParameters templateArguments) {
        Object object;
        TemplateSignature templateSignature = this.getCompleteClass().getPrimaryClass().getOwnedSignature();
        List<TemplateParameter> templateParameters = templateSignature.getOwnedParameters();
        int iMax = templateParameters.size();
        if (templateArguments.parametersSize() != iMax) {
            throw new IllegalArgumentException("Incompatible template argument count");
        }
        Map<TemplateParameters, WeakReference<Class>> specializations2 = this.specializations;
        if (specializations2 == null) {
            object = this;
            synchronized (object) {
                specializations2 = this.specializations;
                if (specializations2 == null) {
                    specializations2 = this.specializations = new HashMap<TemplateParameters, WeakReference<Class>>();
                }
            }
        }
        object = specializations2;
        synchronized (object) {
            Class specializedType = null;
            WeakReference<Class> weakReference = specializations2.get(templateArguments);
            if (weakReference != null) {
                specializedType = (Class)weakReference.get();
            }
            if (specializedType == null) {
                specializedType = this.createSpecialization(templateArguments);
                specializations2.put(templateArguments, new WeakReference<Class>(specializedType));
            }
            return specializedType;
        }
    }

    public @NonNull StandardLibraryInternal getStandardLibrary() {
        return this.getCompleteModel().getStandardLibrary();
    }

    public @NonNull Iterable<@NonNull State> getStates() {
        Map<@NonNull String, @NonNull State> name2states2 = this.name2states;
        if (name2states2 == null) {
            name2states2 = this.initStates();
        }
        return name2states2.values();
    }

    public @NonNull Iterable<@NonNull State> getStates(@Nullable String name) {
        State state;
        Map<@NonNull String, @NonNull State> name2states2 = this.name2states;
        if (name2states2 == null) {
            name2states2 = this.initStates();
        }
        if ((state = name2states2.get(name)) == null) {
            return PivotMetamodelManager.EMPTY_STATE_LIST;
        }
        return Collections.singletonList(state);
    }

    public @NonNull Iterable<@NonNull CompleteClass> getSuperCompleteClasses() {
        CompleteInheritanceImpl inheritance = this.getCompleteClass().getCompleteInheritance();
        return Iterables.transform(inheritance.getAllSuperFragments(), (Function)new Function<InheritanceFragment, CompleteClass>(){

            public @NonNull CompleteClass apply(InheritanceFragment input) {
                return ((CompleteInheritanceImpl)input.getBaseInheritance()).getCompleteClass();
            }
        });
    }

    protected void initExtensionPropertiesFrom(@NonNull Class baseType, @NonNull Stereotype stereotype) {
        PivotMetamodelManager metamodelManager = this.getMetamodelManager();
        ElementExtension elementExtension = metamodelManager.getElementExtension(baseType, stereotype);
        Map<String, @NonNull PartialProperties> name2partialProperties2 = this.name2partialProperties;
        assert (name2partialProperties2 != null);
        Property extensionProperty = this.createExtensionProperty(elementExtension, baseType);
        this.didAddProperty(extensionProperty);
        if (ADD_EXTENSION_PROPERTY.isActive()) {
            ADD_EXTENSION_PROPERTY.println(String.valueOf(NameUtil.qualifiedNameFor(extensionProperty)) + " => " + NameUtil.qualifiedNameFor(extensionProperty.getType()));
        }
    }

    public void initMemberFeaturesFrom(@NonNull Class pivotType) {
        if (this.name2partialOperations != null) {
            this.initMemberOperationsFrom(pivotType);
        }
        if (this.name2partialProperties != null) {
            this.initMemberPropertiesFrom(pivotType);
        }
    }

    private @NonNull Map<@NonNull String, @NonNull PartialOperations> initMemberOperations() {
        Map<@NonNull String, @NonNull PartialOperations> name2partialOperations2 = this.name2partialOperations;
        if (name2partialOperations2 == null) {
            name2partialOperations2 = this.name2partialOperations = new HashMap<String, PartialOperations>();
            for (CompleteClass superCompleteClass : this.getSuperCompleteClasses()) {
                for (Class superType : ClassUtil.nullFree(superCompleteClass.getPartialClasses())) {
                    Class unspecializedType = PivotUtil.getUnspecializedTemplateableElement(superType);
                    CompleteClassInternal unspecializedCompleteClass = this.getCompleteModel().getCompleteClass(unspecializedType);
                    for (Class unspecializedPartialType : ClassUtil.nullFree(unspecializedCompleteClass.getPartialClasses())) {
                        assert (unspecializedPartialType != null);
                        this.initMemberOperationsFrom(unspecializedPartialType);
                    }
                }
            }
            for (PartialOperations partialOperations : name2partialOperations2.values()) {
                partialOperations.initMemberOperationsPostProcess();
            }
        }
        return name2partialOperations2;
    }

    private void initMemberOperationsFrom(@NonNull Class type) {
        if (INIT_MEMBER_OPERATIONS.isActive()) {
            INIT_MEMBER_OPERATIONS.println(this + " from " + type);
        }
        for (Operation pivotOperation : type.getOwnedOperations()) {
            if (pivotOperation.getName() == null) continue;
            this.didAddOperation(pivotOperation);
        }
    }

    protected @NonNull Map<String, @NonNull PartialProperties> initMemberProperties() {
        Map<@NonNull String, @NonNull PartialProperties> name2partialProperties2 = this.name2partialProperties;
        if (name2partialProperties2 == null) {
            name2partialProperties2 = this.name2partialProperties = new HashMap<String, PartialProperties>();
            ArrayList<@NonNull ElementExtension> allExtensions = null;
            HashSet<@NonNull Object> extendingStereotypes = null;
            HashSet<Class> extendedTypes = null;
            for (CompleteClass superCompleteClass : this.getSuperCompleteClasses()) {
                for (Class superType : ClassUtil.nullFree(superCompleteClass.getPartialClasses())) {
                    List<StereotypeExtender> extensionOfs;
                    Class unspecializedType = PivotUtil.getUnspecializedTemplateableElement(superType);
                    List<StereotypeExtender> extendedBys = unspecializedType.getExtenders();
                    if (extendedBys.size() > 0) {
                        if (extendingStereotypes == null) {
                            extendingStereotypes = new HashSet<Object>();
                        }
                        for (StereotypeExtender typeExtension : ClassUtil.nullFree(extendedBys)) {
                            Stereotype stereotype = typeExtension.getOwningStereotype();
                            if (stereotype == null) continue;
                            extendingStereotypes.add(stereotype);
                        }
                    }
                    if (unspecializedType instanceof Stereotype && (extensionOfs = ClassUtil.nullFree(((Stereotype)unspecializedType).getOwnedExtenders())).size() > 0) {
                        if (extendedTypes == null) {
                            extendedTypes = new HashSet<Class>();
                        }
                        for (StereotypeExtender typeExtension : extensionOfs) {
                            Class type = typeExtension.getClass_();
                            if (type == null) continue;
                            extendedTypes.add(type);
                        }
                    }
                    CompleteClassInternal unspecializedCompleteClass = this.getCompleteModel().getCompleteClass(unspecializedType);
                    for (Class unspecializedPartialType : ClassUtil.nullFree(unspecializedCompleteClass.getPartialClasses())) {
                        this.initMemberPropertiesFrom(unspecializedPartialType);
                        List<@NonNull ElementExtension> extensions = ClassUtil.nullFree(unspecializedPartialType.getOwnedExtensions());
                        if (extensions.size() <= 0) continue;
                        if (allExtensions == null) {
                            allExtensions = new ArrayList<ElementExtension>();
                        }
                        allExtensions.addAll(extensions);
                    }
                }
            }
            Class pivotClass = this.getCompleteClass().getPrimaryClass();
            if (INIT_MEMBER_PROPERTIES.isActive()) {
                INIT_MEMBER_PROPERTIES.println(this + " for " + pivotClass + " " + NameUtil.debugSimpleName(pivotClass));
            }
            if (extendingStereotypes != null) {
                HashSet<@NonNull Stereotype> allStereotypes = new HashSet<Stereotype>();
                this.gatherAllStereotypes(allStereotypes, extendingStereotypes);
                for (Stereotype stereotype : allStereotypes) {
                    @NonNull Class baseType = pivotClass;
                    this.initExtensionPropertiesFrom(baseType, stereotype);
                }
            }
            @NonNull String metatypeName = pivotClass.eClass().getName();
            CompletePackageInternal rootCompletePackage = this.getCompleteClass().getOwningCompletePackage().getRootCompletePackage();
            Package pivotPackage = rootCompletePackage.getPrimaryPackage();
            if (pivotPackage != null) {
                CompletePackage metaCompletePackage;
                Type metatype;
                EnvironmentFactoryInternal environmentFactory = this.getEnvironmentFactory();
                PackageId metapackageId = environmentFactory.getTechnology().getMetapackageId(environmentFactory, pivotPackage);
                Package metapackage = ((IdResolver.IdResolverExtension)environmentFactory.getIdResolver()).basicGetPackage(metapackageId);
                if (metapackage != null && (metatype = (metaCompletePackage = this.getMetamodelManager().getCompletePackage(metapackage)).getType(metatypeName)) != null) {
                    CompleteClassInternal metaCompleteClass = this.getCompleteModel().getCompleteClass(metatype);
                    for (Property property : metaCompleteClass.getProperties(FeatureFilter.SELECT_STATIC)) {
                        this.didAddProperty(property);
                    }
                }
            }
            for (PartialProperties properties : name2partialProperties2.values()) {
                this.initMemberPropertiesPostProcess(this.getCompleteClass().getName(), properties);
            }
        }
        return name2partialProperties2;
    }

    protected void initMemberPropertiesFrom(@NonNull Class asType) {
        Class asPrimaryType = PivotUtil.getUnspecializedTemplateableElement(asType);
        if (INIT_MEMBER_PROPERTIES.isActive()) {
            INIT_MEMBER_PROPERTIES.println(this + " from " + asPrimaryType + " " + NameUtil.debugSimpleName(asPrimaryType));
        }
        for (ElementExtension extension : asPrimaryType.getOwnedExtensions()) {
            assert (extension != null);
        }
        for (Property pivotProperty : asPrimaryType.getOwnedProperties()) {
            this.didAddProperty(pivotProperty);
        }
    }

    protected void initMemberPropertiesPostProcess(String name, @NonNull PartialProperties properties) {
    }

    protected @NonNull Map<@NonNull String, @NonNull State> initStates() {
        HashMap<@NonNull String, @NonNull State> name2states = new HashMap<String, State>();
        for (CompleteClass superCompleteClass : this.getSuperCompleteClasses()) {
            for (Class superPartialClass : ClassUtil.nullFree(superCompleteClass.getPartialClasses())) {
                for (Behavior behavior : ClassUtil.nullFree(superPartialClass.getOwnedBehaviors())) {
                    if (!(behavior instanceof StateMachine)) continue;
                    @NonNull List<@NonNull Region> regions = ClassUtil.nullFree(((StateMachine)behavior).getOwnedRegions());
                    this.initStatesForRegions(name2states, regions);
                }
            }
        }
        return name2states;
    }

    protected void initStatesForRegions(@NonNull Map<String, State> name2states, @NonNull List<@NonNull Region> regions) {
        for (Region region : regions) {
            for (Vertex vertex : ClassUtil.nullFree(region.getOwnedSubvertexes())) {
                if (!(vertex instanceof State)) continue;
                State state = (State)vertex;
                name2states.put(vertex.getName(), state);
                @NonNull List<@NonNull Region> nestedRegions = ClassUtil.nullFree(state.getOwnedRegions());
                this.initStatesForRegions(name2states, nestedRegions);
            }
        }
    }
}

