/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.widgets;

import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.papyrus.infra.emf.utils.TextReferencesHelper;
import org.eclipse.papyrus.infra.properties.ui.creation.CreationContext;
import org.eclipse.papyrus.infra.properties.ui.creation.EcorePropertyEditorFactory;
import org.eclipse.papyrus.infra.properties.ui.modelelement.EMFModelElement;
import org.eclipse.papyrus.infra.properties.ui.modelelement.ModelElement;
import org.eclipse.papyrus.infra.properties.ui.widgets.StringMultilineWithReferences;
import org.eclipse.papyrus.infra.ui.emf.providers.EMFGraphicalContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.uml.tools.namereferences.NameReferencesHelper;
import org.eclipse.papyrus.uml.tools.providers.SemanticUMLContentProvider;
import org.eclipse.papyrus.uml.tools.util.UMLProviderHelper;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.uml2.uml.UMLPackage;

public class CommentBodyEditor
extends StringMultilineWithReferences {
    public CommentBodyEditor(Composite parent, int style) {
        super(parent, style);
    }

    protected void doBinding() {
        super.doBinding();
        ModelElement element = this.getInput().getModelElement(this.getProperty());
        ResourceSet resourceSet = null;
        Resource baseResource = null;
        if (element instanceof EMFModelElement) {
            CreationContext creationContext;
            EMFModelElement emfElement = (EMFModelElement)element;
            EObject editedElement = emfElement.getSource();
            resourceSet = emfElement.getDomain() == null ? null : emfElement.getDomain().getResourceSet();
            baseResource = editedElement.eResource();
            if (baseResource == null && (creationContext = EcorePropertyEditorFactory.getCreationContext((EObject)editedElement, (boolean)false)) != null) {
                baseResource = ((EObject)creationContext.getCreationContextElement()).eResource();
            }
            if (resourceSet != null) {
                SemanticUMLContentProvider semanticProvider = new SemanticUMLContentProvider(editedElement, (EStructuralFeature)UMLPackage.eINSTANCE.getComment_Body(), resourceSet);
                semanticProvider.setWantedMetaclasses(Collections.singletonList(UMLPackage.eINSTANCE.getNamedElement()));
                EMFGraphicalContentProvider provider = UMLProviderHelper.encapsulateProvider((IStructuredContentProvider)semanticProvider, (EObject)editedElement, (EStructuralFeature)UMLPackage.eINSTANCE.getComment_Body(), (ResourceSet)resourceSet);
                this.setContentProvider((IStaticContentProvider)provider);
                this.setLabelProvider(element.getLabelProvider(this.propertyPath));
            }
        }
        this.setTextReferencesHelper((TextReferencesHelper)new NameReferencesHelper(baseResource));
    }
}

