/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer.cell;

import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.AbstractLayerCell;
import org.eclipse.nebula.widgets.nattable.layer.cell.DataCell;

public class LayerCell
extends AbstractLayerCell {
    private ILayer layer;
    private int columnPosition;
    private int rowPosition;
    private int originColumnPosition;
    private int originRowPosition;
    private int columnSpan;
    private int rowSpan;

    public LayerCell(ILayer layer, int columnPosition, int rowPosition, DataCell cell) {
        this(layer, cell.columnPosition, cell.rowPosition, columnPosition, rowPosition, cell.columnSpan, cell.rowSpan);
    }

    public LayerCell(ILayer layer, int columnPosition, int rowPosition) {
        this(layer, columnPosition, rowPosition, columnPosition, rowPosition, 1, 1);
    }

    public LayerCell(ILayer layer, int originColumnPosition, int originRowPosition, int columnPosition, int rowPosition, int columnSpan, int rowSpan) {
        this.layer = layer;
        this.originColumnPosition = originColumnPosition;
        this.originRowPosition = originRowPosition;
        this.columnPosition = columnPosition;
        this.rowPosition = rowPosition;
        this.columnSpan = columnSpan;
        this.rowSpan = rowSpan;
    }

    @Override
    public int getOriginColumnPosition() {
        return this.originColumnPosition;
    }

    @Override
    public int getOriginRowPosition() {
        return this.originRowPosition;
    }

    @Override
    public ILayer getLayer() {
        return this.layer;
    }

    @Override
    public int getColumnPosition() {
        return this.columnPosition;
    }

    @Override
    public int getRowPosition() {
        return this.rowPosition;
    }

    @Override
    public int getColumnIndex() {
        return this.getLayer().getColumnIndexByPosition(this.getColumnPosition());
    }

    @Override
    public int getRowIndex() {
        return this.getLayer().getRowIndexByPosition(this.getRowPosition());
    }

    @Override
    public int getColumnSpan() {
        return this.columnSpan;
    }

    @Override
    public int getRowSpan() {
        return this.rowSpan;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LayerCell other = (LayerCell)obj;
        if (this.columnSpan != other.columnSpan) {
            return false;
        }
        if (this.layer == null ? other.layer != null : !this.layer.equals(other.layer)) {
            return false;
        }
        if (this.originColumnPosition != other.originColumnPosition) {
            return false;
        }
        if (this.originRowPosition != other.originRowPosition) {
            return false;
        }
        return this.rowSpan == other.rowSpan;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.columnSpan;
        result = 31 * result + (this.layer == null ? 0 : this.layer.hashCode());
        result = 31 * result + this.originColumnPosition;
        result = 31 * result + this.originRowPosition;
        result = 31 * result + this.rowSpan;
        return result;
    }

    public String toString() {
        return "LayerCell: [Data: " + this.getDataValue() + ", layer: " + this.getLayer().getClass().getSimpleName() + ", originColumnPosition: " + this.getOriginColumnPosition() + ", originRowPosition: " + this.getOriginRowPosition() + ", columnSpan: " + this.getColumnSpan() + ", rowSpan: " + this.getRowSpan() + "]";
    }
}

