/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml14.nattable.common.manager.cell;

import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.sysml14.service.types.matcher.FlowPortNAMatcher;
import org.eclipse.papyrus.uml.nattable.manager.cell.StereotypePropertyCellManager;
import org.eclipse.uml2.uml.Port;

public class SysMLStereotypePropertyCellManager
extends StereotypePropertyCellManager {
    private static final FlowPortNAMatcher matcher = new FlowPortNAMatcher();

    public boolean handles(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        boolean isHandled = super.handles(columnElement, rowElement, tableManager);
        if (isHandled) {
            Map.Entry<EObject, String> cellDefinition = this.getCellDefinition(columnElement, rowElement);
            if (cellDefinition != null && cellDefinition.getKey() instanceof Port) {
                String propertyQualifiedNameString = cellDefinition.getValue().substring("property_of_stereotype:/".length(), cellDefinition.getValue().length());
                isHandled = "SysML::DeprecatedElements::FlowPort::direction".equals(propertyQualifiedNameString);
            } else {
                isHandled = false;
            }
        }
        return isHandled;
    }

    public boolean isCellEditable(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        Map.Entry<EObject, String> cellDefinition;
        boolean isEditable = super.isCellEditable(columnElement, rowElement, tableManager);
        if (isEditable && (cellDefinition = this.getCellDefinition(columnElement, rowElement)) != null) {
            isEditable = !matcher.matches(cellDefinition.getKey());
        }
        return isEditable;
    }

    private Map.Entry<EObject, String> getCellDefinition(Object columnElement, Object rowElement) {
        List objects = this.organizeAndResolvedObjects(columnElement, rowElement, null);
        if (objects != null && 2 == objects.size() && objects.get(0) instanceof EObject && objects.get(1) instanceof String) {
            return new AbstractMap.SimpleEntry<EObject, String>((EObject)objects.get(0), (String)objects.get(1));
        }
        return null;
    }
}

