/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search.dialogs;

import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.pde.internal.core.target.Messages;
import org.eclipse.pde.internal.core.target.P2TargetUtils;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.search.dialogs.IUPackage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

public class FilteredIUSelectionDialog
extends FilteredItemsSelectionDialog {
    private Button fShowLatestVersionOnlyButton;
    private boolean fShowLatestVersionOnly = true;
    private final IQuery<IInstallableUnit> query;
    private final ILabelProvider fLabelProvider = new IUWrapperLabelProvider();

    public FilteredIUSelectionDialog(Shell shell, IQuery<IInstallableUnit> query) {
        super(shell, true);
        this.query = query;
        this.setTitle(PDEUIMessages.FilteredIUSelectionDialog_title);
        this.setMessage(PDEUIMessages.FilteredIUSelectionDialog_message);
        this.setListLabelProvider(this.fLabelProvider);
        this.setDetailsLabelProvider(this.fLabelProvider);
    }

    protected Control createExtendedContentArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.fShowLatestVersionOnlyButton = new Button(composite, 32);
        this.fShowLatestVersionOnlyButton.setSelection(true);
        this.fShowLatestVersionOnlyButton.setText(PDEUIMessages.FilteredIUSelectionDialog_showLatestVersionOnly);
        this.fShowLatestVersionOnlyButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.fShowLatestVersionOnly = this.fShowLatestVersionOnlyButton.getSelection();
            this.applyFilter();
        }));
        return composite;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new IUItemsFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        IMetadataRepositoryManager manager = P2TargetUtils.getRepoManager();
        if (manager == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", Messages.IUBundleContainer_2));
        }
        IQuery pipedQuery = this.fShowLatestVersionOnly ? QueryUtil.createPipeQuery(this.query, (IQuery)QueryUtil.createLatestIUQuery()) : this.query;
        for (IInstallableUnit iu : manager.query(pipedQuery, progressMonitor)) {
            for (IProvidedCapability pc : iu.getProvidedCapabilities()) {
                if (!pc.getNamespace().equals("java.package")) continue;
                IUPackage pkg = new IUPackage(pc.getName(), pc.getVersion(), iu);
                contentProvider.add((Object)pkg, itemsFilter);
            }
            contentProvider.add((Object)iu, itemsFilter);
        }
    }

    protected IDialogSettings getDialogSettings() {
        return new DialogSettings("org.eclipse.pde.internal.ui.search.dialogs.FilteredTargetRepoIUSelectionDialog");
    }

    public String getElementName(Object item) {
        return null;
    }

    protected Comparator<Object> getItemsComparator() {
        return (o1, o2) -> {
            String id1 = null;
            String id2 = null;
            if (o1 instanceof IUPackage) {
                id1 = ((IUPackage)o1).getId();
            } else if (o1 instanceof IInstallableUnit) {
                id1 = ((IInstallableUnit)o1).getId();
            } else {
                return 0;
            }
            if (o2 instanceof IUPackage) {
                id2 = ((IUPackage)o2).getId();
            } else if (o2 instanceof IInstallableUnit) {
                id2 = ((IInstallableUnit)o2).getId();
            } else {
                return 0;
            }
            return id1.compareTo(id2);
        };
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    class IUItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        boolean latest;

        public IUItemsFilter() {
            super((FilteredItemsSelectionDialog)FilteredIUSelectionDialog.this);
            this.latest = false;
            this.latest = FilteredIUSelectionDialog.this.fShowLatestVersionOnly;
        }

        public boolean matchItem(Object item) {
            if (item instanceof IUPackage) {
                return this.patternMatcher.matches(((IUPackage)item).getId());
            }
            if (item instanceof IInstallableUnit) {
                return this.isIUMatch((IInstallableUnit)item);
            }
            return false;
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }

        public boolean isSubFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            if (this.latest != ((IUItemsFilter)filter).latest) {
                return false;
            }
            return super.isSubFilter(filter);
        }

        public boolean equalsFilter(FilteredItemsSelectionDialog.ItemsFilter obj) {
            if (this.latest != ((IUItemsFilter)obj).latest) {
                return false;
            }
            return super.equals(obj);
        }

        public boolean isIUMatch(IInstallableUnit iu) {
            if (iu.getFragments() != null && iu.getFragments().size() > 0) {
                return false;
            }
            String id = iu.getId();
            String name = iu.getProperty("org.eclipse.equinox.p2.name", null);
            if (name == null || name.startsWith("%")) {
                name = "";
            }
            return this.patternMatcher.matches(id) || this.patternMatcher.matches(name);
        }
    }

    private class IUWrapperLabelProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private PDELabelProvider labelProvider = PDEPlugin.getDefault().getLabelProvider();

        public IUWrapperLabelProvider() {
            this.labelProvider.connect((Object)this);
        }

        public StyledString getStyledText(Object element) {
            StyledString styledString = new StyledString();
            if (element instanceof IUPackage) {
                IUPackage iuPackage = (IUPackage)element;
                styledString.append(iuPackage.getId());
                styledString.append(' ');
                styledString.append("(", StyledString.QUALIFIER_STYLER);
                styledString.append(iuPackage.getVersion().toString(), StyledString.QUALIFIER_STYLER);
                styledString.append(")", StyledString.QUALIFIER_STYLER);
                IInstallableUnit iu = iuPackage.getIU();
                styledString.append(" from ", StyledString.QUALIFIER_STYLER);
                styledString.append(iu.getId(), StyledString.QUALIFIER_STYLER);
                styledString.append(' ');
                styledString.append("(", StyledString.QUALIFIER_STYLER);
                styledString.append(iu.getVersion().toString(), StyledString.QUALIFIER_STYLER);
                styledString.append(")", StyledString.QUALIFIER_STYLER);
            } else if (element instanceof IInstallableUnit) {
                IInstallableUnit iu = (IInstallableUnit)element;
                String name = iu.getProperty("org.eclipse.equinox.p2.name", null);
                styledString.append(iu.getId());
                styledString.append(' ');
                styledString.append("(", StyledString.QUALIFIER_STYLER);
                styledString.append(iu.getVersion().toString(), StyledString.QUALIFIER_STYLER);
                styledString.append(")", StyledString.QUALIFIER_STYLER);
                styledString.append(" - ");
                styledString.append(name, StyledString.DECORATIONS_STYLER);
            }
            return styledString;
        }

        public Image getImage(Object element) {
            if (element instanceof IUPackage) {
                return this.labelProvider.get(PDEPluginImages.DESC_PACKAGE_OBJ);
            }
            if (element instanceof IInstallableUnit) {
                IInstallableUnit iu = (IInstallableUnit)element;
                if (QueryUtil.isGroup((IInstallableUnit)iu)) {
                    return this.labelProvider.get(PDEPluginImages.DESC_FEATURE_OBJ);
                }
                return this.labelProvider.get(PDEPluginImages.DESC_PLUGIN_OBJ);
            }
            return null;
        }

        public String getText(Object element) {
            StyledString string = this.getStyledText(element);
            return string.getString();
        }

        public void dispose() {
            this.labelProvider.disconnect((Object)this);
        }
    }
}

