/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotml.generators.common.mmqueries;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.papyrus.RobotML.Allocate;
import org.eclipse.papyrus.RobotML.DeploymentPlan;
import org.eclipse.papyrus.robotml.generators.common.mmqueries.ArchitectureQueries;
import org.eclipse.papyrus.robotml.generators.common.mmqueries.GeneralQueries;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.util.UMLUtil;

public class DeploymentQueries {
    public static List<InstanceSpecification> getInstanceSpecificationsInModel(Model model) {
        LinkedList<InstanceSpecification> found_elts = new LinkedList<InstanceSpecification>();
        for (Element ne : model.getOwnedElements()) {
            if (ne instanceof NamedElement) {
                if (ne instanceof InstanceSpecification) {
                    found_elts.add((InstanceSpecification)ne);
                    continue;
                }
                if (!(ne instanceof Package)) continue;
                found_elts.addAll(DeploymentQueries.getInstanceSpecificationsInPackage((Package)ne));
                continue;
            }
            if (!(ne instanceof Model)) continue;
            found_elts.addAll(DeploymentQueries.getInstanceSpecificationsInModel((Model)ne));
        }
        return found_elts;
    }

    public static List<InstanceSpecification> getInstanceSpecificationsInPackage(Package pack) {
        LinkedList<InstanceSpecification> found_elts = new LinkedList<InstanceSpecification>();
        for (Element ne : pack.getOwnedElements()) {
            if (ne instanceof NamedElement) {
                if (ne instanceof InstanceSpecification) {
                    found_elts.add((InstanceSpecification)ne);
                    continue;
                }
                if (!(ne instanceof Package)) continue;
                found_elts.addAll(DeploymentQueries.getInstanceSpecificationsInPackage((Package)ne));
                continue;
            }
            if (!(ne instanceof Model)) continue;
            found_elts.addAll(DeploymentQueries.getInstanceSpecificationsInModel((Model)ne));
        }
        return found_elts;
    }

    public static List<InstanceSpecification> getInstanceSpecificationsForPlatform(Model model, String pfn) {
        LinkedList<InstanceSpecification> found_elts = new LinkedList<InstanceSpecification>();
        for (InstanceSpecification instanceSpecification : DeploymentQueries.getInstanceSpecificationsInModel(model)) {
            if (!DeploymentQueries.isAllocatedTo(instanceSpecification, pfn)) continue;
            found_elts.add(instanceSpecification);
        }
        return found_elts;
    }

    public static List<InstanceSpecification> getInstanceSpecificationsForPlatform2(Model model, String targetPlatformName) {
        LinkedList<InstanceSpecification> found_elts = new LinkedList<InstanceSpecification>();
        for (Package dpPck : DeploymentQueries.getDeploymentPlanPackagesInModel(model)) {
            found_elts.addAll(DeploymentQueries.getDeploymentPlanInstanceSpecsForPlatform(dpPck, targetPlatformName));
        }
        return found_elts;
    }

    public static String getParentName(InstanceSpecification inst) {
        String name = inst.getName();
        Integer idx = name.lastIndexOf(46);
        if (idx != -1) {
            return name.substring(0, idx);
        }
        return null;
    }

    public static Property getInstance(Model model, InstanceSpecification instanceSpecification) {
        List<Property> l = ArchitectureQueries.getAllSubComponentsInClass(ArchitectureQueries.getRootClassForModel(model));
        for (Property p : l) {
            String[] str = instanceSpecification.getName().split("\\.");
            if (str.length <= 0 || !p.getName().equals(str[str.length - 1])) continue;
            return p;
        }
        return null;
    }

    public static boolean isAllocatedTo(InstanceSpecification instSpec, String platformName) {
        if (instSpec == null || platformName == null) {
            return false;
        }
        for (Dependency dep : instSpec.getClientDependencies()) {
            Allocate alloc = (Allocate)UMLUtil.getStereotypeApplication((Element)dep, Allocate.class);
            if (alloc == null) continue;
            for (NamedElement nelt : dep.getSuppliers()) {
                if (!DeploymentQueries.isPlatformInstanceSpecificationFromPlatform(nelt, platformName)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<DeploymentPlan> getDeploymentPlansInModel(Model model) {
        LinkedList<DeploymentPlan> dep_plans = new LinkedList<DeploymentPlan>();
        for (Element elt : model.getOwnedElements()) {
            if (!(elt instanceof Package)) continue;
            DeploymentPlan dp = (DeploymentPlan)UMLUtil.getStereotypeApplication((Element)elt, DeploymentPlan.class);
            if (dp != null) {
                dep_plans.add(dp);
                continue;
            }
            dep_plans.addAll(DeploymentQueries.getDeploymentPlansInPackage((Package)elt));
        }
        return dep_plans;
    }

    protected static List<DeploymentPlan> getDeploymentPlansInPackage(Package pck) {
        LinkedList<DeploymentPlan> dep_plans = new LinkedList<DeploymentPlan>();
        for (Element elt : pck.getOwnedElements()) {
            if (!(elt instanceof Package)) continue;
            DeploymentPlan dp = (DeploymentPlan)UMLUtil.getStereotypeApplication((Element)elt, DeploymentPlan.class);
            if (dp != null) {
                dep_plans.add(dp);
                continue;
            }
            dep_plans.addAll(DeploymentQueries.getDeploymentPlansInPackage((Package)elt));
        }
        return dep_plans;
    }

    public static List<Package> getDeploymentPlanPackagesInModel(Model model) {
        List<DeploymentPlan> dps = DeploymentQueries.getDeploymentPlansInModel(model);
        LinkedList<Package> pcks = new LinkedList<Package>();
        for (DeploymentPlan dp : dps) {
            pcks.add(dp.getBase_Package());
        }
        return pcks;
    }

    public static List<InstanceSpecification> getDeploymentPlanInstanceSpecsForPlatform(Package deploymentPlan, String targetPlatformName) {
        LinkedList<InstanceSpecification> found_elts = new LinkedList<InstanceSpecification>();
        DeploymentPlan dp = (DeploymentPlan)UMLUtil.getStereotypeApplication((Element)deploymentPlan, DeploymentPlan.class);
        if (dp == null) {
            return found_elts;
        }
        for (Element elt : deploymentPlan.getOwnedElements()) {
            if (!(elt instanceof Dependency)) continue;
            Dependency dep = (Dependency)elt;
            Allocate alloc = (Allocate)UMLUtil.getStereotypeApplication((Element)elt, Allocate.class);
            if (alloc == null) continue;
            InstanceSpecification client_instance_spec = null;
            for (NamedElement client_elt : dep.getClients()) {
                if (!(client_elt instanceof InstanceSpecification)) continue;
                client_instance_spec = (InstanceSpecification)client_elt;
                break;
            }
            if (client_instance_spec == null) continue;
            for (NamedElement nelt : dep.getSuppliers()) {
                if (!DeploymentQueries.isPlatformInstanceSpecificationFromPlatform(nelt, targetPlatformName)) continue;
                found_elts.add(client_instance_spec);
            }
        }
        return found_elts;
    }

    public static String getAllocationName(InstanceSpecification instanceSpecification) {
        if (instanceSpecification.getClientDependencies().size() == 0) {
            return new String();
        }
        Dependency d = (Dependency)instanceSpecification.getClientDependencies().get(0);
        return d.getName();
    }

    public static List<Class> getDefinedComponentsForPlatform(Model model, String platformName) {
        LinkedList<Class> found_classes = new LinkedList<Class>();
        List<InstanceSpecification> instances = DeploymentQueries.getInstanceSpecificationsForPlatform(model, platformName);
        for (InstanceSpecification instanceSpecification : instances) {
            for (Classifier classifier : instanceSpecification.getClassifiers()) {
                found_classes.add(GeneralQueries.findClassInModel(model, classifier.getName()));
            }
        }
        return found_classes;
    }

    public static List<Class> getDefinedComponentsForPlatform2(Model model, String platformName) {
        LinkedList<Class> found_classes = new LinkedList<Class>();
        List<InstanceSpecification> inst_specs = DeploymentQueries.getInstanceSpecificationsForPlatform2(model, platformName);
        for (InstanceSpecification inst_spec : inst_specs) {
            for (Classifier classifier : inst_spec.getClassifiers()) {
                found_classes.add(GeneralQueries.findClassInModel(model, classifier.getName()));
            }
        }
        HashSet new_set = new HashSet(found_classes);
        LinkedList<Class> found_classes_2 = new LinkedList<Class>(new_set);
        return found_classes_2;
    }

    protected static boolean isPlatformInstanceSpecificationFromPlatform(NamedElement platformInstanceSpecification, String expectedPlatformName) {
        if (platformInstanceSpecification instanceof InstanceSpecification) {
            InstanceSpecification platformInstance = (InstanceSpecification)platformInstanceSpecification;
            for (Classifier classifier : platformInstance.getClassifiers()) {
                if (classifier.getName().toLowerCase().compareTo(expectedPlatformName) != 0) continue;
                return true;
            }
        }
        return false;
    }
}

