/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.safety.riskanalysis.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.papyrus.robotics.safety.riskanalysis.BodyRegion;
import org.eclipse.papyrus.robotics.safety.riskanalysis.HazardAnalysis;
import org.eclipse.papyrus.robotics.safety.riskanalysis.HazardAnalysisContext;
import org.eclipse.papyrus.robotics.safety.riskanalysis.HazardType;
import org.eclipse.papyrus.robotics.safety.riskanalysis.OccurenceEstimation;
import org.eclipse.papyrus.robotics.safety.riskanalysis.RiskEstimation;
import org.eclipse.papyrus.robotics.safety.riskanalysis.RiskIndex;
import org.eclipse.papyrus.robotics.safety.riskanalysis.RiskLevel;
import org.eclipse.papyrus.robotics.safety.riskanalysis.RiskReduction;
import org.eclipse.papyrus.robotics.safety.riskanalysis.RiskanalysisFactory;
import org.eclipse.papyrus.robotics.safety.riskanalysis.RiskanalysisPackage;
import org.eclipse.papyrus.robotics.safety.riskanalysis.impl.HazardAnalysisContextImpl;
import org.eclipse.papyrus.robotics.safety.riskanalysis.impl.HazardAnalysisImpl;
import org.eclipse.papyrus.robotics.safety.riskanalysis.impl.RiskReductionImpl;

public class RiskanalysisFactoryImpl
extends EFactoryImpl
implements RiskanalysisFactory {
    public static RiskanalysisFactory init() {
        try {
            RiskanalysisFactory theRiskanalysisFactory = (RiskanalysisFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/papyrus/robotics/safety/riskanalysis/1");
            if (theRiskanalysisFactory != null) {
                return theRiskanalysisFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new RiskanalysisFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createHazardAnalysis();
            }
            case 1: {
                return this.createRiskReduction();
            }
            case 2: {
                return this.createHazardAnalysisContext();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 3: {
                return this.createOccurenceEstimationFromString(eDataType, initialValue);
            }
            case 4: {
                return this.createRiskEstimationFromString(eDataType, initialValue);
            }
            case 5: {
                return this.createRiskIndexFromString(eDataType, initialValue);
            }
            case 6: {
                return this.createHazardTypeFromString(eDataType, initialValue);
            }
            case 7: {
                return this.createRiskLevelFromString(eDataType, initialValue);
            }
            case 8: {
                return this.createBodyRegionFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 3: {
                return this.convertOccurenceEstimationToString(eDataType, instanceValue);
            }
            case 4: {
                return this.convertRiskEstimationToString(eDataType, instanceValue);
            }
            case 5: {
                return this.convertRiskIndexToString(eDataType, instanceValue);
            }
            case 6: {
                return this.convertHazardTypeToString(eDataType, instanceValue);
            }
            case 7: {
                return this.convertRiskLevelToString(eDataType, instanceValue);
            }
            case 8: {
                return this.convertBodyRegionToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public HazardAnalysis createHazardAnalysis() {
        HazardAnalysisImpl hazardAnalysis = new HazardAnalysisImpl();
        return hazardAnalysis;
    }

    @Override
    public RiskReduction createRiskReduction() {
        RiskReductionImpl riskReduction = new RiskReductionImpl();
        return riskReduction;
    }

    @Override
    public HazardAnalysisContext createHazardAnalysisContext() {
        HazardAnalysisContextImpl hazardAnalysisContext = new HazardAnalysisContextImpl();
        return hazardAnalysisContext;
    }

    public OccurenceEstimation createOccurenceEstimationFromString(EDataType eDataType, String initialValue) {
        OccurenceEstimation result = OccurenceEstimation.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertOccurenceEstimationToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public RiskEstimation createRiskEstimationFromString(EDataType eDataType, String initialValue) {
        RiskEstimation result = RiskEstimation.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertRiskEstimationToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public RiskIndex createRiskIndexFromString(EDataType eDataType, String initialValue) {
        RiskIndex result = RiskIndex.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertRiskIndexToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public HazardType createHazardTypeFromString(EDataType eDataType, String initialValue) {
        HazardType result = HazardType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertHazardTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public RiskLevel createRiskLevelFromString(EDataType eDataType, String initialValue) {
        RiskLevel result = RiskLevel.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertRiskLevelToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public BodyRegion createBodyRegionFromString(EDataType eDataType, String initialValue) {
        BodyRegion result = BodyRegion.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertBodyRegionToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public RiskanalysisPackage getRiskanalysisPackage() {
        return (RiskanalysisPackage)this.getEPackage();
    }

    @Deprecated
    public static RiskanalysisPackage getPackage() {
        return RiskanalysisPackage.eINSTANCE;
    }
}

