/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.diagrams.dnd.strategies;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.papyrus.infra.gmfdiag.dnd.strategy.TransactionalDropStrategy;
import org.eclipse.papyrus.robotics.diagrams.dnd.commands.DropComponentDefinitionAsComponentInstanceCommand;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentDefinition;
import org.eclipse.papyrus.robotics.profile.robotics.components.System;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;

public class ComponentDefinitionToComponentInstanceDropStrategy
extends TransactionalDropStrategy {
    public static String ID = "org.eclipse.papyrus.robotics.diagrams.dnd.strategies.DropComponentDefinitionAsComponentInstance";

    public String getLabel() {
        return "Drop the ComponentDefinition item as ComponentInstance";
    }

    public String getDescription() {
        return "Drop a model item (class) stereotyped as ComponentDefinition into the assembly diagram (composite diagram) of a System (class) used by system builders. This will create a new Part, typed by the dropped classifier. The new Part into the destination class will be stereotyped as ComponentInstance.";
    }

    public Image getImage() {
        return null;
    }

    public String getID() {
        return ID;
    }

    public int getPriority() {
        return 0;
    }

    protected Command doGetCommand(Request request, EditPart targetEditPart) {
        if (request instanceof DropObjectsRequest) {
            DropObjectsRequest dropRequest = (DropObjectsRequest)request;
            EObject targetSemanticElement = this.getTargetSemanticElement(targetEditPart);
            if (dropRequest.getLocation() != null && targetEditPart instanceof GraphicalEditPart && targetSemanticElement instanceof Class && StereotypeUtil.isApplied((Element)((Class)targetSemanticElement), System.class)) {
                EObject sourceElement;
                GraphicalEditPart targetGraphicalEditPart = (GraphicalEditPart)targetEditPart;
                Class targetSystem = (Class)targetSemanticElement;
                List sourceElements = this.getSourceEObjects(request);
                if (sourceElements.size() == 1 && (sourceElement = (EObject)sourceElements.get(0)) instanceof Class && StereotypeUtil.isApplied((Element)((Class)sourceElement), ComponentDefinition.class)) {
                    Class sourceType = (Class)sourceElement;
                    ICommandProxy resultCommand = new ICommandProxy((ICommand)new DropComponentDefinitionAsComponentInstanceCommand(dropRequest, this.getTransactionalEditingDomain((EditPart)targetGraphicalEditPart), targetSystem, sourceType, targetGraphicalEditPart, this.getTargetView((EditPart)targetGraphicalEditPart)));
                    return resultCommand;
                }
            }
        }
        return null;
    }
}

