/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.requirements.sysml.common.ui.queries;

import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.emf.facet.custom.metamodel.custompt.IColor;
import org.eclipse.papyrus.emf.facet.custom.ui.internal.custompt.Color;
import org.eclipse.papyrus.emf.facet.efacet.core.IFacetManager;
import org.eclipse.papyrus.emf.facet.efacet.core.exception.DerivedTypedElementException;
import org.eclipse.papyrus.emf.facet.query.java.core.IJavaQuery2;
import org.eclipse.papyrus.emf.facet.query.java.core.IParameterValueList2;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Stereotype;

public class ReqSatisfied
implements IJavaQuery2<NamedElement, IColor> {
    protected boolean isRequirementStereotype(Stereotype stereotype) {
        if ("SysML::Requirements::Requirement".equals(stereotype.getQualifiedName())) {
            return true;
        }
        for (Class superStereotype : stereotype.getSuperClasses()) {
            if (!(superStereotype instanceof Stereotype) || !this.isRequirementStereotype((Stereotype)superStereotype)) continue;
            return true;
        }
        return false;
    }

    public IColor evaluate(NamedElement context, IParameterValueList2 parameterValues, IFacetManager facetManager) throws DerivedTypedElementException {
        Stereotype appStereotype = null;
        if (context.getAppliedStereotypes().size() > 0) {
            appStereotype = (Stereotype)context.getAppliedStereotypes().get(0);
        }
        if (context instanceof Class && appStereotype != null && this.isRequirementStereotype(appStereotype)) {
            if (context.getValue(appStereotype, "satisfiedBy") == null) {
                return new Color(255, 204, 0);
            }
            if (((EList)context.getValue(appStereotype, "satisfiedBy")).size() == 0) {
                return new Color(255, 204, 0);
            }
            return new Color(0, 0, 0);
        }
        return new Color(0, 0, 0);
    }
}

