/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.requirements.sysml.assistant.commands;

import java.text.DecimalFormat;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.requirements.sysml.preferences.Activator;
import org.eclipse.papyrus.sysml16.requirements.Requirement;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

public class SetIdCommand
extends RecordingCommand {
    protected Package selectedElement;
    protected TransactionalEditingDomain domain;

    public SetIdCommand(TransactionalEditingDomain domain, Package selectedElement) {
        super(domain, "SetIdFromPackageCommand");
        this.selectedElement = selectedElement;
        this.domain = domain;
    }

    protected void doExecute() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        int digit = store.getInt("REQUIREMENT_ID_DIGIT");
        String separator = store.getString("CHILD_REQUIREMENTS_SEPARATOR");
        int index = 1;
        for (PackageableElement packageableElement : this.selectedElement.getPackagedElements()) {
            if (UMLUtil.getStereotypeApplication((Element)packageableElement, Requirement.class) != null) {
                Requirement req = (Requirement)UMLUtil.getStereotypeApplication((Element)((Class)packageableElement), Requirement.class);
                DecimalFormat df = new DecimalFormat();
                df.setMinimumIntegerDigits(digit);
                String value = df.format(index);
                req.setId(this.selectedElement.getName() + separator + value);
                ++index;
                this.setIdforClassifier(req.getId(), (Classifier)((Class)packageableElement));
                continue;
            }
            if (!(packageableElement instanceof Class)) continue;
            Stereotype stereo = packageableElement.getApplicableStereotype("SysML::Requirements::Requirement");
            packageableElement.applyStereotype(stereo);
            Requirement req = (Requirement)UMLUtil.getStereotypeApplication((Element)((Class)packageableElement), Requirement.class);
            DecimalFormat df = new DecimalFormat();
            df.setMinimumIntegerDigits(digit);
            String value = df.format(index);
            req.setId(this.selectedElement.getName() + separator + value);
            ++index;
            this.setIdforClassifier(req.getId(), (Classifier)((Class)packageableElement));
        }
    }

    protected void setIdforClassifier(String prefix, Classifier classifier) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        int digit = store.getInt("REQUIREMENT_ID_DIGIT");
        String separator = store.getString("CHILD_REQUIREMENTS_SEPARATOR");
        int index = 1;
        for (Classifier nestedClassifier : ((Class)classifier).getNestedClassifiers()) {
            if (UMLUtil.getStereotypeApplication((Element)nestedClassifier, Requirement.class) != null) {
                Requirement req = (Requirement)UMLUtil.getStereotypeApplication((Element)((Class)nestedClassifier), Requirement.class);
                DecimalFormat df = new DecimalFormat();
                df.setMinimumIntegerDigits(digit);
                String value = df.format(index);
                req.setId(String.valueOf(prefix) + separator + value);
                ++index;
                this.setIdforClassifier(req.getId(), nestedClassifier);
                continue;
            }
            Stereotype stereo = nestedClassifier.getApplicableStereotype("SysML::Requirements::Requirement");
            nestedClassifier.applyStereotype(stereo);
            Requirement req = (Requirement)UMLUtil.getStereotypeApplication((Element)((Class)nestedClassifier), Requirement.class);
            DecimalFormat df = new DecimalFormat();
            df.setMinimumIntegerDigits(digit);
            String value = df.format(index);
            req.setId(this.selectedElement.getName() + separator + value);
            ++index;
            this.setIdforClassifier(req.getId(), nestedClassifier);
        }
    }
}

