/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.requirements.sysml14.papyrusre.modellibrary.papyrusrestandardutils.requirementandprocessconcerns;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ReviewStatusKind implements Enumerator
{
    TO_BE_REVIEWED(0, "ToBeReviewed", "ToBeReviewed"),
    ACCEPTED(1, "Accepted", "Accepted"),
    REJECTED(2, "Rejected", "Rejected");

    public static final int TO_BE_REVIEWED_VALUE = 0;
    public static final int ACCEPTED_VALUE = 1;
    public static final int REJECTED_VALUE = 2;
    private static final ReviewStatusKind[] VALUES_ARRAY;
    public static final List<ReviewStatusKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ReviewStatusKind[]{TO_BE_REVIEWED, ACCEPTED, REJECTED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ReviewStatusKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ReviewStatusKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ReviewStatusKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ReviewStatusKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ReviewStatusKind get(int value) {
        switch (value) {
            case 0: {
                return TO_BE_REVIEWED;
            }
            case 1: {
                return ACCEPTED;
            }
            case 2: {
                return REJECTED;
            }
        }
        return null;
    }

    private ReviewStatusKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

