/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.requirements.sysml14.papyrusre.modellibrary.papyrusrestandardutils.priorityandimportanceconcerns;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PriorityKind implements Enumerator
{
    MANDATORY(0, "Mandatory", "Mandatory"),
    OPTIONAL(1, "Optional", "Optional"),
    NOT_DEFINED(2, "NotDefined", "NotDefined");

    public static final int MANDATORY_VALUE = 0;
    public static final int OPTIONAL_VALUE = 1;
    public static final int NOT_DEFINED_VALUE = 2;
    private static final PriorityKind[] VALUES_ARRAY;
    public static final List<PriorityKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PriorityKind[]{MANDATORY, OPTIONAL, NOT_DEFINED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PriorityKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PriorityKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PriorityKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PriorityKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PriorityKind get(int value) {
        switch (value) {
            case 0: {
                return MANDATORY;
            }
            case 1: {
                return OPTIONAL;
            }
            case 2: {
                return NOT_DEFINED;
            }
        }
        return null;
    }

    private PriorityKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

