/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.kernel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SuspensionReasons implements Enumerator
{
    NONE(0, "NONE", "NONE"),
    ERROR_DETECTION(1, "ERROR_DETECTION", "ERROR_DETECTION"),
    USER_ACTION(2, "USER_ACTION", "USER_ACTION"),
    BREAKPOINT(3, "BREAKPOINT", "BREAKPOINT");

    public static final int NONE_VALUE = 0;
    public static final int ERROR_DETECTION_VALUE = 1;
    public static final int USER_ACTION_VALUE = 2;
    public static final int BREAKPOINT_VALUE = 3;
    private static final SuspensionReasons[] VALUES_ARRAY;
    public static final List<SuspensionReasons> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SuspensionReasons[]{NONE, ERROR_DETECTION, USER_ACTION, BREAKPOINT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SuspensionReasons get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SuspensionReasons result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SuspensionReasons getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SuspensionReasons result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SuspensionReasons get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return ERROR_DETECTION;
            }
            case 2: {
                return USER_ACTION;
            }
            case 3: {
                return BREAKPOINT;
            }
        }
        return null;
    }

    private SuspensionReasons(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

