/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.debug.breakpoint;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.moka.debug.MokaDebugPlugin;

public class MokaBreakpoint
extends Breakpoint {
    protected URI uriOfElement;
    private String label;
    protected static ResourceSet defaultResourceSet;

    public String getModelIdentifier() {
        return "org.eclipse.papyrus.moka.debug";
    }

    public URI getModelElementURI() {
        return this.uriOfElement;
    }

    public void toggleBreakpoint(EObject modelElement, String label) {
        String uri = modelElement.eResource().getURI().toString();
        String fragment = modelElement.eResource().getURIFragment(modelElement);
        IResource iresource = MokaBreakpoint.getIResource(modelElement.eResource());
        this.uriOfElement = EcoreUtil.getURI((EObject)modelElement);
        this.label = label;
        try {
            if (iresource != null) {
                IMarker marker = iresource.createMarker("org.eclipse.papyrus.moka.breakpointmarker");
                marker.setAttribute("uri", (Object)(String.valueOf(uri) + "#" + fragment));
                marker.setAttribute("org.eclipse.debug.core.id", (Object)this.getModelIdentifier());
                this.setMarker(marker);
                this.setEnabled(true);
                this.setPersisted(true);
            }
        }
        catch (CoreException ce) {
            MokaDebugPlugin.getDefault().logger.error("Problem while toggleBreakpointing " + this.uriOfElement, (Throwable)ce);
        }
    }

    public static IResource getIResource(Resource resource) {
        if (resource == null) {
            return null;
        }
        String uriPath = resource.getURI().toPlatformString(true);
        if (uriPath == null) {
            return null;
        }
        IFile iresource = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uriPath));
        if (iresource != null && iresource.exists()) {
            return iresource;
        }
        return null;
    }

    public String getLabel() {
        return this.label;
    }

    public void setMarker(IMarker marker) throws CoreException {
        if (this.uriOfElement == null) {
            this.uriOfElement = MokaBreakpoint.getURI(marker);
        }
        super.setMarker(marker);
    }

    public static URI getURI(IMarker marker) {
        String uriOfMarkerStr = marker.getAttribute("uri", null);
        if (uriOfMarkerStr != null) {
            return URI.createURI((String)uriOfMarkerStr);
        }
        return null;
    }
}

