/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.loci;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.moka.fuml.commonbehavior.IExecution;
import org.eclipse.papyrus.moka.fuml.commonbehavior.IOpaqueBehaviorExecution;
import org.eclipse.papyrus.moka.fuml.commonbehavior.OpaqueBehaviorExecution;
import org.eclipse.papyrus.moka.fuml.debug.Debug;
import org.eclipse.papyrus.moka.fuml.loci.IExecutionFactory;
import org.eclipse.papyrus.moka.fuml.loci.ILocus;
import org.eclipse.papyrus.moka.fuml.loci.ISemanticStrategy;
import org.eclipse.papyrus.moka.fuml.loci.ISemanticVisitor;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.IEvaluation;
import org.eclipse.papyrus.moka.fuml.structuredclassifiers.IExtensionalValue;
import org.eclipse.papyrus.moka.fuml.structuredclassifiers.IObject_;
import org.eclipse.papyrus.moka.fuml.tasks.IUMLTaskExecutionFactory;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.ValueSpecification;

public abstract class ExecutionFactory
implements IExecutionFactory {
    public ILocus locus;
    public List<IOpaqueBehaviorExecution> primitiveBehaviorPrototypes;
    public List<Type> builtInTypes = new ArrayList<Type>();
    public List<ISemanticStrategy> strategies = new ArrayList<ISemanticStrategy>();
    public IUMLTaskExecutionFactory taskFactory;

    public ExecutionFactory() {
        this.primitiveBehaviorPrototypes = new ArrayList<IOpaqueBehaviorExecution>();
    }

    public IExecution createExecution(Behavior behavior, IObject_ context) {
        IOpaqueBehaviorExecution execution;
        if (behavior instanceof OpaqueBehavior) {
            execution = this.instantiateOpaqueBehaviorExecution((OpaqueBehavior)behavior);
        } else {
            execution = (IExecution)this.instantiateVisitor((Element)behavior);
            execution.addType((Class)behavior);
            execution.createFeatureValues();
        }
        this.locus.add((IExtensionalValue)execution);
        if (context == null) {
            execution.setContext((IObject_)execution);
        } else {
            execution.setContext(context);
        }
        return execution;
    }

    public IEvaluation createEvaluation(ValueSpecification specification) {
        IEvaluation evaluation = (IEvaluation)this.instantiateVisitor((Element)specification);
        evaluation.setSpecification(specification);
        evaluation.setLocus(this.locus);
        return evaluation;
    }

    public abstract ISemanticVisitor instantiateVisitor(Element var1);

    public IOpaqueBehaviorExecution instantiateOpaqueBehaviorExecution(OpaqueBehavior behavior) {
        OpaqueBehaviorExecution execution = null;
        int i = 1;
        while (execution == null & i <= this.primitiveBehaviorPrototypes.size()) {
            IOpaqueBehaviorExecution prototype = this.primitiveBehaviorPrototypes.get(i - 1);
            if (prototype.getBehavior() == behavior) {
                execution = (OpaqueBehaviorExecution)prototype.copy();
            }
            ++i;
        }
        if (execution == null) {
            Debug.println("[instantiateOpaqueExecution] No prototype execution found for " + behavior.getName() + ".");
        }
        return execution;
    }

    public void addPrimitiveBehaviorPrototype(IOpaqueBehaviorExecution execution) {
        this.primitiveBehaviorPrototypes.add(execution);
    }

    public void addBuiltInType(Type type) {
        this.builtInTypes.add(type);
    }

    public Type getBuiltInType(String name) {
        Type type = null;
        int i = 1;
        while (type == null & i <= this.builtInTypes.size()) {
            Type currentType = this.builtInTypes.get(i - 1);
            if (currentType.getName().equals(name)) {
                type = currentType;
            }
            ++i;
        }
        return type;
    }

    public void setStrategy(ISemanticStrategy strategy) {
        int i = this.getStrategyIndex(strategy.getName());
        if (i <= this.strategies.size()) {
            this.strategies.remove(i - 1);
        }
        this.strategies.add(strategy);
    }

    public ISemanticStrategy getStrategy(String name) {
        int i = this.getStrategyIndex(name);
        ISemanticStrategy strategy = null;
        if (i <= this.strategies.size()) {
            strategy = this.strategies.get(i - 1);
        }
        return strategy;
    }

    public Integer getStrategyIndex(String name) {
        List<ISemanticStrategy> strategies = this.strategies;
        int i = 1;
        boolean unmatched = true;
        while (unmatched & i <= strategies.size()) {
            if (strategies.get(i - 1).getName().equals(name)) {
                unmatched = false;
                continue;
            }
            ++i;
        }
        return i;
    }

    public ILocus getLocus() {
        return this.locus;
    }

    public void setLocus(ILocus locus) {
        this.locus = locus;
    }

    public void setTaskFactory(IUMLTaskExecutionFactory factory) {
        this.taskFactory = factory;
    }

    public IUMLTaskExecutionFactory getTaskFactory() {
        return this.taskFactory;
    }
}

