/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fmi.util;

public class FMIOSDetector {
    private static final String WIN_DLL_EXTENSION = ".dll";
    private static final String UNIX_DLL_EXTENSION = ".so";
    private static String os = System.getProperty("os.name").toLowerCase();
    private static String arch = System.getProperty("os.arch").toLowerCase();

    public static String getOS() {
        if (FMIOSDetector.isWindows()) {
            if (FMIOSDetector.is64Bits()) {
                return "win64";
            }
            return "win32";
        }
        if (FMIOSDetector.isMac()) {
            if (FMIOSDetector.is64Bits()) {
                return "darwin64";
            }
            return "darwin32";
        }
        if (FMIOSDetector.isUnix()) {
            if (FMIOSDetector.is64Bits()) {
                return "linux64";
            }
            return "linux32";
        }
        return null;
    }

    public static String getDLLFileExtension() {
        return FMIOSDetector.isWindows() ? WIN_DLL_EXTENSION : UNIX_DLL_EXTENSION;
    }

    public static boolean is64Bits() {
        return arch.indexOf("64") >= 0;
    }

    public static boolean isWindows() {
        return os.indexOf("win") >= 0;
    }

    public static boolean isMac() {
        return os.indexOf("mac") >= 0;
    }

    public static boolean isUnix() {
        return os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0 || os.indexOf("aix") > 0;
    }

    public static boolean isSolaris() {
        return os.indexOf("sunos") >= 0;
    }
}

