/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fmi.master.fmilibrary;

import java.io.File;
import java.io.IOException;
import org.eclipse.papyrus.moka.fmi.fmiprofile.CS_FMU;
import org.eclipse.papyrus.moka.fmi.fmu.FMUParser;
import org.eclipse.papyrus.moka.fmi.fmu.FMUResource;
import org.eclipse.papyrus.moka.fmi.modeldescription.FmiModelDescriptionType;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Stereotype;

public class Fmi2Parameters {
    private String fmiVersion = "2.0";
    private String modelName = "";
    private String guid = "";
    private String sourceFiles = "";
    private Boolean canBeInstantiatedOnlyOncePerProcess = false;
    private Boolean canGetAndSetFMUstate = false;
    private Boolean canHandleVariableCommunicationStepSize = false;
    private Boolean canInterpolateInputs = false;
    private Boolean canRunAsynchronuously = false;
    private Boolean canNotUseMemoryManagementFunctions = false;
    private Boolean canSerializeFMUstate = false;
    private int maxOutputDerivativeOrder = 0;
    private String modelIdentifier = "";
    private Boolean needsExecutionTool = false;
    private Boolean providesDirectionalDerivative = false;
    private double startTime = 0.0;
    private double stopTime = 0.0;
    private double stepSize = 0.0;
    private double tolerance = 0.0;
    private String dllPath = "";
    private String fmuLocation = "";

    public Fmi2Parameters(Classifier type, Stereotype st) {
        CS_FMU fmu = (CS_FMU)type.getStereotypeApplication(st);
        if (fmu.getModelName() != null) {
            this.modelName = fmu.getModelName();
        }
        if (fmu.getGuid() != null) {
            this.guid = fmu.getGuid();
        }
        if (fmu.getSourceFiles() != null) {
            this.sourceFiles = fmu.getSourceFiles();
        }
        this.canBeInstantiatedOnlyOncePerProcess = fmu.isCanBeInstantiatedOnlyOncePerProcess();
        this.canGetAndSetFMUstate = fmu.isCanGetAndSetFMUstate();
        this.canHandleVariableCommunicationStepSize = fmu.isCanHandleVariableCommunicationStepSize();
        this.canInterpolateInputs = fmu.isCanInterpolateInputs();
        this.canRunAsynchronuously = fmu.isCanRunAsynchronuously();
        this.canNotUseMemoryManagementFunctions = fmu.isCanNotUseMemoryManagementFunctions();
        this.canSerializeFMUstate = fmu.isCanSerializeFMUstate();
        this.maxOutputDerivativeOrder = fmu.getMaxOutputDerivativeOrder();
        if (fmu.getModelIdentifier() != null) {
            this.modelIdentifier = fmu.getModelIdentifier();
        }
        this.needsExecutionTool = fmu.isNeedsExecutionTool();
        this.providesDirectionalDerivative = fmu.isProvidesDirectionalDerivative();
        this.startTime = fmu.getStartTime();
        this.stopTime = fmu.getStopTime();
        this.stepSize = fmu.getStepSize();
        this.tolerance = fmu.getTolerance();
        FmiModelDescriptionType modelDescription = fmu.getModelDescription();
        if (modelDescription != null && modelDescription.eResource() instanceof FMUResource) {
            FMUResource fmuRes = (FMUResource)modelDescription.eResource();
            FMUParser handler = fmuRes.getFmuParser();
            try {
                if (handler.getCosimulationLibrary() != null) {
                    this.dllPath = handler.getCosimulationLibrary().getAbsolutePath();
                }
                if (handler.getFMUFolder() != null) {
                    this.fmuLocation = handler.getFMUFolder().getAbsolutePath();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String getFmiVersion() {
        return this.fmiVersion;
    }

    public void setFmiVersion(String fmiVersion) {
        this.fmiVersion = fmiVersion;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public String getSourceFiles() {
        return this.sourceFiles;
    }

    public void setSourceFiles(String sourceFiles) {
        this.sourceFiles = sourceFiles;
    }

    public Boolean getCanBeInstantiatedOnlyOncePerProcess() {
        return this.canBeInstantiatedOnlyOncePerProcess;
    }

    public void setCanBeInstantiatedOnlyOncePerProcess(Boolean canBeInstantiatedOnlyOncePerProcess) {
        this.canBeInstantiatedOnlyOncePerProcess = canBeInstantiatedOnlyOncePerProcess;
    }

    public Boolean getCanGetAndSetFMUstate() {
        return this.canGetAndSetFMUstate;
    }

    public void setCanGetAndSetFMUstate(Boolean canGetAndSetFMUstate) {
        this.canGetAndSetFMUstate = canGetAndSetFMUstate;
    }

    public Boolean getCanHandleVariableCommunicationStepSize() {
        return this.canHandleVariableCommunicationStepSize;
    }

    public void setCanHandleVariableCommunicationStepSize(Boolean canHandleVariableCommunicationStepSize) {
        this.canHandleVariableCommunicationStepSize = canHandleVariableCommunicationStepSize;
    }

    public Boolean getCanInterpolateInputs() {
        return this.canInterpolateInputs;
    }

    public void setCanInterpolateInputs(Boolean canInterpolateInputs) {
        this.canInterpolateInputs = canInterpolateInputs;
    }

    public Boolean getCanRunAsynchronuously() {
        return this.canRunAsynchronuously;
    }

    public void setCanRunAsynchronuously(Boolean canRunAsynchronuously) {
        this.canRunAsynchronuously = canRunAsynchronuously;
    }

    public Boolean getCanNotUseMemoryManagementFunctions() {
        return this.canNotUseMemoryManagementFunctions;
    }

    public void setCanNotUseMemoryManagementFunctions(Boolean canNotUseMemoryManagementFunctions) {
        this.canNotUseMemoryManagementFunctions = canNotUseMemoryManagementFunctions;
    }

    public Boolean getCanSerializeFMUstate() {
        return this.canSerializeFMUstate;
    }

    public void setCanSerializeFMUstate(Boolean canSerializeFMUstate) {
        this.canSerializeFMUstate = canSerializeFMUstate;
    }

    public int getMaxOutputDerivativeOrder() {
        return this.maxOutputDerivativeOrder;
    }

    public void setMaxOutputDerivativeOrder(int maxOutputDerivativeOrder) {
        this.maxOutputDerivativeOrder = maxOutputDerivativeOrder;
    }

    public String getModelIdentifier() {
        return this.modelIdentifier;
    }

    public void setModelIdentifier(String modelIdentifier) {
        this.modelIdentifier = modelIdentifier;
    }

    public Boolean getNeedsExecutionTool() {
        return this.needsExecutionTool;
    }

    public void setNeedsExecutionTool(Boolean needsExecutionTool) {
        this.needsExecutionTool = needsExecutionTool;
    }

    public Boolean getProvidesDirectionalDerivative() {
        return this.providesDirectionalDerivative;
    }

    public void setProvidesDirectionalDerivative(Boolean providesDirectionalDerivative) {
        this.providesDirectionalDerivative = providesDirectionalDerivative;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public void setStartTime(double startTime) {
        this.startTime = startTime;
    }

    public double getStopTime() {
        return this.stopTime;
    }

    public void setStopTime(double stopTime) {
        this.stopTime = stopTime;
    }

    public double getStepSize() {
        return this.stepSize;
    }

    public void setStepSize(double stepSize) {
        this.stepSize = stepSize;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    public String getDllPath() {
        return this.dllPath;
    }

    public void setDllPath(String dllPath) {
        this.dllPath = dllPath;
    }

    public String getFmuLocation() {
        return this.fmuLocation;
    }

    public void setFmuLocation(String fmuLocation) {
        this.fmuLocation = fmuLocation;
    }

    public String getResourceFolder() {
        if (this.getFmuLocation() != null) {
            return String.valueOf(this.getFmuLocation()) + File.separator + "resources";
        }
        return null;
    }
}

