/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.animation.presentation.data;

import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.moka.animation.presentation.data.AnimatingInstanceNode;
import org.eclipse.papyrus.moka.animation.presentation.data.AnimationTreeNode;
import org.eclipse.papyrus.moka.animation.presentation.data.DiagramAnimationNode;
import org.eclipse.papyrus.moka.animation.presentation.data.IAnimationTreeNode;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IObject_;

public final class AnimationTreeNodeFactory {
    public static AnimationTreeNodeFactory INSTANCE;

    private AnimationTreeNodeFactory() {
    }

    public static AnimationTreeNodeFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AnimationTreeNodeFactory();
        }
        return INSTANCE;
    }

    public IAnimationTreeNode createNode(Object input) {
        IAnimationTreeNode node = null;
        if (input == null) {
            node = this.createAnimationTreeNode();
        } else if (input instanceof Diagram) {
            node = this.createDiagramAnimationNode((Diagram)input);
        } else if (input instanceof IObject_) {
            node = this.createAnimatingInstanceNode((IObject_)input);
        }
        return node;
    }

    public IAnimationTreeNode createAnimationTreeNode() {
        return new AnimationTreeNode();
    }

    public IAnimationTreeNode createAnimatingInstanceNode(IObject_ value) {
        AnimatingInstanceNode node = new AnimatingInstanceNode();
        node.setInstance(value);
        return node;
    }

    public IAnimationTreeNode createDiagramAnimationNode(Diagram diagram) {
        DiagramAnimationNode node = new DiagramAnimationNode();
        node.setAnimatedDiagram(diagram);
        return node;
    }
}

