/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.externalcontrol.semantics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.papyrus.moka.externalcontrol.advice.IControllerAdvice;
import org.eclipse.papyrus.moka.externalcontrol.advice.IControllerAdviceFactory;
import org.eclipse.papyrus.moka.externalcontrol.controller.AbstractExternallyControlledVisitor;
import org.eclipse.papyrus.moka.externalcontrol.controller.ExternalController;
import org.eclipse.papyrus.moka.externalcontrol.semantics.ExternallyControlledActionActivation;
import org.eclipse.papyrus.moka.externalcontrol.semantics.ExternallyControlledActivityEdgeInstance;
import org.eclipse.papyrus.moka.externalcontrol.semantics.ExternallyControlledActivityExecution;
import org.eclipse.papyrus.moka.externalcontrol.semantics.ExternallyControlledCallActionActivation;
import org.eclipse.papyrus.moka.fuml.Semantics.Activities.IntermediateActivities.IActivityEdgeInstance;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.IExecutionFactory;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.ISemanticVisitor;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Actions.BasicActions.ActionActivation;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Actions.BasicActions.CallActionActivation;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Activities.IntermediateActivities.ActivityEdgeInstance;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Activities.IntermediateActivities.ActivityExecution;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Loci.LociL1.ExecutionFactory;
import org.eclipse.uml2.uml.Element;

public class ExternalControlExecutionFactory
extends ExecutionFactory {
    IExecutionFactory delegatedExecutionFactory;
    ExternalController controller;
    List<IControllerAdviceFactory> adviceFactories = new ArrayList<IControllerAdviceFactory>();

    public ExternalControlExecutionFactory(IExecutionFactory delegatedExecutionFactory, ExternalController controller, IControllerAdviceFactory ... adviceFactories) {
        this.init(delegatedExecutionFactory, controller, Arrays.asList(adviceFactories));
    }

    public ExternalControlExecutionFactory(IExecutionFactory delegatedExecutionFactory, ExternalController controller, List<IControllerAdviceFactory> adviceFactories) {
        this.init(delegatedExecutionFactory, controller, adviceFactories);
    }

    private void init(IExecutionFactory delegatedExecutionFactory, ExternalController controller, List<IControllerAdviceFactory> adviceFactories) {
        if (delegatedExecutionFactory == null) {
            throw new RuntimeException("Delegated Execution Factory can't be null");
        }
        this.delegatedExecutionFactory = delegatedExecutionFactory;
        if (controller == null) {
            throw new RuntimeException("The external controller can't be null");
        }
        this.controller = controller;
        for (IControllerAdviceFactory adviceFactory : adviceFactories) {
            this.adviceFactories.add(adviceFactory);
        }
    }

    public ISemanticVisitor instantiateVisitor(Element element) {
        ISemanticVisitor delegatedVisitor = this.delegatedExecutionFactory.instantiateVisitor(element);
        AbstractExternallyControlledVisitor controlledVisitor = null;
        List<IControllerAdvice> adviceList = this.getControllerAdvices(element, delegatedVisitor);
        if (delegatedVisitor instanceof ActivityExecution) {
            controlledVisitor = new ExternallyControlledActivityExecution((ActivityExecution)delegatedVisitor, this.controller, adviceList);
        } else if (delegatedVisitor instanceof CallActionActivation) {
            controlledVisitor = new ExternallyControlledCallActionActivation((CallActionActivation)delegatedVisitor, this.controller, adviceList);
        }
        if (!adviceList.isEmpty() && controlledVisitor == null) {
            if (delegatedVisitor instanceof ActivityEdgeInstance) {
                controlledVisitor = new ExternallyControlledActivityEdgeInstance((IActivityEdgeInstance)delegatedVisitor, this.controller, adviceList);
            } else if (delegatedVisitor instanceof ActionActivation) {
                controlledVisitor = new ExternallyControlledActionActivation((ActionActivation)delegatedVisitor, this.controller, adviceList);
            }
        }
        if (controlledVisitor != null) {
            for (IControllerAdvice advice : adviceList) {
                advice.setControlledVisitor(controlledVisitor);
            }
            return controlledVisitor;
        }
        return delegatedVisitor;
    }

    private List<IControllerAdvice> getControllerAdvices(Element element, ISemanticVisitor delegatedVisitor) {
        ArrayList<IControllerAdvice> adviceList = new ArrayList<IControllerAdvice>();
        for (IControllerAdviceFactory factory : this.adviceFactories) {
            IControllerAdvice advice = factory.getControllerAdvice(element, delegatedVisitor);
            if (advice == null) continue;
            adviceList.add(advice);
        }
        return adviceList;
    }
}

