/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.datavisualization.service;

import org.eclipse.papyrus.moka.datavisualization.profile.DataSource;
import org.eclipse.papyrus.moka.datavisualization.profile.ValueSeries;
import org.eclipse.papyrus.moka.datavisualization.service.DataSourceVariableID;
import org.eclipse.papyrus.moka.datavisualization.service.DataVisualizationService;
import org.eclipse.papyrus.moka.datavisualization.service.LocalDataPort;
import org.eclipse.papyrus.moka.datavisualization.service.VariableDataEntry;
import org.eclipse.papyrus.moka.datavisualization.service.VariableEntryTable;
import org.eclipse.papyrus.moka.datavisualization.service.VariableImpl;
import org.eclipse.papyrus.moka.datavisualization.ui.GraphBuilderHelper;
import org.eclipse.papyrus.moka.xygraph.mapping.common.Variable;
import org.eclipse.papyrus.moka.xygraph.mapping.common.XYGraphBinder;
import org.eclipse.papyrus.moka.xygraph.mapping.common.XYGraphCoordinator;
import org.eclipse.papyrus.moka.xygraph.mapping.util.DataBatch;
import org.eclipse.papyrus.moka.xygraph.mapping.writing.ModelWritingStrategyFactory;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.TraceDescriptor;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.XYGraphDescriptor;

public class DataSeriesXYGraphCoordinator
extends XYGraphCoordinator
implements LocalDataPort {
    private VariableEntryTable<VariableDataEntry> varTable = new VariableEntryTable();

    public DataSeriesXYGraphCoordinator(XYGraphBinder binder, ModelWritingStrategyFactory factory) {
        super(binder, factory);
    }

    protected void onXYGraphBuilt() {
        super.onXYGraphBuilt();
        DataVisualizationService.getInstance().importNewDataValueSet((DataSource)this.getXYGraphDescriptor().getDataSource());
        this.addNewVariables();
        DataVisualizationService.getInstance().addDataPort(this);
        this.synchronizeTracesVisibility();
        DataVisualizationService.getInstance().pullAllData(this);
        this.rescaleAxesIfNeeded();
    }

    private VariableDataEntry makeEntryFor(Variable.VariableID id, TraceDescriptor tDesc) {
        VariableImpl var = new VariableImpl(tDesc.getName(), id);
        return new VariableDataEntry(var, tDesc);
    }

    private void addNewVariables() {
        for (TraceDescriptor tDesc : this.getXYGraphDescriptor().getTraceDescriptors()) {
            DataSourceVariableID id = new DataSourceVariableID((ValueSeries)tDesc.getDataSource());
            if (this.isVariableSupported(id)) continue;
            this.getVariablesTable().addEntryFor(id, this.makeEntryFor(id, tDesc));
        }
    }

    @Override
    public VariableEntryTable<VariableDataEntry> getVariablesTable() {
        return this.varTable;
    }

    @Override
    public void doAddNewVariable(Variable.VariableID varId) {
        if (!(varId instanceof DataSourceVariableID)) {
            throw new UnsupportedOperationException("For the moment only DataSourceVariables are supported");
        }
        DataSourceVariableID dsId = (DataSourceVariableID)varId;
        XYGraphDescriptor xy = this.graphMap.getXYGraphDescriptor();
        TraceDescriptor tDesc = GraphBuilderHelper.buildTraceFor(xy, (ValueSeries)dsId.getDataSource());
        this.factory.getXYGraphUpdateStrategy().addTrace(xy, tDesc);
    }

    @Override
    public void doRemoveVariable(Variable.VariableID varId) {
        VariableDataEntry entry = (VariableDataEntry)this.varTable.getEntry(varId);
        TraceDescriptor tDesc = entry.getTraceDescriptor();
        this.removeTrace(tDesc);
    }

    @Override
    public void doAddNewSample(Variable.VariableID varId, Double x, Double y) {
        VariableDataEntry entry = (VariableDataEntry)this.varTable.getEntry(varId);
        TraceDescriptor tDesc = entry.getTraceDescriptor();
        this.graphMap.addTraceSample(tDesc, x.doubleValue(), y.doubleValue());
    }

    @Override
    public void doResetValues(Variable.VariableID varId, DataBatch x, DataBatch y) {
        VariableDataEntry entry = (VariableDataEntry)this.varTable.getEntry(varId);
        TraceDescriptor tDesc = entry.getTraceDescriptor();
        this.graphMap.setTraceData(tDesc, x, y);
    }

    public void dispose() {
        super.dispose();
        DataVisualizationService.getInstance().removeDataPort(this);
    }
}

