/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.odt.internal.util;

import com.sun.star.text.TextContentAnchorType;
import com.sun.star.text.XTextCursor;
import org.eclipse.papyrus.model2doc.odt.internal.editor.ODTEditor;
import org.eclipse.papyrus.model2doc.odt.internal.util.IImageCropper;
import org.eclipse.papyrus.model2doc.odt.internal.util.IImageResizer;
import org.eclipse.papyrus.model2doc.odt.internal.util.ParagraphImageWriter;
import org.eclipse.papyrus.model2doc.odt.internal.util.PropertySetUtil;

public class CellImageWriter
extends ParagraphImageWriter {
    private boolean useAllCellSpace = false;

    public CellImageWriter(ODTEditor odtEditor) {
        super(odtEditor);
    }

    public CellImageWriter(ODTEditor odtEditor, IImageResizer imageResizer) {
        super(odtEditor, imageResizer);
    }

    public CellImageWriter(ODTEditor odtEditor, IImageResizer imageResizer, IImageCropper imageCropper) {
        super(odtEditor, imageResizer, imageCropper);
    }

    public void setUseAllSpace(boolean useAllCellSpace) {
        this.useAllCellSpace = useAllCellSpace;
    }

    @Override
    protected void configure() {
        super.configure();
        this.setGenerateCaption(false);
        this.setEndParagraph(false);
        this.setWrapImageInTextFrame(false);
        this.setImageAnchor(TextContentAnchorType.AS_CHARACTER);
    }

    @Override
    public void writeImage(XTextCursor xTextCursor, String imageFilePath, String caption) {
        super.writeImage(xTextCursor, imageFilePath, caption);
        if (this.useAllCellSpace) {
            PropertySetUtil.setProperty(xTextCursor, "ParaTopMargin", 0);
            PropertySetUtil.setProperty(xTextCursor, "ParaBottomMargin", 0);
        }
    }
}

