/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.odt.internal.util;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XDependentTextField;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextFieldsSupplier;
import com.sun.star.text.XTextRange;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import org.eclipse.papyrus.model2doc.odt.Activator;
import org.eclipse.papyrus.model2doc.odt.internal.editor.ODTEditor;

public class CaptionUtils {
    public static final String TEXT_FIELDMASTER_SET_EXPRESSION_FIGURE = "com.sun.star.text.fieldmaster.SetExpression.Figure";
    public static final String TEXTFIELD_SET_EXPRESSION = "com.sun.star.text.textfield.SetExpression";

    private CaptionUtils() {
    }

    public static final void writeFigureCaption(XTextCursor xTextCursor, String caption, ODTEditor odtEditor) {
        try {
            XTextFieldsSupplier supplier = (XTextFieldsSupplier)UnoRuntime.queryInterface(XTextFieldsSupplier.class, (Object)odtEditor.getXTextDocument());
            XNameAccess masters = supplier.getTextFieldMasters();
            Object masterSetExpressionForFigure = masters.getByName(TEXT_FIELDMASTER_SET_EXPRESSION_FIGURE);
            XMultiServiceFactory xMultiServiceFactory = odtEditor.getXMultiServiceFactory();
            Object textFieldSetExpression = xMultiServiceFactory.createInstance(TEXTFIELD_SET_EXPRESSION);
            XPropertySet textFieldSetExpressionPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)textFieldSetExpression);
            textFieldSetExpressionPropertySet.setPropertyValue("NumberingType", (Object)4);
            textFieldSetExpressionPropertySet.setPropertyValue("NumberFormat", (Object)16);
            textFieldSetExpressionPropertySet.setPropertyValue("Content", (Object)"Figure + 1");
            XDependentTextField xDependeantTextField = (XDependentTextField)UnoRuntime.queryInterface(XDependentTextField.class, (Object)textFieldSetExpression);
            xDependeantTextField.attachTextFieldMaster((XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)masterSetExpressionForFigure));
            xTextCursor.getText().insertString((XTextRange)xTextCursor, "Figure ", false);
            xTextCursor.getText().insertTextContent((XTextRange)xTextCursor, (XTextContent)xDependeantTextField, true);
            if (caption != null && !caption.isEmpty()) {
                xTextCursor.getText().insertString((XTextRange)xTextCursor, ": " + caption, false);
            }
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }
}

