/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.odt.internal.transcription;

import com.sun.star.beans.IllegalTypeException;
import com.sun.star.beans.NotRemoveableException;
import com.sun.star.beans.PropertyExistException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertyContainer;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexAccess;
import com.sun.star.document.XDocumentProperties;
import com.sun.star.document.XDocumentPropertiesSupplier;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.style.BreakType;
import com.sun.star.text.XDocumentIndex;
import com.sun.star.text.XDocumentIndexesSupplier;
import com.sun.star.text.XPageCursor;
import com.sun.star.text.XParagraphCursor;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextViewCursor;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.model2doc.core.author.IAuthor;
import org.eclipse.papyrus.model2doc.core.builtintypes.AbstractList;
import org.eclipse.papyrus.model2doc.core.builtintypes.AbstractTable;
import org.eclipse.papyrus.model2doc.core.builtintypes.BasicList;
import org.eclipse.papyrus.model2doc.core.builtintypes.IFileReference;
import org.eclipse.papyrus.model2doc.core.builtintypes.ListItem;
import org.eclipse.papyrus.model2doc.core.builtintypes.TextListItem;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.IDocumentGeneratorConfiguration;
import org.eclipse.papyrus.model2doc.core.transcription.CoverPage;
import org.eclipse.papyrus.model2doc.core.transcription.ImageDescription;
import org.eclipse.papyrus.model2doc.core.transcription.Transcription;
import org.eclipse.papyrus.model2doc.odt.Activator;
import org.eclipse.papyrus.model2doc.odt.editor.StyleEditor;
import org.eclipse.papyrus.model2doc.odt.editor.StyleEditorFactory;
import org.eclipse.papyrus.model2doc.odt.internal.editor.ODTEditor;
import org.eclipse.papyrus.model2doc.odt.internal.util.PropertySetUtil;
import org.eclipse.papyrus.model2doc.odt.internal.util.WriteUtil;
import org.eclipse.papyrus.model2doc.odt.service.StyleService;
import org.eclipse.papyrus.model2doc.odt.service.StyleServiceImpl;
import org.eclipse.papyrus.model2doc.odt.service.WriteService;
import org.eclipse.papyrus.model2doc.odt.service.WriteServiceImpl;

public class ODTTranscription
implements Transcription {
    private static final String TABLE_OF_FIGURE_TYPE = "com.sun.star.text.IllustrationsIndex";
    private static final String TABLE_OF_CONTENTS_TYPE = "com.sun.star.text.ContentIndex";
    protected XText text = null;
    protected XTextCursor cursor = null;
    protected StyleEditor styleEditor = null;
    protected ODTEditor odtEditor = null;
    protected IDocumentGeneratorConfiguration odtGeneratorConfig = null;
    protected WriteService writeService = null;
    protected StyleService styleService = null;
    protected List<XDocumentIndex> tablesOfIndexes = new ArrayList<XDocumentIndex>();

    public ODTTranscription(StyleEditor styleEditor, IDocumentGeneratorConfiguration odtGeneratorConfig) {
        this.odtEditor = new ODTEditor(odtGeneratorConfig);
        if (this.odtEditor.getXTextDocument() != null) {
            this.text = this.odtEditor.getXTextDocument().getText();
            this.cursor = this.text.createTextCursor();
            this.styleEditor = styleEditor == null ? StyleEditorFactory.INSTANCE.getDefaultStyleEditor() : styleEditor;
            this.odtGeneratorConfig = odtGeneratorConfig;
            this.writeService = new WriteServiceImpl();
            this.styleService = new StyleServiceImpl();
            XDocumentIndexesSupplier indexSupplier = (XDocumentIndexesSupplier)UnoRuntime.queryInterface(XDocumentIndexesSupplier.class, (Object)this.odtEditor.getXTextDocument());
            XIndexAccess indexes = indexSupplier.getDocumentIndexes();
            int i = 0;
            while (i < indexes.getCount()) {
                try {
                    Object tmp = indexes.getByIndex(i);
                    XDocumentIndex documentIndex = (XDocumentIndex)UnoRuntime.queryInterface(XDocumentIndex.class, (Object)tmp);
                    if (documentIndex != null) {
                        this.tablesOfIndexes.add(documentIndex);
                    }
                }
                catch (IndexOutOfBoundsException | WrappedTargetException e) {
                    Activator.log.error(e);
                }
                ++i;
            }
        }
    }

    public void writeDocumentMainTitle(String documentTitle) {
        this.writeService.addText(this.cursor, documentTitle);
        this.styleEditor.applyMainTitleStyle(this.text);
        this.writeService.endParagraph(this.cursor);
    }

    public void setDocumentMaintTitleProperty(String documentTitle) {
        if (documentTitle == null || documentTitle.isEmpty()) {
            return;
        }
        XTextDocument document = this.odtEditor.getXTextDocument();
        XDocumentPropertiesSupplier xsDocProp = (XDocumentPropertiesSupplier)UnoRuntime.queryInterface(XDocumentPropertiesSupplier.class, (Object)document);
        XDocumentProperties props = xsDocProp.getDocumentProperties();
        props.setTitle(documentTitle);
    }

    public void writeSectionTitle(String sectionTitle, int sectionLevel) {
        this.writeService.addParagraph(this.cursor, sectionTitle, false);
        this.styleEditor.applySectionTitleStyle(this.cursor, sectionLevel);
    }

    public void writeParagraph(String paragraph, boolean processRichText) {
        this.writeService.addParagraph(this.cursor, paragraph, true);
    }

    public void writeList(AbstractList abstractList, boolean processRichText) {
        if (!(abstractList instanceof BasicList)) {
            Activator.log.warn(NLS.bind((String)"The list of type {0} is not supported by {1}.", (Object)abstractList.eClass().getName(), (Object)this.getClass().getName()));
            return;
        }
        BasicList basicList = (BasicList)abstractList;
        Iterator iter = basicList.getItems().iterator();
        while (iter.hasNext()) {
            this.writeListItem((ListItem)iter.next());
        }
    }

    private void writeListItem(ListItem listItem) {
        int itemLevel = listItem.getLevel();
        if (!(listItem instanceof TextListItem)) {
            Activator.log.warn(NLS.bind((String)"The list item  of type {0} is not supported by {1}.", (Object)listItem.eClass().getName(), (Object)this.getClass().getName()));
            return;
        }
        TextListItem textItem = (TextListItem)listItem;
        this.writeService.addParagraph(this.cursor, textItem.getText(), true);
        this.styleService.applyStylePreviousParagraph(this.cursor, "NumberingStyleName", "List 2");
        this.styleService.applyStylePreviousParagraph(this.cursor, "NumberingLevel", (short)itemLevel);
        Iterator subItemIterator = listItem.getSubItems().iterator();
        while (subItemIterator.hasNext()) {
            this.writeListItem((ListItem)subItemIterator.next());
        }
    }

    public void writeCoverPage(CoverPage coverPage) {
        XPageCursor pageCursor = this.odtEditor.getPageCursor();
        pageCursor.jumpToLastPage();
        this.cursor = this.text.createTextCursorByRange((XTextRange)UnoRuntime.queryInterface(XTextViewCursor.class, (Object)pageCursor));
    }

    public void refreshTablesOfIndexes() {
        for (XDocumentIndex current : this.tablesOfIndexes) {
            current.update();
        }
    }

    public void writeTableOfFigures(String tofTitle) {
        this.writePageOfContents(tofTitle, TABLE_OF_FIGURE_TYPE);
    }

    public void writeTableOfContents(String tocTitle) {
        this.writePageOfContents(tocTitle, TABLE_OF_CONTENTS_TYPE);
    }

    protected void writePageOfContents(String pageTitle, String libreOfficePagetype) {
        try {
            XTextCursor mxDocCursor = this.cursor;
            XText mxDocText = this.cursor.getText();
            XMultiServiceFactory mxDocFactory = this.odtEditor.getXMultiServiceFactory();
            mxDocCursor.gotoEnd(false);
            mxDocText.insertControlCharacter((XTextRange)mxDocCursor, (short)0, false);
            XParagraphCursor xParaCursor = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)mxDocCursor);
            xParaCursor.gotoPreviousParagraph(false);
            XPropertySet xIndex = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)mxDocFactory.createInstance(libreOfficePagetype));
            if (TABLE_OF_CONTENTS_TYPE.equals(libreOfficePagetype)) {
                xIndex.setPropertyValue("CreateFromOutline", (Object)true);
            } else if (TABLE_OF_FIGURE_TYPE.equals(libreOfficePagetype)) {
                xIndex.setPropertyValue("CreateFromLabels", (Object)true);
                xIndex.setPropertyValue("LabelCategory", (Object)"Figure");
                xIndex.setPropertyValue("LabelDisplayType", (Object)2);
            }
            xIndex.setPropertyValue("Title", (Object)pageTitle);
            XTextContent xIndexContent = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)xIndex);
            mxDocText.insertTextContent((XTextRange)mxDocCursor, xIndexContent, false);
            XDocumentIndex xDocIndex = (XDocumentIndex)UnoRuntime.queryInterface(XDocumentIndex.class, (Object)xIndex);
            xDocIndex.update();
            this.tablesOfIndexes.add(xDocIndex);
            this.writeService.endParagraph((XTextCursor)xParaCursor);
            XPropertySet cursorProperty = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xParaCursor);
            try {
                cursorProperty.setPropertyValue("BreakType", (Object)BreakType.PAGE_BEFORE);
            }
            catch (Exception e) {
                Activator.log.error("Failed to create page break. Exception: ", (Throwable)e);
            }
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    public void importImage(ImageDescription image, String caption) {
        this.writeService.addImageLink(image, caption, this.cursor, this.odtEditor);
        this.styleEditor.applyImageStyle(this.cursor);
    }

    public void writeImage(String imagePath, String caption) {
        String newImagePath = ODTEditor.convertToLibreOfficeFileURI(imagePath);
        this.writeService.addImageLink(newImagePath, caption, this.cursor, this.odtEditor);
        this.styleEditor.applyImageStyle(this.cursor);
    }

    public String save(String label) {
        String documentName = this.odtGeneratorConfig.getDocumentName();
        if (documentName != null && !documentName.isEmpty()) {
            return this.odtEditor.save(documentName);
        }
        return this.odtEditor.save(label);
    }

    public IDocumentGeneratorConfiguration getGeneratorConfig() {
        return this.odtGeneratorConfig;
    }

    public void writeImageSubtitle(ImageDescription image) {
        this.writeService.addParagraph(this.cursor, image.getSubtitle(), false);
        this.styleEditor.applyImageSubtitleStyle(this.cursor);
    }

    public void writeTable(AbstractTable table) {
        WriteUtil.writeTable(this.cursor, table, this.odtEditor);
    }

    public boolean canExecute() {
        return this.odtEditor.getXTextDocument() != null;
    }

    public void writeAuthors(Collection<IAuthor> authors) {
        this.setDocumentAuthorsProperty(authors);
    }

    public void writeVersion(String version) {
        this.setDocumentVersionProperty(version);
    }

    public void insertFile(IFileReference fileReference) {
        URL url = fileReference.getFileAccessor().createInputFileURL();
        this.writeService.insertTextFile(this.cursor, url.toString());
    }

    public void insertEmptyLine() {
        this.writeService.endParagraph(this.cursor);
    }

    private void addPageBreak(PageBreak pageBreak) {
        int breakValue = -1;
        switch (pageBreak) {
            case BEFORE: {
                breakValue = BreakType.PAGE_BEFORE.getValue();
                break;
            }
            case AFTER: {
                breakValue = BreakType.PAGE_AFTER.getValue();
                break;
            }
            case BOTH: {
                breakValue = BreakType.PAGE_BOTH.getValue();
                break;
            }
            default: {
                breakValue = BreakType.PAGE_BOTH.getValue();
            }
        }
        WriteUtil.addControlCharacter(this.cursor, (short)breakValue);
    }

    private void addPageBreak() {
        WriteUtil.addControlCharacter(this.cursor, (short)BreakType.PAGE_AFTER.getValue());
        PropertySetUtil.setProperty(this.cursor, "BreakType", 4);
        this.cursor.gotoEnd(false);
        WriteUtil.addControlCharacter(this.cursor, (short)BreakType.PAGE_AFTER.getValue());
    }

    public void setDocumentVersionProperty(String version) {
        if (version == null || version.isEmpty()) {
            return;
        }
        XTextDocument document = this.odtEditor.getXTextDocument();
        XDocumentPropertiesSupplier xsDocProp = (XDocumentPropertiesSupplier)UnoRuntime.queryInterface(XDocumentPropertiesSupplier.class, (Object)document);
        XDocumentProperties props = xsDocProp.getDocumentProperties();
        XPropertyContainer userDefined = props.getUserDefinedProperties();
        try {
            userDefined.removeProperty("Version");
        }
        catch (NotRemoveableException | UnknownPropertyException throwable) {
            // empty catch block
        }
        try {
            userDefined.addProperty("Version", (short)128, (Object)version);
        }
        catch (IllegalTypeException | PropertyExistException | IllegalArgumentException e) {
            Activator.log.error(e);
        }
    }

    public void setDocumentAuthorsProperty(Collection<IAuthor> authors) {
        if (authors.size() > 0) {
            XTextDocument document = this.odtEditor.getXTextDocument();
            XDocumentPropertiesSupplier xsDocProp = (XDocumentPropertiesSupplier)UnoRuntime.queryInterface(XDocumentPropertiesSupplier.class, (Object)document);
            XDocumentProperties props = xsDocProp.getDocumentProperties();
            Iterator<IAuthor> iterator = authors.iterator();
            String allAuthorsLabel = "";
            if (iterator.hasNext()) {
                IAuthor firstAuthor = iterator.next();
                allAuthorsLabel = firstAuthor.buildMultiAuthorLabel(ECollections.toEList(authors));
                props.setAuthor(firstAuthor.buildAuthorLabel());
            }
            XPropertyContainer userDefined = props.getUserDefinedProperties();
            try {
                userDefined.removeProperty("Authors");
            }
            catch (UnknownPropertyException unknownPropertyException) {
            }
            catch (NotRemoveableException e) {
                Activator.log.error((Throwable)e);
            }
            try {
                userDefined.addProperty("Authors", (short)128, (Object)allAuthorsLabel);
            }
            catch (IllegalTypeException | PropertyExistException | IllegalArgumentException e) {
                Activator.log.error(e);
            }
        }
    }

    private static enum PageBreak {
        BEFORE,
        AFTER,
        BOTH;

    }
}

