/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.emf.documentstructuretemplate;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EClassFilterBehavior implements Enumerator
{
    TYPE_OF(0, "TYPE_OF", "TYPE_OF"),
    KIND_OF(1, "KIND_OF", "KIND_OF");

    public static final int TYPE_OF_VALUE = 0;
    public static final int KIND_OF_VALUE = 1;
    private static final EClassFilterBehavior[] VALUES_ARRAY;
    public static final List<EClassFilterBehavior> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EClassFilterBehavior[]{TYPE_OF, KIND_OF};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EClassFilterBehavior get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EClassFilterBehavior result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EClassFilterBehavior getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EClassFilterBehavior result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EClassFilterBehavior get(int value) {
        switch (value) {
            case 0: {
                return TYPE_OF;
            }
            case 1: {
                return KIND_OF;
            }
        }
        return null;
    }

    private EClassFilterBehavior(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

