/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.opcua.uml2opcua.qvt;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.m2m.qvt.oml.BasicModelExtent;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ExecutionContextImpl;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.m2m.qvt.oml.TransformationExecutor;
import org.eclipse.m2m.qvt.oml.util.Log;
import org.eclipse.m2m.qvt.oml.util.StringBufferLog;

public class Uml2OpcuaTransformer {
    ResourceSet resSet = new ResourceSetImpl();
    protected ModelExtent roboticsModel;
    protected ModelExtent roboticsLibraryModel;
    protected ModelExtent diModel;
    protected ModelExtent diLibraryModel;
    protected ModelExtent uaModel;
    protected ModelExtent uaLibraryModel;
    protected ModelExtent sysMLModelExtent;
    protected ModelExtent sysMLBlocksModelExtent;
    protected ModelExtent roboticsProfileExtent;

    public boolean transform(URI resourceURI, URI qvtoTransformationFileUri, ModelExtent[] transformationResults, OutputStream informationOutputStream) {
        PrintWriter informationOutputStreamWriter;
        if (informationOutputStream != null) {
            System.out.println("output stream provided");
            informationOutputStreamWriter = new PrintWriter(informationOutputStream);
        } else {
            System.out.println("No output stream provided, using System.out");
            informationOutputStreamWriter = new PrintWriter(System.out);
        }
        if (resourceURI == null || !new File(resourceURI.path()).exists()) {
            informationOutputStreamWriter.println("No umlFilePath or File does not exist provided: " + resourceURI);
            return false;
        }
        if (qvtoTransformationFileUri == null) {
            EPackage p;
            Resource typesMetamodel;
            EObject eObject2;
            Resource roboticsProfileResource = this.resSet.getResource(URI.createURI((String)"pathmap://Papyrus_OPC_UA_ROBOTICS_PROFILE/OPC_UA_Robotics_CS.profile.uml", (boolean)true), true);
            this.roboticsProfileExtent = new BasicModelExtent((List)roboticsProfileResource.getContents());
            Resource setMetamodel = this.resSet.getResource(URI.createURI((String)"platform:/plugin/org.eclipse.papyrus.uml2opcua.qvto.transformation/metamodels/set.ecore"), true);
            EObject eObject = (EObject)setMetamodel.getContents().get(0);
            if (eObject instanceof EPackage) {
                EPackage p2 = (EPackage)eObject;
                EPackage.Registry.INSTANCE.put((Object)p2.getNsURI(), (Object)p2);
            }
            if ((eObject2 = (EObject)(typesMetamodel = this.resSet.getResource(URI.createURI((String)"platform:/plugin/org.eclipse.papyrus.uml2opcua.qvto.transformation/metamodels/types.ecore"), true)).getContents().get(0)) instanceof EPackage) {
                p = (EPackage)eObject2;
                EPackage.Registry.INSTANCE.put((Object)p.getNsURI(), (Object)p);
            }
            if ((eObject = (EObject)(setMetamodel = this.resSet.getResource(URI.createURI((String)"platform:/plugin/org.eclipse.papyrus.uml2opcua.qvto.transformation/metamodels/di/Opc.Ua.di.ecore"), true)).getContents().get(0)) instanceof EPackage) {
                p = (EPackage)eObject;
                EPackage.Registry.INSTANCE.put((Object)p.getNsURI(), (Object)p);
            }
            if ((eObject = (EObject)(setMetamodel = this.resSet.getResource(URI.createURI((String)"platform:/plugin/org.eclipse.papyrus.uml2opcua.qvto.transformation/metamodels/di/types.ecore"), true)).getContents().get(0)) instanceof EPackage) {
                p = (EPackage)eObject;
                EPackage.Registry.INSTANCE.put((Object)p.getNsURI(), (Object)p);
            }
            if ((eObject = (EObject)(setMetamodel = this.resSet.getResource(URI.createURI((String)"platform:/plugin/org.eclipse.papyrus.uml2opcua.qvto.transformation/metamodels/robotics/Opc.Ua.Robotics.ecore"), true)).getContents().get(0)) instanceof EPackage) {
                p = (EPackage)eObject;
                EPackage.Registry.INSTANCE.put((Object)p.getNsURI(), (Object)p);
            }
            if ((eObject = (EObject)(setMetamodel = this.resSet.getResource(URI.createURI((String)"platform:/plugin/org.eclipse.papyrus.uml2opcua.qvto.transformation/metamodels/robotics/types1.ecore"), true)).getContents().get(0)) instanceof EPackage) {
                p = (EPackage)eObject;
                EPackage.Registry.INSTANCE.put((Object)p.getNsURI(), (Object)p);
            }
            qvtoTransformationFileUri = URI.createURI((String)"platform:/plugin/org.eclipse.papyrus.uml2opcua.qvto.transformation/transforms/Uml2Opcua.qvto");
        }
        TransformationExecutor transformationExecutor = new TransformationExecutor(qvtoTransformationFileUri);
        ExecutionContextImpl executionContext = new ExecutionContextImpl();
        executionContext.setConfigProperty("keepModeling", (Object)true);
        Resource umlXmiResource = this.resSet.getResource(resourceURI, true);
        try {
            umlXmiResource.load(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Resource modelResource = this.resSet.getResource(resourceURI, true);
        BasicModelExtent xmlInput = new BasicModelExtent((List)modelResource.getContents());
        if (transformationResults[0] == null) {
            transformationResults[0] = new BasicModelExtent();
        }
        if (transformationResults[1] == null) {
            transformationResults[1] = new BasicModelExtent();
        }
        StringBufferLog qvtoLog = new StringBufferLog();
        executionContext.setLog((Log)qvtoLog);
        ExecutionDiagnostic transformationDiagnostic = transformationExecutor.execute((ExecutionContext)executionContext, new ModelExtent[]{xmlInput, this.roboticsProfileExtent, transformationResults[0], transformationResults[1]});
        informationOutputStreamWriter.println(qvtoLog.getContents());
        informationOutputStreamWriter.flush();
        if (transformationDiagnostic.getSeverity() != 0) {
            informationOutputStreamWriter.println("Executing QVT transformation failed with error " + transformationDiagnostic.toString());
            informationOutputStreamWriter.flush();
            return false;
        }
        return true;
    }

    private ModelExtent getInOPCUARoboticsModelExtent() {
        URI roboticsProfileURI = URI.createURI((String)"pathmap://Papyrus_OPC_UA_ROBOTICS_PROFILE/OPC_UA_Robotics_CS.profile.uml", (boolean)true);
        Resource roboticsProfile = this.resSet.getResource(roboticsProfileURI, true);
        this.roboticsModel = new BasicModelExtent((List)roboticsProfile.getContents());
        return this.roboticsModel;
    }

    private ModelExtent getInOPCUARoboticsLibararyModelExtent() {
        URI roboticsLibararyURI = URI.createURI((String)"pathmap://Papyrus_OPC_UA_ROBOTICS_LIBRARY/OPC_UA_Robotics_CS_Library.library.uml", (boolean)true);
        Resource roboticsLibrary = this.resSet.getResource(roboticsLibararyURI, true);
        this.roboticsLibraryModel = new BasicModelExtent((List)roboticsLibrary.getContents());
        return this.roboticsLibraryModel;
    }

    private ModelExtent getInOPCUADIModelExtent() {
        URI diProfileURI = URI.createURI((String)"pathmap://Papyrus_OPC_UA_DI_PROFILE/OPC_UA_DI.profile.uml", (boolean)true);
        Resource diProfile = this.resSet.getResource(diProfileURI, true);
        this.diModel = new BasicModelExtent((List)diProfile.getContents());
        return this.diModel;
    }

    private ModelExtent getInOPCUADILibraryModelExtent() {
        URI diLibraryURI = URI.createURI((String)"pathmap://Papyrus_OPC_UA_DI_LIBRARY/OPC_UA_DI.library.uml", (boolean)true);
        Resource diLibraryR = this.resSet.getResource(diLibraryURI, true);
        this.diLibraryModel = new BasicModelExtent((List)diLibraryR.getContents());
        return this.diLibraryModel;
    }

    private ModelExtent getInOPCUAModelExtent() {
        URI uaProfileURI = URI.createURI((String)"pathmap://Papyrus_OPC_UA_PROFILE/OPC_UA.profile.uml", (boolean)true);
        Resource uaProfile = this.resSet.getResource(uaProfileURI, true);
        this.uaModel = new BasicModelExtent((List)uaProfile.getContents());
        return this.uaModel;
    }

    private ModelExtent getInOPCUALibraryModelExtent() {
        URI uaLibraryURI = URI.createURI((String)"pathmap://Papyrus_OPC_UA_LIBRARY/OPC_UA.library.uml", (boolean)true);
        Resource uaLibraryR = this.resSet.getResource(uaLibraryURI, true);
        this.uaLibraryModel = new BasicModelExtent((List)uaLibraryR.getContents());
        return this.uaLibraryModel;
    }

    private ModelExtent getInSysMLModelExtent() {
        URI sysMLProfileURI = URI.createURI((String)"pathmap://SysML16_PROFILES/SysML.profile.uml", (boolean)true);
        Resource sysMLProfile = this.resSet.getResource(sysMLProfileURI, true);
        this.sysMLModelExtent = new BasicModelExtent((List)sysMLProfile.getContents());
        return this.sysMLModelExtent;
    }

    private ModelExtent getInSysMLBlocksModelExtent() {
        URI sysMLBlocksProfileURI = URI.createURI((String)"http://www.eclipse.org/papyrus/sysml/1.6/SysML/Blocks", (boolean)true);
        Resource sysMLBlocksProfile = this.resSet.getResource(sysMLBlocksProfileURI, true);
        this.sysMLBlocksModelExtent = new BasicModelExtent((List)sysMLBlocksProfile.getContents());
        return this.sysMLBlocksModelExtent;
    }

    public boolean serializeNodeset(ModelExtent opcUaModel, String opcuaNodesetFilePath, OutputStream informationOutputStream) {
        PrintWriter informationOutputStreamWriter = informationOutputStream != null ? new PrintWriter(informationOutputStream) : new PrintWriter(System.out);
        Resource resource = this.resSet.createResource(URI.createURI((String)opcuaNodesetFilePath));
        EList contents = resource.getContents();
        contents.addAll((Collection)opcUaModel.getContents());
        File outputFile = new File(opcuaNodesetFilePath);
        try {
            this.serializeNodeset(resource, outputFile);
        }
        catch (IOException e) {
            informationOutputStreamWriter.println("Serializing nodeset failed with execption: " + e.getMessage());
            return false;
        }
        return true;
    }

    public boolean serializeNodeIdsCsv(ModelExtent nodeIdsCsvModel, String nodeIdsCsvFilePath, OutputStream informationOutputStream) {
        PrintWriter informationOutputStreamWriter = informationOutputStream != null ? new PrintWriter(informationOutputStream) : new PrintWriter(System.out);
        ResourceSetImpl resSet = new ResourceSetImpl();
        Resource resource = resSet.createResource(URI.createURI((String)nodeIdsCsvFilePath));
        EList contents = resource.getContents();
        contents.addAll((Collection)nodeIdsCsvModel.getContents());
        HashMap options = new HashMap();
        URI nodesetURI = URI.createFileURI((String)nodeIdsCsvFilePath);
        resource.setURI(nodesetURI);
        try {
            resource.save(options);
        }
        catch (IOException e) {
            informationOutputStreamWriter.println("Serializing NodeIdsCsv failed with execption: " + e.getMessage());
        }
        return true;
    }

    public void serializeNodeset(Resource resource, File outputFile) throws IOException {
        BasicExtendedMetaData extendedMetaData = new BasicExtendedMetaData(resource.getResourceSet().getPackageRegistry());
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("EXTENDED_META_DATA", extendedMetaData);
        options.put("ENCODING", "utf-8");
        options.put("SCHEMA_LOCATION", Boolean.FALSE);
        if (extendedMetaData.demandPackage("http://opcfoundation.org/UA/2011/03/UANodeSet.xsd") != null) {
            extendedMetaData.demandPackage("http://opcfoundation.org/UA/2011/03/UANodeSet.xsd").setNsPrefix("");
        }
        URI nodesetURI = URI.createFileURI((String)outputFile.getAbsolutePath());
        resource.setURI(nodesetURI);
        resource.save(options);
        System.out.println("Nodeset written to " + outputFile.getAbsolutePath());
    }
}

