/**
 * Copyright (c) 2018 CEA
 * 
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Jrmie Tatibouet (CEA) jeremie.tatibouet@cea.fr - Initial API and implementation
 *   Benoit Maggi (CEA) benoit.maggi@cea.fr - Initial API and implementation
 * 
 */
package  org.eclipse.papyrus.iotml.software.artefact.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.papyrus.iotml.hybrid.PhysicalEntity;

import org.eclipse.papyrus.iotml.software.artefact.ArtefactPackage;
import org.eclipse.papyrus.iotml.software.artefact.VirtualEntity;

import org.eclipse.uml2.uml.InstanceSpecification;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Virtual Entity</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.papyrus.iotml.software.artefact.impl.VirtualEntityImpl#getPhisicalEntitySpecification <em>Phisical Entity Specification</em>}</li>
 *   <li>{@link org.eclipse.papyrus.iotml.software.artefact.impl.VirtualEntityImpl#getPhysicalEntity <em>Physical Entity</em>}</li>
 * </ul>
 *
 * @generated
 */
public class VirtualEntityImpl extends DigitalArtefactImpl implements VirtualEntity {
	/**
	 * The cached value of the '{@link #getPhisicalEntitySpecification() <em>Phisical Entity Specification</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPhisicalEntitySpecification()
	 * @generated
	 * @ordered
	 */
	protected InstanceSpecification phisicalEntitySpecification;

	/**
	 * The cached value of the '{@link #getPhysicalEntity() <em>Physical Entity</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPhysicalEntity()
	 * @generated
	 * @ordered
	 */
	protected PhysicalEntity physicalEntity;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VirtualEntityImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ArtefactPackage.Literals.VIRTUAL_ENTITY;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public InstanceSpecification getPhisicalEntitySpecification() {
		if (phisicalEntitySpecification != null && phisicalEntitySpecification.eIsProxy()) {
			InternalEObject oldPhisicalEntitySpecification = (InternalEObject)phisicalEntitySpecification;
			phisicalEntitySpecification = (InstanceSpecification)eResolveProxy(oldPhisicalEntitySpecification);
			if (phisicalEntitySpecification != oldPhisicalEntitySpecification) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, ArtefactPackage.VIRTUAL_ENTITY__PHISICAL_ENTITY_SPECIFICATION, oldPhisicalEntitySpecification, phisicalEntitySpecification));
			}
		}
		return phisicalEntitySpecification;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public InstanceSpecification basicGetPhisicalEntitySpecification() {
		return phisicalEntitySpecification;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPhisicalEntitySpecification(InstanceSpecification newPhisicalEntitySpecification) {
		InstanceSpecification oldPhisicalEntitySpecification = phisicalEntitySpecification;
		phisicalEntitySpecification = newPhisicalEntitySpecification;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ArtefactPackage.VIRTUAL_ENTITY__PHISICAL_ENTITY_SPECIFICATION, oldPhisicalEntitySpecification, phisicalEntitySpecification));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PhysicalEntity getPhysicalEntity() {
		if (physicalEntity != null && physicalEntity.eIsProxy()) {
			InternalEObject oldPhysicalEntity = (InternalEObject)physicalEntity;
			physicalEntity = (PhysicalEntity)eResolveProxy(oldPhysicalEntity);
			if (physicalEntity != oldPhysicalEntity) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, ArtefactPackage.VIRTUAL_ENTITY__PHYSICAL_ENTITY, oldPhysicalEntity, physicalEntity));
			}
		}
		return physicalEntity;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PhysicalEntity basicGetPhysicalEntity() {
		return physicalEntity;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPhysicalEntity(PhysicalEntity newPhysicalEntity) {
		PhysicalEntity oldPhysicalEntity = physicalEntity;
		physicalEntity = newPhysicalEntity;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ArtefactPackage.VIRTUAL_ENTITY__PHYSICAL_ENTITY, oldPhysicalEntity, physicalEntity));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ArtefactPackage.VIRTUAL_ENTITY__PHISICAL_ENTITY_SPECIFICATION:
				if (resolve) return getPhisicalEntitySpecification();
				return basicGetPhisicalEntitySpecification();
			case ArtefactPackage.VIRTUAL_ENTITY__PHYSICAL_ENTITY:
				if (resolve) return getPhysicalEntity();
				return basicGetPhysicalEntity();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ArtefactPackage.VIRTUAL_ENTITY__PHISICAL_ENTITY_SPECIFICATION:
				setPhisicalEntitySpecification((InstanceSpecification)newValue);
				return;
			case ArtefactPackage.VIRTUAL_ENTITY__PHYSICAL_ENTITY:
				setPhysicalEntity((PhysicalEntity)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ArtefactPackage.VIRTUAL_ENTITY__PHISICAL_ENTITY_SPECIFICATION:
				setPhisicalEntitySpecification((InstanceSpecification)null);
				return;
			case ArtefactPackage.VIRTUAL_ENTITY__PHYSICAL_ENTITY:
				setPhysicalEntity((PhysicalEntity)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ArtefactPackage.VIRTUAL_ENTITY__PHISICAL_ENTITY_SPECIFICATION:
				return phisicalEntitySpecification != null;
			case ArtefactPackage.VIRTUAL_ENTITY__PHYSICAL_ENTITY:
				return physicalEntity != null;
		}
		return super.eIsSet(featureID);
	}

} //VirtualEntityImpl
