/*****************************************************************************
 * Copyright (c) 2018 CEA.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Benoit Maggi (CEA LIST) benoit.maggi@cea.fr - Initial API and implementation
 *****************************************************************************/
package org.eclipse.papyrus.iotml.architecture;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.iotml.IoTMLResource;
import org.eclipse.papyrus.sysml14.util.SysMLResource;
import org.eclipse.papyrus.uml.diagram.common.commands.ModelCreationCommandBase;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.resource.UMLResource;


/**
 */
public class CreateIoTMLModelCommand extends ModelCreationCommandBase {

	/**
	 * @see org.eclipse.papyrus.infra.core.extension.commands.ModelCreationCommandBase#createRootElement()
	 *
	 * @return
	 */

	@Override
	protected EObject createRootElement() {
		return UMLFactory.eINSTANCE.createModel();
	}

	/**
	 * A standard IoTML model should have :
	 *  - the SysML profile applied
	 *  - the UML standard profile applied
	 *  - the UML primitive library imported
	 *  - the SysML library imported
	 *  - the Marte profile applied
	 *  - the IoTML profile applied
	 *
	 * @param owner
	 */

	@Override
	protected void initializeModel(EObject owner) {
		super.initializeModel(owner);
		Package packageOwner = (Package) owner;

		Profile standardUMLProfile = (Profile) PackageUtil.loadPackage(URI.createURI(UMLResource.STANDARD_PROFILE_URI), owner.eResource().getResourceSet());
		if (standardUMLProfile != null) {
			PackageUtil.applyProfile(packageOwner, standardUMLProfile, true);
		}

		Profile sysmlProfile = (Profile) PackageUtil.loadPackage(URI.createURI(SysMLResource.PROFILE_PATH), owner.eResource().getResourceSet());
		if (sysmlProfile != null) {
			PackageUtil.applyProfile(packageOwner, sysmlProfile, true);
		}

		Profile marteProfile = (Profile) PackageUtil.loadPackage(URI.createURI(IoTMLResource.MARTE_PROFILE_PATH), owner.eResource().getResourceSet());
		if (marteProfile != null) {
			PackageUtil.applyProfile(packageOwner, marteProfile, true);
		}
		
		Profile iotml = (Profile) PackageUtil.loadPackage(URI.createURI(IoTMLResource.PROFILE_PATH), owner.eResource().getResourceSet());
		if (iotml != null) {
			PackageUtil.applyProfile(packageOwner, iotml, true);
		}


		Package umlPrimitiveTypes = PackageUtil.loadPackage(URI.createURI(UMLResource.UML_PRIMITIVE_TYPES_LIBRARY_URI), owner.eResource().getResourceSet());
		if (umlPrimitiveTypes != null){
			PackageImport pi = UMLFactory.eINSTANCE.createPackageImport();
			pi.setImportedPackage(umlPrimitiveTypes);
			packageOwner.getPackageImports().add(pi);
		}

	}

}
