/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.requirement.provider;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.papyrus.sysml.diagram.requirement.provider.ElementTypes;
import org.eclipse.papyrus.sysml.diagram.requirement.provider.IGraphicalTypeRegistry;
import org.eclipse.uml2.uml.Abstraction;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Realization;
import org.eclipse.uml2.uml.Reception;
import org.eclipse.uml2.uml.Signal;

public class GraphicalTypeRegistry
implements IGraphicalTypeRegistry {
    protected Set<String> knownNodes = new HashSet<String>();
    protected Set<String> knownEdges = new HashSet<String>();

    public GraphicalTypeRegistry() {
        this.knownEdges.add(ElementTypes.ABSTRACTION.getSemanticHint());
        this.knownEdges.add(ElementTypes.DEPENDENCY.getSemanticHint());
        this.knownEdges.add(ElementTypes.REALIZATION.getSemanticHint());
        this.knownEdges.add(ElementTypes.PACKAGE_IMPORT.getSemanticHint());
        this.knownEdges.add(ElementTypes.COMMENT_ANNOTATED_ELEMENT.getSemanticHint());
        this.knownEdges.add(ElementTypes.CONSTRAINT_CONSTRAINED_ELEMENT.getSemanticHint());
        this.knownNodes.add(ElementTypes.PACKAGE.getSemanticHint());
        this.knownNodes.add(ElementTypes.PACKAGE_CN.getSemanticHint());
        this.knownNodes.add(ElementTypes.CLASS.getSemanticHint());
        this.knownNodes.add(ElementTypes.CLASS_CN.getSemanticHint());
        this.knownNodes.add(ElementTypes.DEFAULT_NAMED_ELEMENT.getSemanticHint());
        this.knownNodes.add(ElementTypes.COMMENT.getSemanticHint());
        this.knownNodes.add(ElementTypes.COMMENT_CN.getSemanticHint());
        this.knownNodes.add(ElementTypes.CONSTRAINT.getSemanticHint());
        this.knownNodes.add(ElementTypes.CONSTRAINT_CN.getSemanticHint());
        this.knownNodes.add(ElementTypes.CLASS_PROPERTY_CLN.getSemanticHint());
        this.knownNodes.add(ElementTypes.CLASS_RECEPTION_CLN.getSemanticHint());
        this.knownNodes.add(ElementTypes.CLASS_OPERATION_CLN.getSemanticHint());
        this.knownNodes.add(ElementTypes.CLASS_CLASS_CLN.getSemanticHint());
        this.knownNodes.add(ElementTypes.CLASS_INTERFACE_CLN.getSemanticHint());
        this.knownNodes.add(ElementTypes.CLASS_ENUMERATION_CLN.getSemanticHint());
        this.knownNodes.add(ElementTypes.CLASS_PRIMITIVE_TYPE_CLN.getSemanticHint());
        this.knownNodes.add(ElementTypes.CLASS_DATA_TYPE_CLN.getSemanticHint());
        this.knownNodes.add(ElementTypes.CLASS_SIGNAL_CLN.getSemanticHint());
    }

    @Override
    public String getEdgeGraphicalType(EObject domainElement) {
        String graphicalType = "undefined_type";
        if (domainElement == null) {
            return "undefined_type";
        }
        if (domainElement instanceof Abstraction) {
            graphicalType = ElementTypes.ABSTRACTION.getSemanticHint();
        }
        if (domainElement instanceof Dependency) {
            graphicalType = ElementTypes.DEPENDENCY.getSemanticHint();
        }
        if (domainElement instanceof Realization) {
            graphicalType = ElementTypes.REALIZATION.getSemanticHint();
        }
        if (domainElement instanceof PackageImport) {
            graphicalType = ElementTypes.PACKAGE_IMPORT.getSemanticHint();
        }
        return graphicalType;
    }

    @Override
    public String getEdgeGraphicalType(IElementType elementType) {
        if (elementType instanceof IHintedType) {
            String semanticHint = ((IHintedType)elementType).getSemanticHint();
            return this.getEdgeGraphicalType(semanticHint);
        }
        return "undefined_type";
    }

    @Override
    public String getEdgeGraphicalType(String proposedType) {
        if (this.isKnownEdgeType(proposedType)) {
            return proposedType;
        }
        return "undefined_type";
    }

    @Override
    public String getNodeGraphicalType(EObject domainElement, String containerType) {
        String graphicalType = "undefined_type";
        if (containerType == null || domainElement == null) {
            return "undefined_type";
        }
        if (domainElement instanceof Package) {
            if ("RequirementDiagram".equals(containerType)) {
                graphicalType = ElementTypes.PACKAGE.getSemanticHint();
            }
            if ("Package_PackagedElementCompartment_CN".equals(containerType)) {
                graphicalType = ElementTypes.PACKAGE_CN.getSemanticHint();
            }
            if ("Package_PackagedElementCompartment".equals(containerType)) {
                graphicalType = ElementTypes.PACKAGE_CN.getSemanticHint();
            }
        }
        if (domainElement instanceof Class) {
            if ("RequirementDiagram".equals(containerType)) {
                graphicalType = ElementTypes.CLASS.getSemanticHint();
            }
            if ("Package_PackagedElementCompartment_CN".equals(containerType)) {
                graphicalType = ElementTypes.CLASS_CN.getSemanticHint();
            }
            if ("Package_PackagedElementCompartment".equals(containerType)) {
                graphicalType = ElementTypes.CLASS_CN.getSemanticHint();
            }
            if ("Class_NestedClassifierCompartment_CN".equals(containerType)) {
                graphicalType = ElementTypes.CLASS_CLASS_CLN.getSemanticHint();
            }
            if ("Class_NestedClassifierCompartment".equals(containerType)) {
                graphicalType = ElementTypes.CLASS_CLASS_CLN.getSemanticHint();
            }
        }
        if (domainElement instanceof NamedElement && "RequirementDiagram".equals(containerType)) {
            graphicalType = ElementTypes.DEFAULT_NAMED_ELEMENT.getSemanticHint();
        }
        if (domainElement instanceof Comment) {
            if ("RequirementDiagram".equals(containerType)) {
                graphicalType = ElementTypes.COMMENT.getSemanticHint();
            }
            if ("Package_PackagedElementCompartment_CN".equals(containerType)) {
                graphicalType = ElementTypes.COMMENT_CN.getSemanticHint();
            }
            if ("Package_PackagedElementCompartment".equals(containerType)) {
                graphicalType = ElementTypes.COMMENT_CN.getSemanticHint();
            }
        }
        if (domainElement instanceof Constraint) {
            if ("RequirementDiagram".equals(containerType)) {
                graphicalType = ElementTypes.CONSTRAINT.getSemanticHint();
            }
            if ("Package_PackagedElementCompartment_CN".equals(containerType)) {
                graphicalType = ElementTypes.CONSTRAINT_CN.getSemanticHint();
            }
            if ("Package_PackagedElementCompartment".equals(containerType)) {
                graphicalType = ElementTypes.CONSTRAINT_CN.getSemanticHint();
            }
        }
        if (domainElement instanceof Property) {
            if ("Class_AttributeCompartment".equals(containerType)) {
                graphicalType = ElementTypes.CLASS_PROPERTY_CLN.getSemanticHint();
            }
            if ("Class_AttributeCompartment_CN".equals(containerType)) {
                graphicalType = ElementTypes.CLASS_PROPERTY_CLN.getSemanticHint();
            }
        }
        if (domainElement instanceof Reception) {
            if ("Class_OperationCompartment".equals(containerType)) {
                graphicalType = ElementTypes.CLASS_RECEPTION_CLN.getSemanticHint();
            }
            if ("Class_OperationCompartment_CN".equals(containerType)) {
                graphicalType = ElementTypes.CLASS_RECEPTION_CLN.getSemanticHint();
            }
        }
        if (domainElement instanceof Operation) {
            if ("Class_OperationCompartment".equals(containerType)) {
                graphicalType = ElementTypes.CLASS_OPERATION_CLN.getSemanticHint();
            }
            if ("Class_OperationCompartment_CN".equals(containerType)) {
                graphicalType = ElementTypes.CLASS_OPERATION_CLN.getSemanticHint();
            }
        }
        if (domainElement instanceof Interface) {
            if ("Class_NestedClassifierCompartment".equals(containerType)) {
                graphicalType = ElementTypes.CLASS_INTERFACE_CLN.getSemanticHint();
            }
            if ("Class_NestedClassifierCompartment_CN".equals(containerType)) {
                graphicalType = ElementTypes.CLASS_INTERFACE_CLN.getSemanticHint();
            }
        }
        if (domainElement instanceof Enumeration) {
            if ("Class_NestedClassifierCompartment_CN".equals(containerType)) {
                graphicalType = ElementTypes.CLASS_ENUMERATION_CLN.getSemanticHint();
            }
            if ("Class_NestedClassifierCompartment".equals(containerType)) {
                graphicalType = ElementTypes.CLASS_ENUMERATION_CLN.getSemanticHint();
            }
        }
        if (domainElement instanceof PrimitiveType) {
            if ("Class_NestedClassifierCompartment_CN".equals(containerType)) {
                graphicalType = ElementTypes.CLASS_PRIMITIVE_TYPE_CLN.getSemanticHint();
            }
            if ("Class_NestedClassifierCompartment".equals(containerType)) {
                graphicalType = ElementTypes.CLASS_PRIMITIVE_TYPE_CLN.getSemanticHint();
            }
        }
        if (domainElement instanceof DataType) {
            if ("Class_NestedClassifierCompartment_CN".equals(containerType)) {
                graphicalType = ElementTypes.CLASS_DATA_TYPE_CLN.getSemanticHint();
            }
            if ("Class_NestedClassifierCompartment".equals(containerType)) {
                graphicalType = ElementTypes.CLASS_DATA_TYPE_CLN.getSemanticHint();
            }
        }
        if (domainElement instanceof Signal) {
            if ("Class_NestedClassifierCompartment_CN".equals(containerType)) {
                graphicalType = ElementTypes.CLASS_SIGNAL_CLN.getSemanticHint();
            }
            if ("Class_NestedClassifierCompartment".equals(containerType)) {
                graphicalType = ElementTypes.CLASS_SIGNAL_CLN.getSemanticHint();
            }
        }
        return graphicalType;
    }

    @Override
    public String getNodeGraphicalType(IElementType elementType, String containerType) {
        if (elementType instanceof IHintedType) {
            String semanticHint = ((IHintedType)elementType).getSemanticHint();
            return this.getNodeGraphicalType(semanticHint, containerType);
        }
        return "undefined_type";
    }

    @Override
    public String getNodeGraphicalType(String proposedType, String containerType) {
        if (this.isKnownNodeType(proposedType)) {
            return proposedType;
        }
        return "undefined_type";
    }

    @Override
    public boolean isKnownEdgeType(String type) {
        return this.knownEdges.contains(type);
    }

    @Override
    public boolean isKnownNodeType(String type) {
        return this.knownNodes.contains(type);
    }
}

