/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.parametric.commands;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.service.types.command.ConstraintConstrainedElementsCreateCommand;
import org.eclipse.papyrus.uml.service.types.utils.NamedElementHelper;
import org.eclipse.uml2.common.util.CacheAdapter;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Property;

public class CustomParametricContextLinkCreateCommand
extends ConstraintConstrainedElementsCreateCommand {
    public CustomParametricContextLinkCreateCommand(CreateRelationshipRequest request) {
        super(request);
    }

    public boolean canExecute() {
        List sourceConnections;
        if (this.source == null && this.target == null) {
            return false;
        }
        if (this.source != null && !(this.source instanceof Constraint)) {
            return false;
        }
        if (this.target != null && !(this.target instanceof Namespace)) {
            if (this.target instanceof Property) {
                if (!(((Property)this.target).getType() instanceof Namespace)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (this.getSource() == null) {
            return true;
        }
        View viewSource = this.findView(this.source);
        return viewSource == null || !(this.source instanceof Constraint) || (sourceConnections = ViewUtil.getSourceConnections((View)viewSource)).isEmpty();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in create link command");
        }
        Namespace context = this.getTarget();
        if (this.getSource() != null && context != null) {
            this.getSource().setContext(context);
            String defaultNameWithIncrementFromBase = NamedElementHelper.getDefaultNameWithIncrementFromBase((String)Constraint.class.getSimpleName(), (Collection)context.getOwnedRules(), (EObject)this.getSource());
            this.getSource().setName(defaultNameWithIncrementFromBase);
            return CommandResult.newOKCommandResult();
        }
        return CommandResult.newErrorCommandResult((String)"Try to define Constraint context to a non Namespace element");
    }

    private View findView(EObject element) {
        if (element == null) {
            return null;
        }
        Collection settings = CacheAdapter.getInstance().getNonNavigableInverseReferences(element);
        for (EStructuralFeature.Setting ref : settings) {
            View view;
            if (!NotationPackage.eINSTANCE.getView_Element().equals(ref.getEStructuralFeature()) || (view = (View)ref.getEObject()) == null) continue;
            return view;
        }
        return null;
    }

    protected Namespace getTarget() {
        Object targetNamespace = this.target instanceof Property ? ((Property)this.target).getType() : this.target;
        if (targetNamespace instanceof Namespace) {
            return (Namespace)targetNamespace;
        }
        return null;
    }
}

