/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.edit.part;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultGraphicalNodeEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.edit.part.AppliedStereotypeLinkLabelEditPart;
import org.eclipse.papyrus.uml.diagram.common.editparts.UMLConnectionNodeEditPart;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AppliedStereotypeLinkLabelDisplayEditPolicy;

public abstract class AbstractElementLinkEditPart
extends UMLConnectionNodeEditPart {
    public AbstractElementLinkEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new DefaultGraphicalNodeEditPolicy());
        this.installEditPolicy("AppliedStereotypeLabelDisplayEditPolicy", (EditPolicy)new AppliedStereotypeLinkLabelDisplayEditPolicy());
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof AppliedStereotypeLinkLabelEditPart) {
            ((AppliedStereotypeLinkLabelEditPart)childEditPart).setLabel(this.getPrimaryShape().getAppliedStereotypeLabel());
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        return childEditPart instanceof AppliedStereotypeLinkLabelEditPart;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected void handleNotificationEvent(Notification event) {
        super.handleNotificationEvent(event);
        Object feature = event.getFeature();
        if (this.getModel() != null && this.getModel() == event.getNotifier()) {
            if (NotationPackage.eINSTANCE.getLineStyle_LineWidth().equals(feature)) {
                this.refreshLineWidth();
                this.refreshArrowSource();
                this.refreshArrowTarget();
            } else if (NotationPackage.eINSTANCE.getLineTypeStyle_LineType().equals(feature)) {
                this.refreshLineType();
            }
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshLineType();
        this.refreshLineWidth();
        this.refreshArrowSource();
        this.refreshArrowTarget();
    }

    protected void setLineWidth(int width) {
        if (width < 0) {
            width = 1;
        }
        this.getPrimaryShape().setLineWidth(width);
    }

    protected void setLineType(int style) {
        this.getPrimaryShape().setLineStyle(style);
    }

    protected void setArrowSource(RotatableDecoration arrowDecoration) {
        this.getPrimaryShape().setSourceDecoration(arrowDecoration);
    }

    protected void setArrowTarget(RotatableDecoration arrowDecoration) {
        this.getPrimaryShape().setTargetDecoration(arrowDecoration);
    }

    protected RotatableDecoration getArrowDecoration(int arrowType) {
        PolylineDecoration decoration = null;
        int width = this.getLineWidth();
        if (width < 0) {
            width = 1;
        }
        if (arrowType == 1) {
            IMapMode mm = this.getMapMode();
            decoration = new PolylineDecoration();
            decoration.setScale((double)mm.DPtoLP(15 + width), (double)mm.DPtoLP(5 + width));
            decoration.setTemplate(PolylineDecoration.TRIANGLE_TIP);
            decoration.setLineWidth(mm.DPtoLP(width));
        } else if (arrowType == 2) {
            IMapMode mm = this.getMapMode();
            decoration = new PolygonDecoration();
            ((PolygonDecoration)decoration).setScale((double)mm.DPtoLP(15 + width), (double)mm.DPtoLP(5 + width));
            ((PolygonDecoration)decoration).setTemplate(PolygonDecoration.TRIANGLE_TIP);
            ((PolygonDecoration)decoration).setLineWidth(mm.DPtoLP(width));
            ((PolygonDecoration)decoration).setFill(true);
        } else if (arrowType == 3) {
            IMapMode mm = this.getMapMode();
            decoration = new PolygonDecoration();
            ((PolygonDecoration)decoration).setScale((double)mm.DPtoLP(15 + width), (double)mm.DPtoLP(5 + width));
            ((PolygonDecoration)decoration).setTemplate(PolygonDecoration.TRIANGLE_TIP);
            ((PolygonDecoration)decoration).setLineWidth(mm.DPtoLP(width));
            ((PolygonDecoration)decoration).setFill(true);
            ((PolygonDecoration)decoration).setBackgroundColor(ColorConstants.white);
        } else if (arrowType == 4) {
            IMapMode mm = this.getMapMode();
            decoration = new PolygonDecoration();
            ((PolygonDecoration)decoration).setScale((double)mm.DPtoLP(12 + width), (double)mm.DPtoLP(6 + width));
            PointList diamondPointList = new PointList();
            diamondPointList.addPoint(0, 0);
            diamondPointList.addPoint(-1, 1);
            diamondPointList.addPoint(-2, 0);
            diamondPointList.addPoint(-1, -1);
            ((PolygonDecoration)decoration).setTemplate(diamondPointList);
            ((PolygonDecoration)decoration).setLineWidth(mm.DPtoLP(width));
            ((PolygonDecoration)decoration).setFill(true);
        } else if (arrowType == 5) {
            IMapMode mm = this.getMapMode();
            decoration = new PolygonDecoration();
            ((PolygonDecoration)decoration).setScale((double)mm.DPtoLP(12 + width), (double)mm.DPtoLP(6 + width));
            PointList diamondPointList = new PointList();
            diamondPointList.addPoint(0, 0);
            diamondPointList.addPoint(-1, 1);
            diamondPointList.addPoint(-2, 0);
            diamondPointList.addPoint(-1, -1);
            ((PolygonDecoration)decoration).setTemplate(diamondPointList);
            ((PolygonDecoration)decoration).setLineWidth(mm.DPtoLP(width));
            ((PolygonDecoration)decoration).setFill(true);
            ((PolygonDecoration)decoration).setBackgroundColor(ColorConstants.white);
        }
        return decoration;
    }
}

