/*****************************************************************************
 * Copyright (c) 2015 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 *****************************************************************************/
package org.eclipse.papyrus.interoperability.rpy.transformations;

import java.util.Set;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.papyrus.interoperability.rpy.importer.utils.RpyFileUtils;
import org.eclipse.papyrus.uml.m2m.qvto.common.MigrationParameters.ThreadConfig;
import org.eclipse.papyrus.uml.m2m.qvto.common.transformation.AbstractDependencyAnalysisHelper;
import org.eclipse.uml2.uml.Element;

import com.google.common.collect.Sets;

/**
 * 
 * @author Vincent Lorenzo
 *
 */
public class RpyDependencyAnalysisHelper extends AbstractDependencyAnalysisHelper {

	protected final static Set<String> rpyExtensions = Sets.newHashSet(RpyFileUtils.UML_RPY_FILE, RpyFileUtils.FILE_EXTENSION_RPY);

	protected final static String rpyProfileExtension = RpyFileUtils.UML_RPY_FILE;

	public RpyDependencyAnalysisHelper(final ThreadConfig config) {
		super(config, rpyExtensions, rpyProfileExtension);
	}

	// TODO : not really sure of this part...
	@Override
	protected boolean isInvalidStereotypeApplication(EObject eObject) {
		if (eObject instanceof Element) {
			return false;
		}

		// The package is not resolved: probably a missing profile
		if (eObject instanceof AnyType) {
			return true;
		}

		// If the package is resolved but is contained in an EPX resource, it
		// needs to be mapped to the Papyrus equivalent
		EPackage ePackage = eObject.eClass().getEPackage();
		if (RpyFileUtils.UML_RPY_FILE.equals(ePackage.eResource().getURI().fileExtension())) {
			return true;
		}

		return false;
	}

}
