/**
 *   Copyright (c) 2016 CEA LIST and others.
 *   
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *     CEA LIST - Initial API and implementation
 * 
 */
package org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyGeometryFactory
 * @model kind="package"
 *        annotation="http://www.eclipse.org/uml2/2.0.0/UML originalName='RpyGeometry'"
 * @generated
 */
public interface RpyGeometryPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "rpygeometry"; //$NON-NLS-1$

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.eclipse.org/papyrus/rpygeometry/1.0.0"; //$NON-NLS-1$

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "rpygeom"; //$NON-NLS-1$

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	RpyGeometryPackage eINSTANCE = org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.RpyGeometryPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.TransformMatrixImpl <em>Transform Matrix</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.TransformMatrixImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.RpyGeometryPackageImpl#getTransformMatrix()
	 * @generated
	 */
	int TRANSFORM_MATRIX = 0;

	/**
	 * The feature id for the '<em><b>A</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSFORM_MATRIX__A = 0;

	/**
	 * The feature id for the '<em><b>B</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSFORM_MATRIX__B = 1;

	/**
	 * The feature id for the '<em><b>C</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSFORM_MATRIX__C = 2;

	/**
	 * The feature id for the '<em><b>D</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSFORM_MATRIX__D = 3;

	/**
	 * The feature id for the '<em><b>E</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSFORM_MATRIX__E = 4;

	/**
	 * The feature id for the '<em><b>F</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSFORM_MATRIX__F = 5;

	/**
	 * The number of structural features of the '<em>Transform Matrix</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSFORM_MATRIX_FEATURE_COUNT = 6;

	/**
	 * The operation id for the '<em>Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSFORM_MATRIX___ADD__TRANSFORMMATRIX = 0;

	/**
	 * The operation id for the '<em>Minus</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSFORM_MATRIX___MINUS = 1;

	/**
	 * The operation id for the '<em>Minus</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSFORM_MATRIX___MINUS__TRANSFORMMATRIX = 2;

	/**
	 * The operation id for the '<em>Multiply</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSFORM_MATRIX___MULTIPLY__POINT = 3;

	/**
	 * The operation id for the '<em>Multiply</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSFORM_MATRIX___MULTIPLY__TRANSFORMMATRIX = 4;

	/**
	 * The number of operations of the '<em>Transform Matrix</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSFORM_MATRIX_OPERATION_COUNT = 5;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.PointImpl <em>Point</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.PointImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.RpyGeometryPackageImpl#getPoint()
	 * @generated
	 */
	int POINT = 1;

	/**
	 * The feature id for the '<em><b>X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT__X = 0;

	/**
	 * The feature id for the '<em><b>Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT__Y = 1;

	/**
	 * The number of structural features of the '<em>Point</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT_FEATURE_COUNT = 2;

	/**
	 * The operation id for the '<em>Minus</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT___MINUS = 0;

	/**
	 * The operation id for the '<em>Minus</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT___MINUS__POINT = 1;

	/**
	 * The operation id for the '<em>Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT___ADD__POINT = 2;

	/**
	 * The operation id for the '<em>Get Int X</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT___GET_INT_X = 3;

	/**
	 * The operation id for the '<em>Get Int Y</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT___GET_INT_Y = 4;

	/**
	 * The number of operations of the '<em>Point</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT_OPERATION_COUNT = 5;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.RpyShapeImpl <em>Rpy Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.RpyShapeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.RpyGeometryPackageImpl#getRpyShape()
	 * @generated
	 */
	int RPY_SHAPE = 2;

	/**
	 * The feature id for the '<em><b>Transform</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RPY_SHAPE__TRANSFORM = 0;

	/**
	 * The feature id for the '<em><b>Rectangle</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RPY_SHAPE__RECTANGLE = 1;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RPY_SHAPE__PARENT = 2;

	/**
	 * The feature id for the '<em><b>Rpy Metamodel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RPY_SHAPE__RPY_METAMODEL_OBJECT = 3;

	/**
	 * The feature id for the '<em><b>Parent Relative Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RPY_SHAPE__PARENT_RELATIVE_POSITION = 4;

	/**
	 * The feature id for the '<em><b>Height</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RPY_SHAPE__HEIGHT = 5;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RPY_SHAPE__WIDTH = 6;

	/**
	 * The feature id for the '<em><b>Absolute Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RPY_SHAPE__ABSOLUTE_POSITION = 7;

	/**
	 * The number of structural features of the '<em>Rpy Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RPY_SHAPE_FEATURE_COUNT = 8;

	/**
	 * The number of operations of the '<em>Rpy Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RPY_SHAPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.PolygonImpl <em>Polygon</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.PolygonImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.RpyGeometryPackageImpl#getPolygon()
	 * @generated
	 */
	int POLYGON = 4;

	/**
	 * The feature id for the '<em><b>Points</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYGON__POINTS = 0;

	/**
	 * The number of structural features of the '<em>Polygon</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYGON_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Polygon</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYGON_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.RectangleImpl <em>Rectangle</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.RectangleImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.RpyGeometryPackageImpl#getRectangle()
	 * @generated
	 */
	int RECTANGLE = 3;

	/**
	 * The feature id for the '<em><b>Points</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECTANGLE__POINTS = POLYGON__POINTS;

	/**
	 * The feature id for the '<em><b>Top Left</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECTANGLE__TOP_LEFT = POLYGON_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Top Right</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECTANGLE__TOP_RIGHT = POLYGON_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Bottom Left</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECTANGLE__BOTTOM_LEFT = POLYGON_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Bottom Right</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECTANGLE__BOTTOM_RIGHT = POLYGON_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Rectangle</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECTANGLE_FEATURE_COUNT = POLYGON_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>Rectangle</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECTANGLE_OPERATION_COUNT = POLYGON_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.RpyPortImpl <em>Rpy Port</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.RpyPortImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.RpyGeometryPackageImpl#getRpyPort()
	 * @generated
	 */
	int RPY_PORT = 5;

	/**
	 * The feature id for the '<em><b>Transform</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RPY_PORT__TRANSFORM = RPY_SHAPE__TRANSFORM;

	/**
	 * The feature id for the '<em><b>Rectangle</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RPY_PORT__RECTANGLE = RPY_SHAPE__RECTANGLE;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RPY_PORT__PARENT = RPY_SHAPE__PARENT;

	/**
	 * The feature id for the '<em><b>Rpy Metamodel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RPY_PORT__RPY_METAMODEL_OBJECT = RPY_SHAPE__RPY_METAMODEL_OBJECT;

	/**
	 * The feature id for the '<em><b>Parent Relative Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RPY_PORT__PARENT_RELATIVE_POSITION = RPY_SHAPE__PARENT_RELATIVE_POSITION;

	/**
	 * The feature id for the '<em><b>Height</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RPY_PORT__HEIGHT = RPY_SHAPE__HEIGHT;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RPY_PORT__WIDTH = RPY_SHAPE__WIDTH;

	/**
	 * The feature id for the '<em><b>Absolute Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RPY_PORT__ABSOLUTE_POSITION = RPY_SHAPE__ABSOLUTE_POSITION;

	/**
	 * The feature id for the '<em><b>Position</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RPY_PORT__POSITION = RPY_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Rpy Port</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RPY_PORT_FEATURE_COUNT = RPY_SHAPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Rpy Port</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RPY_PORT_OPERATION_COUNT = RPY_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Position <em>Position</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Position
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.RpyGeometryPackageImpl#getPosition()
	 * @generated
	 */
	int POSITION = 6;


	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix <em>Transform Matrix</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Transform Matrix</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix
	 * @generated
	 */
	EClass getTransformMatrix();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix#getA <em>A</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>A</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix#getA()
	 * @see #getTransformMatrix()
	 * @generated
	 */
	EAttribute getTransformMatrix_A();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix#getB <em>B</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>B</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix#getB()
	 * @see #getTransformMatrix()
	 * @generated
	 */
	EAttribute getTransformMatrix_B();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix#getC <em>C</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>C</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix#getC()
	 * @see #getTransformMatrix()
	 * @generated
	 */
	EAttribute getTransformMatrix_C();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix#getD <em>D</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>D</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix#getD()
	 * @see #getTransformMatrix()
	 * @generated
	 */
	EAttribute getTransformMatrix_D();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix#getE <em>E</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>E</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix#getE()
	 * @see #getTransformMatrix()
	 * @generated
	 */
	EAttribute getTransformMatrix_E();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix#getF <em>F</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>F</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix#getF()
	 * @see #getTransformMatrix()
	 * @generated
	 */
	EAttribute getTransformMatrix_F();

	/**
	 * Returns the meta object for the '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix#add(org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix) <em>Add</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Add</em>' operation.
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix#add(org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix)
	 * @generated
	 */
	EOperation getTransformMatrix__Add__TransformMatrix();

	/**
	 * Returns the meta object for the '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix#minus() <em>Minus</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Minus</em>' operation.
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix#minus()
	 * @generated
	 */
	EOperation getTransformMatrix__Minus();

	/**
	 * Returns the meta object for the '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix#minus(org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix) <em>Minus</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Minus</em>' operation.
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix#minus(org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix)
	 * @generated
	 */
	EOperation getTransformMatrix__Minus__TransformMatrix();

	/**
	 * Returns the meta object for the '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix#multiply(org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point) <em>Multiply</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Multiply</em>' operation.
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix#multiply(org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point)
	 * @generated
	 */
	EOperation getTransformMatrix__Multiply__Point();

	/**
	 * Returns the meta object for the '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix#multiply(org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix) <em>Multiply</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Multiply</em>' operation.
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix#multiply(org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix)
	 * @generated
	 */
	EOperation getTransformMatrix__Multiply__TransformMatrix();

	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point <em>Point</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Point</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point
	 * @generated
	 */
	EClass getPoint();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point#getX <em>X</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>X</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point#getX()
	 * @see #getPoint()
	 * @generated
	 */
	EAttribute getPoint_X();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point#getY <em>Y</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Y</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point#getY()
	 * @see #getPoint()
	 * @generated
	 */
	EAttribute getPoint_Y();

	/**
	 * Returns the meta object for the '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point#minus() <em>Minus</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Minus</em>' operation.
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point#minus()
	 * @generated
	 */
	EOperation getPoint__Minus();

	/**
	 * Returns the meta object for the '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point#minus(org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point) <em>Minus</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Minus</em>' operation.
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point#minus(org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point)
	 * @generated
	 */
	EOperation getPoint__Minus__Point();

	/**
	 * Returns the meta object for the '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point#add(org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point) <em>Add</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Add</em>' operation.
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point#add(org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point)
	 * @generated
	 */
	EOperation getPoint__Add__Point();

	/**
	 * Returns the meta object for the '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point#getIntX() <em>Get Int X</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Int X</em>' operation.
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point#getIntX()
	 * @generated
	 */
	EOperation getPoint__GetIntX();

	/**
	 * Returns the meta object for the '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point#getIntY() <em>Get Int Y</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Int Y</em>' operation.
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point#getIntY()
	 * @generated
	 */
	EOperation getPoint__GetIntY();

	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyShape <em>Rpy Shape</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Rpy Shape</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyShape
	 * @generated
	 */
	EClass getRpyShape();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyShape#getTransform <em>Transform</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Transform</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyShape#getTransform()
	 * @see #getRpyShape()
	 * @generated
	 */
	EReference getRpyShape_Transform();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyShape#getRectangle <em>Rectangle</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Rectangle</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyShape#getRectangle()
	 * @see #getRpyShape()
	 * @generated
	 */
	EReference getRpyShape_Rectangle();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyShape#getParent <em>Parent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Parent</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyShape#getParent()
	 * @see #getRpyShape()
	 * @generated
	 */
	EReference getRpyShape_Parent();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyShape#getRpyMetamodelObject <em>Rpy Metamodel Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Rpy Metamodel Object</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyShape#getRpyMetamodelObject()
	 * @see #getRpyShape()
	 * @generated
	 */
	EReference getRpyShape_RpyMetamodelObject();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyShape#getParentRelativePosition <em>Parent Relative Position</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Parent Relative Position</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyShape#getParentRelativePosition()
	 * @see #getRpyShape()
	 * @generated
	 */
	EReference getRpyShape_ParentRelativePosition();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyShape#getHeight <em>Height</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Height</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyShape#getHeight()
	 * @see #getRpyShape()
	 * @generated
	 */
	EAttribute getRpyShape_Height();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyShape#getWidth <em>Width</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Width</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyShape#getWidth()
	 * @see #getRpyShape()
	 * @generated
	 */
	EAttribute getRpyShape_Width();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyShape#getAbsolutePosition <em>Absolute Position</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Absolute Position</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyShape#getAbsolutePosition()
	 * @see #getRpyShape()
	 * @generated
	 */
	EReference getRpyShape_AbsolutePosition();

	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Rectangle <em>Rectangle</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Rectangle</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Rectangle
	 * @generated
	 */
	EClass getRectangle();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Rectangle#getTopLeft <em>Top Left</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Top Left</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Rectangle#getTopLeft()
	 * @see #getRectangle()
	 * @generated
	 */
	EReference getRectangle_TopLeft();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Rectangle#getTopRight <em>Top Right</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Top Right</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Rectangle#getTopRight()
	 * @see #getRectangle()
	 * @generated
	 */
	EReference getRectangle_TopRight();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Rectangle#getBottomLeft <em>Bottom Left</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Bottom Left</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Rectangle#getBottomLeft()
	 * @see #getRectangle()
	 * @generated
	 */
	EReference getRectangle_BottomLeft();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Rectangle#getBottomRight <em>Bottom Right</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Bottom Right</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Rectangle#getBottomRight()
	 * @see #getRectangle()
	 * @generated
	 */
	EReference getRectangle_BottomRight();

	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Polygon <em>Polygon</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Polygon</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Polygon
	 * @generated
	 */
	EClass getPolygon();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Polygon#getPoints <em>Points</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Points</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Polygon#getPoints()
	 * @see #getPolygon()
	 * @generated
	 */
	EReference getPolygon_Points();

	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyPort <em>Rpy Port</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Rpy Port</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyPort
	 * @generated
	 */
	EClass getRpyPort();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyPort#getPosition <em>Position</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Position</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyPort#getPosition()
	 * @see #getRpyPort()
	 * @generated
	 */
	EAttribute getRpyPort_Position();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Position <em>Position</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Position</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Position
	 * @generated
	 */
	EEnum getPosition();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	RpyGeometryFactory getRpyGeometryFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.TransformMatrixImpl <em>Transform Matrix</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.TransformMatrixImpl
		 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.RpyGeometryPackageImpl#getTransformMatrix()
		 * @generated
		 */
		EClass TRANSFORM_MATRIX = eINSTANCE.getTransformMatrix();

		/**
		 * The meta object literal for the '<em><b>A</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRANSFORM_MATRIX__A = eINSTANCE.getTransformMatrix_A();

		/**
		 * The meta object literal for the '<em><b>B</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRANSFORM_MATRIX__B = eINSTANCE.getTransformMatrix_B();

		/**
		 * The meta object literal for the '<em><b>C</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRANSFORM_MATRIX__C = eINSTANCE.getTransformMatrix_C();

		/**
		 * The meta object literal for the '<em><b>D</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRANSFORM_MATRIX__D = eINSTANCE.getTransformMatrix_D();

		/**
		 * The meta object literal for the '<em><b>E</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRANSFORM_MATRIX__E = eINSTANCE.getTransformMatrix_E();

		/**
		 * The meta object literal for the '<em><b>F</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRANSFORM_MATRIX__F = eINSTANCE.getTransformMatrix_F();

		/**
		 * The meta object literal for the '<em><b>Add</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation TRANSFORM_MATRIX___ADD__TRANSFORMMATRIX = eINSTANCE.getTransformMatrix__Add__TransformMatrix();

		/**
		 * The meta object literal for the '<em><b>Minus</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation TRANSFORM_MATRIX___MINUS = eINSTANCE.getTransformMatrix__Minus();

		/**
		 * The meta object literal for the '<em><b>Minus</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation TRANSFORM_MATRIX___MINUS__TRANSFORMMATRIX = eINSTANCE.getTransformMatrix__Minus__TransformMatrix();

		/**
		 * The meta object literal for the '<em><b>Multiply</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation TRANSFORM_MATRIX___MULTIPLY__POINT = eINSTANCE.getTransformMatrix__Multiply__Point();

		/**
		 * The meta object literal for the '<em><b>Multiply</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation TRANSFORM_MATRIX___MULTIPLY__TRANSFORMMATRIX = eINSTANCE.getTransformMatrix__Multiply__TransformMatrix();

		/**
		 * The meta object literal for the '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.PointImpl <em>Point</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.PointImpl
		 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.RpyGeometryPackageImpl#getPoint()
		 * @generated
		 */
		EClass POINT = eINSTANCE.getPoint();

		/**
		 * The meta object literal for the '<em><b>X</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute POINT__X = eINSTANCE.getPoint_X();

		/**
		 * The meta object literal for the '<em><b>Y</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute POINT__Y = eINSTANCE.getPoint_Y();

		/**
		 * The meta object literal for the '<em><b>Minus</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation POINT___MINUS = eINSTANCE.getPoint__Minus();

		/**
		 * The meta object literal for the '<em><b>Minus</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation POINT___MINUS__POINT = eINSTANCE.getPoint__Minus__Point();

		/**
		 * The meta object literal for the '<em><b>Add</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation POINT___ADD__POINT = eINSTANCE.getPoint__Add__Point();

		/**
		 * The meta object literal for the '<em><b>Get Int X</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation POINT___GET_INT_X = eINSTANCE.getPoint__GetIntX();

		/**
		 * The meta object literal for the '<em><b>Get Int Y</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation POINT___GET_INT_Y = eINSTANCE.getPoint__GetIntY();

		/**
		 * The meta object literal for the '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.RpyShapeImpl <em>Rpy Shape</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.RpyShapeImpl
		 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.RpyGeometryPackageImpl#getRpyShape()
		 * @generated
		 */
		EClass RPY_SHAPE = eINSTANCE.getRpyShape();

		/**
		 * The meta object literal for the '<em><b>Transform</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RPY_SHAPE__TRANSFORM = eINSTANCE.getRpyShape_Transform();

		/**
		 * The meta object literal for the '<em><b>Rectangle</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RPY_SHAPE__RECTANGLE = eINSTANCE.getRpyShape_Rectangle();

		/**
		 * The meta object literal for the '<em><b>Parent</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RPY_SHAPE__PARENT = eINSTANCE.getRpyShape_Parent();

		/**
		 * The meta object literal for the '<em><b>Rpy Metamodel Object</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RPY_SHAPE__RPY_METAMODEL_OBJECT = eINSTANCE.getRpyShape_RpyMetamodelObject();

		/**
		 * The meta object literal for the '<em><b>Parent Relative Position</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RPY_SHAPE__PARENT_RELATIVE_POSITION = eINSTANCE.getRpyShape_ParentRelativePosition();

		/**
		 * The meta object literal for the '<em><b>Height</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RPY_SHAPE__HEIGHT = eINSTANCE.getRpyShape_Height();

		/**
		 * The meta object literal for the '<em><b>Width</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RPY_SHAPE__WIDTH = eINSTANCE.getRpyShape_Width();

		/**
		 * The meta object literal for the '<em><b>Absolute Position</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RPY_SHAPE__ABSOLUTE_POSITION = eINSTANCE.getRpyShape_AbsolutePosition();

		/**
		 * The meta object literal for the '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.RectangleImpl <em>Rectangle</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.RectangleImpl
		 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.RpyGeometryPackageImpl#getRectangle()
		 * @generated
		 */
		EClass RECTANGLE = eINSTANCE.getRectangle();

		/**
		 * The meta object literal for the '<em><b>Top Left</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RECTANGLE__TOP_LEFT = eINSTANCE.getRectangle_TopLeft();

		/**
		 * The meta object literal for the '<em><b>Top Right</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RECTANGLE__TOP_RIGHT = eINSTANCE.getRectangle_TopRight();

		/**
		 * The meta object literal for the '<em><b>Bottom Left</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RECTANGLE__BOTTOM_LEFT = eINSTANCE.getRectangle_BottomLeft();

		/**
		 * The meta object literal for the '<em><b>Bottom Right</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RECTANGLE__BOTTOM_RIGHT = eINSTANCE.getRectangle_BottomRight();

		/**
		 * The meta object literal for the '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.PolygonImpl <em>Polygon</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.PolygonImpl
		 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.RpyGeometryPackageImpl#getPolygon()
		 * @generated
		 */
		EClass POLYGON = eINSTANCE.getPolygon();

		/**
		 * The meta object literal for the '<em><b>Points</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference POLYGON__POINTS = eINSTANCE.getPolygon_Points();

		/**
		 * The meta object literal for the '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.RpyPortImpl <em>Rpy Port</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.RpyPortImpl
		 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.RpyGeometryPackageImpl#getRpyPort()
		 * @generated
		 */
		EClass RPY_PORT = eINSTANCE.getRpyPort();

		/**
		 * The meta object literal for the '<em><b>Position</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RPY_PORT__POSITION = eINSTANCE.getRpyPort_Position();

		/**
		 * The meta object literal for the '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Position <em>Position</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Position
		 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.RpyGeometryPackageImpl#getPosition()
		 * @generated
		 */
		EEnum POSITION = eINSTANCE.getPosition();

	}

} //RpyGeometryPackage
