/*****************************************************************************
 * Copyright (c) 2016 CEA LIST and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   CEA LIST - Initial API and implementation
 *   
 *****************************************************************************/

package org.eclipse.papyrus.interoperability.rpy.geometry.custom;

import org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point;
import org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Rectangle;
import org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyPort;
import org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyShape;
import org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix;
import org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.RpyGeometryFactoryImpl;

public class CustomRpyGeometryFactory extends RpyGeometryFactoryImpl {
	@Override
	public RpyPort createRpyPort() {
		return new CustomRpyPort();
	}

	@Override
	public RpyShape createRpyShape() {
		return new CustomRpyShape();
	}

	@Override
	public TransformMatrix createTransformMatrix() {
		return new CustomTransformMatrix();
	}

	@Override
	public Rectangle createRectangle() {
		return new CustomRectangle();
	}

	@Override
	public Point createPoint() {
		return new CustomPoint();
	}

}
