/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.ui.queries;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.emf.facet.efacet.core.IFacetManager;
import org.eclipse.papyrus.emf.facet.efacet.core.exception.DerivedTypedElementException;
import org.eclipse.papyrus.emf.facet.query.java.core.IJavaQuery2;
import org.eclipse.papyrus.emf.facet.query.java.core.IParameterValueList2;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.ui.util.ServiceUtilsForHandlers;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.AbstractLayer;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerExpression;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersStack;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.TopLayerOperator;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.runtime.model.LayersModelResource;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.ui.Activator;

public class GetAssociatedLayers
implements IJavaQuery2<Diagram, Collection<AbstractLayer>> {
    public Collection<AbstractLayer> evaluate(Diagram source, IParameterValueList2 parameterValues, IFacetManager facetManager) throws DerivedTypedElementException {
        ArrayList<AbstractLayer> result = new ArrayList<AbstractLayer>();
        try {
            LayersModelResource model;
            ModelSet modelSet = ServiceUtilsForHandlers.getInstance().getModelSet(null);
            ServicesRegistry registry = ServiceUtilsForEObject.getInstance().getServiceRegistry((EObject)source);
            IMultiDiagramEditor editor = (IMultiDiagramEditor)registry.getService(IMultiDiagramEditor.class);
            if (editor != null) {
                modelSet = (ModelSet)registry.getService(ModelSet.class);
            }
            if ((model = (LayersModelResource)modelSet.getModelChecked("org.eclipse.papyrus.layers.resource.LayersModel")) == null) {
                return result;
            }
            LayersStack layerStack = model.getLayerStackApplication().getLayersStackFor(source);
            if (!(layerStack.getLayers() instanceof TopLayerOperator)) {
                return result;
            }
            TopLayerOperator topLayerOperator = (TopLayerOperator)layerStack.getLayers();
            for (LayerExpression layerExpression : topLayerOperator.getLayers()) {
                if (!(layerExpression instanceof AbstractLayer)) continue;
                result.add((AbstractLayer)layerExpression);
            }
            return result;
        }
        catch (ServiceException e) {
            Activator.log.error("Unable to find the current ModelSet", (Throwable)e);
        }
        catch (NotFoundException e) {
            Activator.log.error("Unable to retrieve the LayerResource associated to the modelSet", (Throwable)e);
        }
        return result;
    }
}

