/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.impl.custom;

import java.util.List;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.NotFoundException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerOperator;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersFactory;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.Property;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.PropertyOperator;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.StackedLayerOperator;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.impl.StackedLayerOperatorDescriptorImpl;

public class CustomStackedLayerOperatorDescriptorImpl
extends StackedLayerOperatorDescriptorImpl {
    static int count = 0;

    protected CustomStackedLayerOperatorDescriptorImpl() {
        this.init();
    }

    private void init() {
        this.setName("StackedLayerOperator");
    }

    @Override
    public LayerOperator createLayerOperator() {
        StackedLayerOperator layerOperator = LayersFactory.eINSTANCE.createStackedLayerOperator();
        layerOperator.setLayerOperatorDescriptor(this);
        layerOperator.setLayerOperatorDescriptorName(this.getName());
        layerOperator.setName(String.valueOf(this.getName()) + count++);
        return layerOperator;
    }

    @Override
    public List<PropertyOperator> getPropertyOperators() {
        if (this.propertyOperators == null) {
            this.propertyOperators = new EObjectResolvingEList<PropertyOperator>(PropertyOperator.class, (InternalEObject)this, 0){

                protected boolean isUnique() {
                    return false;
                }
            };
        }
        return this.propertyOperators;
    }

    @Override
    public PropertyOperator getPropertyOperator(Property property) throws NotFoundException {
        try {
            return this.getPropertyOperators().get(property.getIndex());
        }
        catch (IndexOutOfBoundsException e) {
            throw new NotFoundException("Can't find operator for property '" + property.getName() + "' at index " + property.getIndex());
        }
    }

    @Override
    public void setPropertyOperator(Property property, PropertyOperator operator) {
        this.getPropertyOperators().set(property.getIndex(), operator);
    }

    @Override
    public void setPropertyCollectionSize(int size, PropertyOperator defaultPropertyOperator) {
        List<PropertyOperator> operators = this.getPropertyOperators();
        int actualSize = operators.size();
        if (actualSize >= size) {
            return;
        }
        int i = actualSize;
        while (i < size) {
            operators.add(defaultPropertyOperator);
            ++i;
        }
    }
}

