/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagramtemplate;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SelectionKind implements Enumerator
{
    FOR_ALL(0, "ForAll", "ForAll"),
    SPECIFIC(1, "Specific", "Specific"),
    QUERY(2, "Query", "Query");

    public static final int FOR_ALL_VALUE = 0;
    public static final int SPECIFIC_VALUE = 1;
    public static final int QUERY_VALUE = 2;
    private static final SelectionKind[] VALUES_ARRAY;
    public static final List<SelectionKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SelectionKind[]{FOR_ALL, SPECIFIC, QUERY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SelectionKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SelectionKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SelectionKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SelectionKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SelectionKind get(int value) {
        switch (value) {
            case 0: {
                return FOR_ALL;
            }
            case 1: {
                return SPECIFIC;
            }
            case 2: {
                return QUERY;
            }
        }
        return null;
    }

    private SelectionKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

