/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.profile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.AttributeOwner;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.OperationOwner;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ProfileUtil
extends UMLUtil {
    public static void sortProfiles(List<Profile> profiles) {
        final Map<Profile, Set<Profile>> dependencies = ProfileUtil.computeProfileDependencies(profiles);
        ProfileUtil.expand(dependencies);
        Collections.sort(profiles, new Comparator<Profile>(){

            @Override
            public int compare(Profile o1, Profile o2) {
                int compareResult = 0;
                if (((Set)dependencies.get(o1)).contains(o2)) {
                    compareResult = 1;
                } else if (((Set)dependencies.get(o2)).contains(o1)) {
                    compareResult = -1;
                }
                return compareResult;
            }
        });
    }

    private static Map<Profile, Set<Profile>> computeProfileDependencies(Collection<? extends Profile> profiles) {
        LinkedHashMap<Profile, Set<Profile>> result = new LinkedHashMap<Profile, Set<Profile>>();
        for (Profile profile : profiles) {
            result.put(profile, new HashSet());
            for (PackageableElement member : profile.getPackagedElements()) {
                if (member instanceof Classifier) {
                    for (Classifier general : ((Classifier)member).allParents()) {
                        ProfileUtil.addProfileContaining((PackageableElement)general, profile, result);
                    }
                }
                if (member instanceof AttributeOwner) {
                    for (Property property : ((AttributeOwner)member).getOwnedAttributes()) {
                        ProfileUtil.addProfileContaining((PackageableElement)property.getType(), profile, result);
                    }
                }
                if (!(member instanceof OperationOwner)) continue;
                for (Operation operation : ((OperationOwner)member).getOwnedOperations()) {
                    for (Parameter parameter : operation.getOwnedParameters()) {
                        ProfileUtil.addProfileContaining((PackageableElement)parameter.getType(), profile, result);
                    }
                }
            }
            if (!result.containsKey(profile)) continue;
            ((Set)result.get(profile)).remove(profile);
        }
        return result;
    }

    private static void addProfileContaining(PackageableElement element, Profile dependent, Map<Profile, Set<Profile>> dependencies) {
        if (element != null) {
            Package containingPackage = element.getNearestPackage();
            while (containingPackage != null && !(containingPackage instanceof Profile) && containingPackage.getOwner() != null) {
                containingPackage = containingPackage.getOwner().getNearestPackage();
            }
            if (containingPackage instanceof Profile) {
                Set containingProfiles = Optional.of(dependencies.get(dependent)).orElse(new LinkedHashSet());
                containingProfiles.add((Profile)containingPackage);
                dependencies.put(dependent, containingProfiles);
            }
        }
    }

    public static boolean isDirty(Package pack, Profile profile) {
        URI profURI;
        Resource modelResource;
        boolean isDirty = false;
        if (profile == null || profile.eResource() == null || pack == null || pack.eResource() == null) {
            return false;
        }
        ResourceSet pkgeResourceSet = pack.eResource().getResourceSet();
        if (pkgeResourceSet != null && (modelResource = pkgeResourceSet.getResource(profURI = profile.eResource().getURI(), true)) != null && modelResource.getContents().get(0) instanceof Profile) {
            Profile profileInFile = (Profile)modelResource.getContents().get(0);
            ProfileApplication profileApplication = pack.getProfileApplication(profile, true);
            if (profileApplication != null) {
                String fileProfileName;
                EPackage appliedProfileDefinition = profileApplication.getAppliedDefinition();
                EPackage fileProfileDefinition = null;
                String appliedProfileName = profile.getQualifiedName();
                if (!appliedProfileName.equals(fileProfileName = profileInFile.getQualifiedName())) {
                    for (Profile current : ProfileUtil.getSubProfiles((Package)profileInFile)) {
                        fileProfileName = current.getQualifiedName();
                        if (!fileProfileName.equals(appliedProfileName)) continue;
                        profileInFile = current;
                    }
                }
                fileProfileDefinition = profileInFile.getDefinition();
                URIConverter converter = pkgeResourceSet.getURIConverter();
                if (appliedProfileDefinition == null || fileProfileDefinition == null || !UML2Util.safeEquals((Object)converter.normalize(EcoreUtil.getURI((EObject)appliedProfileDefinition)), (Object)converter.normalize(EcoreUtil.getURI((EObject)fileProfileDefinition)))) {
                    isDirty = true;
                }
            }
        }
        return isDirty;
    }

    private static List<Profile> getSubProfiles(Package pack) {
        ArrayList<Profile> subProfiles = new ArrayList<Profile>();
        for (Object element : pack.getNestedPackages()) {
            if (element instanceof Profile) {
                Profile currentSubProfile = (Profile)element;
                subProfiles.add(currentSubProfile);
                subProfiles.addAll(ProfileUtil.getSubProfiles((Package)currentSubProfile));
                continue;
            }
            if (!(element instanceof Package)) continue;
            Package currentSubPackage = (Package)element;
            subProfiles.addAll(ProfileUtil.getSubProfiles(currentSubPackage));
        }
        return subProfiles;
    }

    private static void expand(Map<Profile, Set<Profile>> dependencies) {
        boolean changed = true;
        while (changed) {
            changed = false;
            for (Profile next : new ArrayList<Profile>(dependencies.keySet())) {
                for (Profile dep : new ArrayList(dependencies.get(next))) {
                    Set<Profile> transitive = dependencies.get(dep);
                    if (transitive == null || !dependencies.get(next).addAll(transitive)) continue;
                    changed = true;
                }
            }
        }
    }
}

