/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.edges;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.domain.services.edges.IDomainBasedEdgeSourceProvider;
import org.eclipse.papyrus.uml.domain.services.internal.helpers.OccurrenceSpecificationHelper;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.ComponentRealization;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Deployment;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Extend;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Include;
import org.eclipse.uml2.uml.InformationFlow;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.PackageMerge;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Substitution;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class ElementDomainBasedEdgeSourceProvider
implements IDomainBasedEdgeSourceProvider {
    @Override
    public EObject getSource(EObject semanticElement) {
        return (EObject)new EdgeProviderSwitch().doSwitch(semanticElement);
    }

    private static class EdgeProviderSwitch
    extends UMLSwitch<EObject> {
        private EdgeProviderSwitch() {
        }

        public EObject caseActivityEdge(ActivityEdge activityEdge) {
            return activityEdge.getSource();
        }

        public EObject caseAssociation(Association object) {
            Type type = null;
            if (object.getMemberEnds().size() > 1) {
                type = ((Property)object.getMemberEnds().get(1)).getType();
            }
            return type;
        }

        public EObject caseComponentRealization(ComponentRealization componentRealization) {
            if (componentRealization.getRealizingClassifiers().isEmpty()) {
                return null;
            }
            return (EObject)componentRealization.getRealizingClassifiers().get(0);
        }

        public EObject caseConnector(Connector connector) {
            return connector.getEnds().stream().filter(end -> end.getRole() != null).map(end -> end.getRole()).findFirst().orElse(null);
        }

        public EObject caseDependency(Dependency dependency) {
            EList clients = dependency.getClients();
            if (clients.isEmpty()) {
                return null;
            }
            return (EObject)clients.get(0);
        }

        public EObject caseDeployment(Deployment deployment) {
            if (deployment.getDeployedArtifacts().isEmpty()) {
                return null;
            }
            return (EObject)deployment.getDeployedArtifacts().get(0);
        }

        public EObject caseElementImport(ElementImport elementImport) {
            return elementImport.getImportingNamespace();
        }

        public EObject caseExtend(Extend extend) {
            return extend.getExtension();
        }

        public EObject caseExtension(Extension extension) {
            return extension.getStereotype();
        }

        public EObject caseGeneralization(Generalization object) {
            return object.getSpecific();
        }

        public EObject caseInclude(Include object) {
            return object.getIncludingCase();
        }

        public EObject caseInformationFlow(InformationFlow informationFlow) {
            return informationFlow.getInformationSources().stream().findFirst().orElse(null);
        }

        public EObject caseInterfaceRealization(InterfaceRealization interfaceRealization) {
            return interfaceRealization.getImplementingClassifier();
        }

        public EObject caseMessage(Message message) {
            MessageEnd sendEvent = message.getSendEvent();
            if (sendEvent instanceof OccurrenceSpecification) {
                return OccurrenceSpecificationHelper.findEnclosingElement((OccurrenceSpecification)sendEvent);
            }
            return null;
        }

        public EObject casePackageImport(PackageImport object) {
            return object.getImportingNamespace();
        }

        public EObject casePackageMerge(PackageMerge object) {
            return object.getReceivingPackage();
        }

        public EObject caseSubstitution(Substitution object) {
            return object.getSubstitutingClassifier();
        }

        public EObject caseTransition(Transition transition) {
            return transition.getSource();
        }
    }
}

