/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.view.panels;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Const;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.ConstInit;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Friend;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Inline;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Virtual;
import org.eclipse.papyrus.designer.languages.cpp.view.panels.CppAbstractPanel;
import org.eclipse.papyrus.designer.transformation.base.utils.CommandSupport;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.profile.standard.Create;
import org.eclipse.uml2.uml.profile.standard.Destroy;
import org.eclipse.uml2.uml.util.UMLUtil;

@Deprecated
public class CppOperationPanel
extends CppAbstractPanel {
    private ISourceViewer viewerBody;
    private ISourceViewer viewerConstInit;
    private Group groupBody;
    private Group groupCInit;
    private IDocument docBody;
    private IDocument docConstInit;
    private Button isStatic;
    private Button isInline;
    private Button isConst;
    private Button isFriend;
    private Button isCreate;
    private Button isDestroy;
    private Combo vPropCombo;
    private Operation selectedOperation;
    Element selectedEOwner;
    protected String origBody;

    public CppOperationPanel(Composite parent, int style) {
        super(parent, style);
    }

    public Operation getSelectedElement() {
        return this.selectedOperation;
    }

    @Override
    public void setSelectedElement(Element newElement) {
        super.setSelectedElement(newElement);
        if (!(newElement instanceof Operation)) {
            throw new RuntimeException("bad selection: " + newElement + " should be an uml2 Operation");
        }
        this.selectedOperation = (Operation)newElement;
        this.selectedEOwner = this.selectedOperation.getOwner();
    }

    @Override
    public Control createContent() {
        this.isStatic = this.createButton("isStatic", this, null);
        this.isInline = this.createButton("isInline", this, this.isStatic);
        this.isConst = this.createButton("isConst", this, this.isInline);
        this.isFriend = this.createButton("isFriend", this, this.isConst);
        this.isCreate = this.createButton("isCreate", this, this.isFriend);
        this.isDestroy = this.createButton("isDestroy", this, this.isCreate);
        this.isStatic.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CommandSupport.exec((EObject)CppOperationPanel.this.selectedOperation, (String)"C++ operation save", (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        CppOperationPanel.this.updateModel();
                    }
                });
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.addStereotypeSelectionListener(this.isInline, "Inline");
        this.addStereotypeSelectionListener(this.isConst, "Const");
        this.addStereotypeSelectionListener(this.isFriend, "Friend");
        this.addStereotypeSelectionListener(this.isCreate, "Create");
        this.addStereotypeSelectionListener(this.isDestroy, "Destroy");
        this.vPropCombo = new Combo((Composite)this, 12);
        String[] items = new String[]{"not virtual", "virtual", "pure virtual"};
        this.vPropCombo.setItems(items);
        this.vPropCombo.setText("Virtual operation qualifiers");
        this.vPropCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CommandSupport.exec((EObject)CppOperationPanel.this.selectedOperation, (String)"C++ virtual update", (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        CppOperationPanel.this.checkVirtual();
                        CppOperationPanel.this.reset();
                    }
                });
            }
        });
        FormData data = new FormData();
        data.left = new FormAttachment((Control)this.isDestroy, 10);
        data.top = new FormAttachment(0, 10);
        this.vPropCombo.setLayoutData((Object)data);
        this.createSaveResetButtons();
        this.docConstInit = this.createDocument();
        this.groupCInit = this.createGroup(this, "Constructor initialisation list", (Control)this.isStatic, null, true, 0, 0, false);
        this.viewerConstInit = this.createViewer(this.docConstInit, this.groupCInit);
        this.docBody = this.createDocumentC();
        this.groupBody = this.createGroup(this, "Method body", (Control)this.groupCInit, null, true, 0, 0, true);
        this.viewerBody = this.createViewerC(this.docBody, this.groupBody);
        return this;
    }

    @Override
    public void save() {
        if (this.selectedOperation != null) {
            CommandSupport.exec((EObject)this.selectedOperation, (String)"C++ operation save", (Runnable)new Runnable(){

                @Override
                public void run() {
                    String newConstInit = CppOperationPanel.this.docConstInit.get();
                    if (newConstInit.equals("")) {
                        StereotypeUtil.unapply((Element)CppOperationPanel.this.selectedOperation, ConstInit.class);
                    } else {
                        ConstInit cppConstInit = (ConstInit)StereotypeUtil.applyApp((Element)CppOperationPanel.this.selectedOperation, ConstInit.class);
                        cppConstInit.setInitialisation(newConstInit);
                    }
                    CppOperationPanel.setCppBody(CppOperationPanel.this.selectedOperation, CppOperationPanel.this.docBody.get());
                    CppOperationPanel.this.origBody = CppOperationPanel.this.docBody.get();
                }
            });
        }
    }

    public static String getCppBody(Operation operation) {
        for (Behavior behavior : operation.getMethods()) {
            OpaqueBehavior ob;
            if (!(behavior instanceof OpaqueBehavior) || (ob = (OpaqueBehavior)behavior).getBodies().size() != ob.getLanguages().size()) continue;
            int i = 0;
            for (String language : ob.getLanguages()) {
                if (language.equals("C/C++")) {
                    return (String)ob.getBodies().get(i);
                }
                if (language.equals("C++")) {
                    return (String)ob.getBodies().get(i);
                }
                if (language.equals("C")) {
                    return (String)ob.getBodies().get(i);
                }
                ++i;
            }
        }
        return "";
    }

    public static void setCppBody(Operation operation, String body) {
        boolean done = false;
        for (Behavior behavior : operation.getMethods()) {
            if (behavior instanceof OpaqueBehavior) {
                OpaqueBehavior ob = (OpaqueBehavior)behavior;
                int i = 0;
                for (String language : ob.getLanguages()) {
                    if (language.equals("C/C++") || language.equals("C++") || language.equals("C")) {
                        done = true;
                        ob.getBodies().set(i, (Object)body);
                        break;
                    }
                    ++i;
                }
            }
            if (done) break;
        }
        if (!done) {
            OpaqueBehavior ob = (OpaqueBehavior)operation.getClass_().createOwnedBehavior(operation.getName(), UMLPackage.eINSTANCE.getOpaqueBehavior());
            ob.getLanguages().add((Object)"C/C++");
            ob.getBodies().add((Object)body);
            ob.setSpecification((BehavioralFeature)operation);
        }
    }

    protected void checkStatic() {
        boolean boxState = this.isStatic.getSelection();
        if (boxState != this.selectedOperation.isStatic()) {
            this.selectedOperation.setIsStatic(boxState);
        }
    }

    protected void checkInline() {
        boolean boxState = this.isInline.getSelection();
        if (boxState != StereotypeUtil.isApplied((Element)this.selectedOperation, Inline.class)) {
            if (boxState) {
                StereotypeUtil.apply((Element)this.selectedOperation, Inline.class);
            } else {
                StereotypeUtil.unapply((Element)this.selectedOperation, Inline.class);
            }
        }
    }

    protected void checkConst() {
        boolean boxState = this.isConst.getSelection();
        if (boxState != StereotypeUtil.isApplied((Element)this.selectedOperation, Const.class)) {
            if (boxState) {
                StereotypeUtil.apply((Element)this.selectedOperation, Const.class);
            } else {
                StereotypeUtil.unapply((Element)this.selectedOperation, Const.class);
            }
        }
    }

    protected void checkFriend() {
        boolean boxState = this.isFriend.getSelection();
        if (boxState != StereotypeUtil.isApplied((Element)this.selectedOperation, Friend.class)) {
            if (boxState) {
                StereotypeUtil.apply((Element)this.selectedOperation, Friend.class);
            } else {
                StereotypeUtil.unapply((Element)this.selectedOperation, Friend.class);
            }
        }
    }

    protected void checkCreate() {
        boolean boxState = this.isCreate.getSelection();
        if (boxState) {
            StereotypeUtil.apply((Element)this.selectedOperation, Create.class);
        } else {
            StereotypeUtil.unapply((Element)this.selectedOperation, ConstInit.class);
            StereotypeUtil.unapply((Element)this.selectedOperation, Create.class);
        }
        this.groupCInit.setEnabled(boxState);
    }

    protected void checkDestroy() {
        boolean boxState = this.isDestroy.getSelection();
        if (boxState) {
            StereotypeUtil.apply((Element)this.selectedOperation, Destroy.class);
        } else {
            StereotypeUtil.unapply((Element)this.selectedOperation, Destroy.class);
        }
    }

    protected void checkVirtual() {
        int comboSelected = 2;
        comboSelected = this.selectedEOwner instanceof Class ? this.vPropCombo.getSelectionIndex() : 2;
        if (comboSelected == 0) {
            this.selectedOperation.setIsAbstract(false);
            StereotypeUtil.unapply((Element)this.selectedOperation, Virtual.class);
        } else if (comboSelected == 1) {
            if (this.selectedOperation.isAbstract()) {
                this.selectedOperation.setIsAbstract(false);
            }
            StereotypeUtil.apply((Element)this.selectedOperation, Virtual.class);
        } else if (comboSelected == 2) {
            if (!this.selectedOperation.isAbstract()) {
                this.selectedOperation.setIsAbstract(true);
            }
            StereotypeUtil.apply((Element)this.selectedOperation, Virtual.class);
        }
        if (this.selectedEOwner instanceof Class) {
            Class ownerCl = (Class)this.selectedEOwner;
            ownerCl.setIsAbstract(ownerCl.isAbstract());
        }
    }

    @Override
    public void entryAction() {
        super.entryAction();
        this.reset();
    }

    @Override
    public void exitAction() {
        if (this.selectedEOwner instanceof Class) {
            super.exitAction();
        }
    }

    @Override
    public boolean checkModifications() {
        String valueConstInit = "";
        ConstInit constInit = (ConstInit)UMLUtil.getStereotypeApplication((Element)this.selectedOperation, ConstInit.class);
        if (constInit != null) {
            valueConstInit = constInit.getInitialisation();
        }
        if (!this.docConstInit.get().equals(valueConstInit)) {
            return true;
        }
        return !this.docBody.get().equals(this.origBody);
    }

    @Override
    protected void refreshPanel() {
        if (this.selectedOperation != null) {
            if (this.selectedEOwner instanceof Class) {
                String body;
                ConstInit constInit = (ConstInit)UMLUtil.getStereotypeApplication((Element)this.selectedOperation, ConstInit.class);
                if (constInit != null) {
                    this.docConstInit.set(constInit.getInitialisation());
                }
                if (this.isCreate.getSelection()) {
                    this.groupCInit.setEnabled(true);
                } else {
                    this.docConstInit.set("");
                    this.groupCInit.setEnabled(false);
                }
                this.origBody = body = CppOperationPanel.getCppBody(this.selectedOperation);
                this.docBody.set(body);
                if (this.selectedOperation.isAbstract()) {
                    this.vPropCombo.select(2);
                    this.docBody.set("");
                    this.groupBody.setEnabled(false);
                } else if (StereotypeUtil.isApplied((Element)this.selectedOperation, Virtual.class)) {
                    this.vPropCombo.select(1);
                    this.groupBody.setEnabled(true);
                } else {
                    this.vPropCombo.select(0);
                    this.groupBody.setEnabled(true);
                }
                if (StereotypeUtil.isApplied((Element)this.selectedOperation, Inline.class)) {
                    this.isInline.setSelection(true);
                }
            } else {
                this.groupBody.setVisible(false);
                this.buttonSave.setVisible(false);
                this.buttonCancel.setVisible(false);
                this.vPropCombo.select(2);
                this.vPropCombo.setEnabled(false);
                this.isInline.setVisible(false);
            }
            this.isStatic.setSelection(this.selectedOperation.isStatic());
            this.isConst.setSelection(StereotypeUtil.isApplied((Element)this.selectedOperation, Const.class));
            this.isFriend.setSelection(StereotypeUtil.isApplied((Element)this.selectedOperation, Friend.class));
            this.isCreate.setSelection(StereotypeUtil.isApplied((Element)this.selectedOperation, Create.class));
            this.isDestroy.setSelection(StereotypeUtil.isApplied((Element)this.selectedOperation, Destroy.class));
        }
    }

    @Override
    protected boolean isModelValid() {
        if (this.selectedOperation == null) {
            return true;
        }
        if (this.selectedEOwner instanceof Class) {
            if (this.selectedOperation.isAbstract() && !StereotypeUtil.isApplied((Element)this.selectedOperation, Virtual.class)) {
                return false;
            }
        } else {
            if (!this.selectedOperation.isAbstract()) {
                return false;
            }
            if (StereotypeUtil.isApplied((Element)this.selectedOperation, Virtual.class)) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void updateModel() {
        CommandSupport.exec((EObject)this.selectedOperation, (String)"C++ operation save", (Runnable)new Runnable(){

            @Override
            public void run() {
                CppOperationPanel.this.checkStatic();
                CppOperationPanel.this.checkConst();
                CppOperationPanel.this.checkCreate();
                CppOperationPanel.this.checkDestroy();
                CppOperationPanel.this.checkInline();
                CppOperationPanel.this.checkFriend();
                if (CppOperationPanel.this.selectedOperation == null) {
                    return;
                }
                if (CppOperationPanel.this.selectedEOwner instanceof Class) {
                    if (CppOperationPanel.this.selectedOperation.isAbstract()) {
                        StereotypeUtil.isApplied((Element)CppOperationPanel.this.selectedOperation, Virtual.class);
                    }
                    if (!CppOperationPanel.this.selectedOperation.isAbstract()) {
                        StereotypeUtil.isApplied((Element)CppOperationPanel.this.selectedOperation, Virtual.class);
                    }
                } else {
                    CppOperationPanel.this.selectedOperation.setIsAbstract(true);
                }
            }
        });
    }
}

