/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.reverse.ui.listener;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.papyrus.designer.languages.cpp.reverse.reverse.change.CElementChange;

public class CProjectChangesListener
implements IElementChangedListener {
    private Map<String, List<CElementChange>> changesMap;

    public CProjectChangesListener(Map<String, List<CElementChange>> changesMap) {
        this.changesMap = changesMap;
    }

    public void elementChanged(ElementChangedEvent event) {
        String eventName = "";
        eventName = event.getType() == 1 ? "POST_CHANGE" : (event.getType() == 4 ? "POST_RECONCILE" : String.valueOf(event.getType()));
        System.out.println("Process event of type " + eventName);
        if (event.getType() == 4 || event.getType() == 1) {
            ArrayList<CElementChange> affectedLeafElements = new ArrayList<CElementChange>();
            this.fillAffectedLeafElements(event.getDelta(), affectedLeafElements);
            List<CElementChange> changes = null;
            for (CElementChange cElementChange : affectedLeafElements) {
                if (cElementChange.getChangeKind() != 0) {
                    if (cElementChange.getElement().getCProject() == null) continue;
                    String projectName = cElementChange.getElement().getCProject().getElementName();
                    if (this.changesMap != null) {
                        if (this.changesMap.get(projectName) != null) {
                            changes = this.changesMap.get(projectName);
                        } else {
                            changes = Collections.synchronizedList(new LinkedList());
                            this.changesMap.put(cElementChange.getElement().getCProject().getElementName(), changes);
                        }
                    }
                    if (changes == null) continue;
                    changes.add(cElementChange);
                    String changeName = "";
                    changeName = cElementChange.getChangeKind() == 1 ? "ADDED" : (cElementChange.getChangeKind() == 2 ? "REMOVED" : (cElementChange.getChangeKind() == 4 ? "CHANGED" : String.valueOf(cElementChange.getChangeKind())));
                    System.out.println("---> " + cElementChange.getElement().getElementName() + " of type " + cElementChange.getElement().getElementType() + " has been " + changeName + " ==> PUT IN MAP");
                    continue;
                }
                System.out.println("---> " + cElementChange.getElement().getElementName() + " of type " + cElementChange.getElement().getElementType() + " has been " + cElementChange.getChangeKind() + " ==> NOTHING");
            }
        }
    }

    private void fillAffectedLeafElements(ICElementDelta delta, List<CElementChange> affectedLeafElements) {
        if (affectedLeafElements == null) {
            return;
        }
        if (delta != null) {
            if (delta.getAffectedChildren().length == 0 && delta.getElement() != null) {
                affectedLeafElements.add(new CElementChange(delta));
            } else {
                ICElementDelta[] iCElementDeltaArray = delta.getAffectedChildren();
                int n = iCElementDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICElementDelta childDelta = iCElementDeltaArray[n2];
                    this.fillAffectedLeafElements(childDelta, affectedLeafElements);
                    ++n2;
                }
            }
        }
    }
}

