/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.common.extensionpoints;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.ILangCodegen;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.ILangCodegen2;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.LanguageCodegen;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.AbstractElementListSelectionDialog;

public class GeneratorSelectionDialog
extends AbstractElementListSelectionDialog {
    protected Text m_description;
    ILangCodegen[] generators;

    public GeneratorSelectionDialog(Shell parent, List<ILangCodegen> generatorList) {
        super(parent, (ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return LanguageCodegen.getID((ILangCodegen)element);
            }
        });
        this.generators = generatorList.toArray(new ILangCodegen[0]);
        this.setMultipleSelection(false);
        this.setTitle(Messages.GeneratorSelectionDialog_SelectGenerator);
    }

    public Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        this.createMessageArea(contents);
        this.createFilteredList(contents);
        this.createFilterText(contents);
        this.fFilteredList.setElements((Object[])this.generators);
        Label info = this.createMessageArea(contents);
        info.setText(Messages.GeneratorSelectionDialog_infoCodeGen);
        this.fFilteredList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = GeneratorSelectionDialog.this.fFilteredList.getSelectionIndex();
                GeneratorSelectionDialog.this.updateDescription(GeneratorSelectionDialog.this.getElement(index));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        GridData descriptionGD = new GridData();
        descriptionGD.horizontalAlignment = 4;
        descriptionGD.grabExcessHorizontalSpace = true;
        descriptionGD.heightHint = 80;
        descriptionGD.grabExcessVerticalSpace = true;
        descriptionGD.verticalAlignment = 4;
        this.m_description = new Text(contents, 584);
        this.m_description.setLayoutData((Object)descriptionGD);
        this.updateDescription(this.getElement(0));
        return contents;
    }

    protected void updateDescription(ILangCodegen codegen) {
        if (codegen instanceof ILangCodegen2) {
            this.m_description.setText(((ILangCodegen2)codegen).getDescription());
        } else {
            this.m_description.setText("not available");
        }
    }

    ILangCodegen getElement(int index) {
        return (ILangCodegen)this.fFilteredList.getFoldedElements(index)[0];
    }

    protected void computeResult() {
        int index = this.fFilteredList.getSelectionIndex();
        Object[] result = new Object[]{this.getElement(index)};
        this.setResult(Arrays.asList(result));
    }
}

