/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.codegen.ui.handlers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.designer.languages.common.base.ClassUtils;
import org.eclipse.papyrus.designer.languages.java.codegen.transformation.JavaMerger;
import org.eclipse.papyrus.designer.languages.java.codegen.transformation.JavaModelElementsCreator;
import org.eclipse.papyrus.designer.languages.java.codegen.utils.JavaGenUtils;
import org.eclipse.papyrus.designer.languages.java.codegen.utils.LocateJavaProject;
import org.eclipse.papyrus.uml.diagram.common.handlers.CmdHandler;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;

public class GenerateCodeHandler
extends CmdHandler {
    public boolean isEnabled() {
        this.updateSelectedEObject();
        if (this.selectedEObject instanceof Package || this.selectedEObject instanceof Classifier) {
            URI uri = this.selectedEObject.eResource().getURI();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            if (uri.segmentCount() < 2) {
                return false;
            }
            IProject modelProject = root.getProject(uri.segment(1));
            return modelProject.exists();
        }
        return false;
    }

    public void generate(JavaModelElementsCreator mec, PackageableElement pe, EList<PackageableElement> alreadyHandled, boolean recurse) {
        alreadyHandled.add((Object)pe);
        mec.createPackageableElement(pe, null, false);
        if (pe instanceof Package && recurse) {
            for (PackageableElement subPe : ((Package)pe).getPackagedElements()) {
                if (alreadyHandled.contains((Object)subPe)) continue;
                this.generate(mec, subPe, alreadyHandled, recurse);
            }
        }
        if (pe instanceof Classifier) {
            EList requiredClassifiers = ClassUtils.requiredClassifiers((Classifier)((Classifier)pe));
            for (Classifier requiredClassifier : requiredClassifiers) {
                if (alreadyHandled.contains((Object)requiredClassifier) || !(requiredClassifier.getOwner() instanceof Package)) continue;
                this.generate(mec, (PackageableElement)requiredClassifier, alreadyHandled, false);
            }
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        JavaGenUtils.imports = new HashMap();
        if (this.selectedEObject instanceof PackageableElement) {
            PackageableElement pe = (PackageableElement)this.selectedEObject;
            IProject targetProject = LocateJavaProject.getTargetProject((PackageableElement)pe, (boolean)true);
            if (targetProject == null) {
                return null;
            }
            JavaModelElementsCreator mec = new JavaModelElementsCreator(targetProject, pe);
            this.generate(mec, pe, (EList<PackageableElement>)new BasicEList(), true);
            JavaMerger merger = new JavaMerger(targetProject, mec.getSourceFolder(), mec.getTargetFolder());
            merger.merge();
        }
        if (JavaGenUtils.imports != null) {
            Iterator it = JavaGenUtils.imports.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry pair = it.next();
                if (pair != null && pair.getValue() != null) {
                    ((List)pair.getValue()).clear();
                }
                it.remove();
            }
            JavaGenUtils.imports.clear();
        }
        return null;
    }
}

