/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.reverse.ui.handler;

import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.designer.languages.cpp.reverse.reverse.ReverseCpp2Uml;
import org.eclipse.papyrus.designer.languages.cpp.reverse.ui.Activator;
import org.eclipse.papyrus.designer.languages.cpp.reverse.ui.dialog.ResourceFileSelectionDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;

public class ReverseToExistingUmlModelMerge
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            Object selectedObject;
            IFile resource;
            ITextEditor textEditor;
            IEditorPart editorPart;
            ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            if (selection instanceof ITextSelection && (editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()) instanceof AbstractTextEditor && (textEditor = (ITextEditor)editorPart) != null && (resource = (IFile)textEditor.getEditorInput().getAdapter(IResource.class)) != null) {
                this.scheduleReverse(resource.getProject());
                return Status.OK_STATUS;
            }
            if (selection instanceof IStructuredSelection && (selectedObject = ((IStructuredSelection)selection).getFirstElement()) instanceof IResource) {
                this.scheduleReverse(((IResource)selectedObject).getProject());
                return Status.OK_STATUS;
            }
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
        return null;
    }

    private void scheduleReverse(IProject project) {
        if (project != null) {
            final ICProject cProject = CoreModel.getDefault().create(project);
            Job job = new Job("Reversing project " + cProject.getElementName() + " to existing UML model (merge)"){

                protected IStatus run(final IProgressMonitor monitor) {
                    try {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    String[] types = new String[]{"uml"};
                                    ResourceFileSelectionDialog fileSelector = new ResourceFileSelectionDialog("UML file selector", "Select a UML file", types);
                                    fileSelector.open();
                                    Object file = fileSelector.getFirstResult();
                                    if (file instanceof IFile && ((IFile)file).exists()) {
                                        String path = ((IFile)file).getFullPath().toString();
                                        ReverseCpp2Uml reverser = new ReverseCpp2Uml(cProject, monitor, ReverseCpp2Uml.Cpp_LangID, path);
                                        reverser.syncIncrementalProject();
                                        MessageBox messageBox = new MessageBox(Display.getDefault().getActiveShell(), 34);
                                        messageBox.setMessage("Merged changes to existing UML model " + ((IFile)file).getLocationURI().getPath());
                                        messageBox.open();
                                    }
                                }
                                catch (Exception e) {
                                    Activator.log.error((Throwable)e);
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        Activator.log.error((Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }
}

