/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.library.xtend;

import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.common.base.ElementUtils;
import org.eclipse.papyrus.designer.transformation.core.templates.TemplateUtils;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.TemplateBinding;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.Vertex;

public class StateMachineUtil {
    static final String SIGNAL_ENUM = "SignalIDs";

    public static Region region(State state) {
        EList regions = state.getRegions();
        if (regions.size() > 0) {
            return (Region)regions.get(0);
        }
        return null;
    }

    public static Region region(StateMachine stateMachine) {
        EList regions = stateMachine.getRegions();
        if (regions.size() > 0) {
            return (Region)regions.get(0);
        }
        return null;
    }

    public static EList<State> subStates(State state) {
        Region region = StateMachineUtil.region(state);
        return region != null ? StateMachineUtil.states(region) : new BasicEList();
    }

    public static EList<State> states(StateMachine stateMachine) {
        Region region = StateMachineUtil.region(stateMachine);
        return region != null ? StateMachineUtil.states(region) : new BasicEList();
    }

    public static EList<State> states(Region region) {
        BasicEList states = new BasicEList();
        for (Vertex vertex : region.getSubvertices()) {
            if (!(vertex instanceof State)) continue;
            states.add((Object)((State)vertex));
        }
        return states;
    }

    public static EList<Pseudostate> entryPoints(State state) {
        BasicEList pseudoStates = new BasicEList();
        for (Pseudostate pseudoState : state.getConnectionPoints()) {
            if (pseudoState.getKind() != PseudostateKind.ENTRY_POINT_LITERAL) continue;
            pseudoStates.add((Object)pseudoState);
        }
        return pseudoStates;
    }

    public static EList<Pseudostate> exitPoints(State state) {
        BasicEList pseudoStates = new BasicEList();
        for (Pseudostate pseudoState : state.getConnectionPoints()) {
            if (pseudoState.getKind() != PseudostateKind.EXIT_POINT_LITERAL) continue;
            pseudoStates.add((Object)pseudoState);
        }
        return pseudoStates;
    }

    public static EList<Pseudostate> junctionPoints(Region region) {
        return StateMachineUtil.filteredPseudoStates(region, PseudostateKind.JUNCTION_LITERAL);
    }

    public static EList<Pseudostate> choicePoints(Region region) {
        return StateMachineUtil.filteredPseudoStates(region, PseudostateKind.CHOICE_LITERAL);
    }

    public static EList<Pseudostate> filteredPseudoStates(Region region, PseudostateKind kind) {
        BasicEList pseudoStates = new BasicEList();
        for (Vertex vertex : region.getSubvertices()) {
            Pseudostate pseudoState;
            if (!(vertex instanceof Pseudostate) || (pseudoState = (Pseudostate)vertex).getKind() != kind) continue;
            pseudoStates.add((Object)pseudoState);
        }
        return pseudoStates;
    }

    public static Pseudostate firstPseudoState(Region region, PseudostateKind kind) {
        for (Vertex vertex : region.getSubvertices()) {
            Pseudostate pseudoState;
            if (!(vertex instanceof Pseudostate) || (pseudoState = (Pseudostate)vertex).getKind() != kind) continue;
            return pseudoState;
        }
        return null;
    }

    public static Collection<Transition> indirectIncomings(State state) {
        BasicEList indirectIncoming = new BasicEList();
        for (Pseudostate p : StateMachineUtil.entryPoints(state)) {
            for (Transition t : p.getIncomings()) {
                indirectIncoming.add((Object)t);
            }
        }
        return indirectIncoming;
    }

    public static Collection<Transition> indirectOutgoings(State state) {
        BasicEList indirectIncoming = new BasicEList();
        for (Pseudostate p : StateMachineUtil.entryPoints(state)) {
            for (Transition t : p.getIncomings()) {
                indirectIncoming.add((Object)t);
            }
        }
        return indirectIncoming;
    }

    public static Collection<Transition> allIncomings(State state) {
        BasicEList allIncoming = new BasicEList();
        for (Transition t : state.getIncomings()) {
            allIncoming.add((Object)t);
        }
        allIncoming.addAll(StateMachineUtil.indirectIncomings(state));
        return allIncoming;
    }

    public static Collection<Transition> allOutgoings(State state) {
        BasicEList allIncoming = new BasicEList();
        for (Transition t : state.getIncomings()) {
            allIncoming.add((Object)t);
        }
        allIncoming.addAll(StateMachineUtil.indirectOutgoings(state));
        return allIncoming;
    }

    public static void moveContents(Region targetRegion, State source) {
        Region sourceRegion = StateMachineUtil.region(source);
        BasicEList vertices = new BasicEList((Collection)sourceRegion.getSubvertices());
        for (Vertex v : vertices) {
            targetRegion.getSubvertices().add((Object)v);
        }
        BasicEList transitions = new BasicEList((Collection)sourceRegion.getTransitions());
        for (Transition t : transitions) {
            targetRegion.getTransitions().add((Object)t);
        }
    }

    public static Pseudostate initialState(Region region) {
        return StateMachineUtil.firstPseudoState(region, PseudostateKind.INITIAL_LITERAL);
    }

    public static Pseudostate deepHistory(Region region) {
        return StateMachineUtil.firstPseudoState(region, PseudostateKind.DEEP_HISTORY_LITERAL);
    }

    public static State createState(Region region, String name) {
        return (State)region.createSubvertex(name, UMLPackage.eINSTANCE.getState());
    }

    public static Pseudostate createPseudostate(Region region, String name) {
        return (Pseudostate)region.createSubvertex(name, UMLPackage.eINSTANCE.getPseudostate());
    }

    public static Package boundPackageRef(Type actual) {
        for (Package nestedPkg : PackageUtil.getRootPackage((Element)actual).getNestedPackages()) {
            TemplateBinding binding;
            if (nestedPkg.getTemplateBindings().size() <= 0 || actual != TemplateUtils.getFirstActualFromBinding((TemplateBinding)(binding = (TemplateBinding)nestedPkg.getTemplateBindings().get(0)))) continue;
            return nestedPkg;
        }
        return null;
    }

    public static void declareDependencyToOperationIDs(Package pkg) {
        PackageableElement type = pkg.getPackagedElement("OperationIDs");
        if (type instanceof Type) {
            ElementUtils.declareDependency((Type)TransformationContext.current.classifier, (Type)((Type)type));
        }
    }

    public static void declareDependencyToSignalIDs(Package pkg) {
        NamedElement type = ElementUtils.getQualifiedElement((Package)pkg, (String)"globalenums::SignalIDs");
        if (type instanceof Type) {
            ElementUtils.declareDependency((Type)TransformationContext.current.classifier, (Type)((Type)type));
        }
    }
}

