/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.validation;

import com.google.common.collect.MapMaker;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.core.utils.OneShotExecutor;
import org.eclipse.papyrus.infra.emf.gmf.command.INonDirtying;
import org.eclipse.papyrus.infra.services.validation.IPapyrusDiagnostician;
import org.eclipse.papyrus.infra.services.validation.ValidationTool;
import org.eclipse.papyrus.infra.services.validation.commands.ValidateSubtreeCommand;
import org.eclipse.papyrus.uml.diagram.sequence.command.AsynchronousCommand;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.util.OccurrenceSpecificationHelper;
import org.eclipse.papyrus.uml.diagram.sequence.validation.OperandDiagnostician;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class AsyncValidateCommand
extends AsynchronousCommand
implements INonDirtying {
    private static Map<EObject, OneShotExecutor> executors = new MapMaker().weakKeys().makeMap();

    public AsyncValidateCommand(EObject object) {
        super("Validate", TransactionUtil.getEditingDomain((EObject)object), () -> AsyncValidateCommand.validate(object), (Executor)executors.computeIfAbsent(object, __ -> new OneShotExecutor(arg_0 -> ((Display)Display.getDefault()).asyncExec(arg_0))));
    }

    private static ICommand validate(EObject object) {
        ValidateSubtreeCommand cmd = (ValidateSubtreeCommand)new UMLSwitch<ValidateSubtreeCommand>(){

            public ValidateSubtreeCommand caseInteractionOperand(InteractionOperand operand) {
                return new ValidateOperandCommand(operand);
            }

            public ValidateSubtreeCommand defaultCase(EObject object) {
                return new ValidateSubtreeCommand(object);
            }
        }.doSwitch(object);
        cmd.disableUIFeedback();
        return cmd;
    }

    public static Optional<AsyncValidateCommand> get(EObject object) {
        IPreferenceStore store = UMLDiagramEditorPlugin.getInstance().getPreferenceStore();
        Boolean triggerValidation = store.getBoolean("PREF_TRIGGER_ASYNC_VALIDATION");
        return Optional.ofNullable(triggerValidation != false ? new AsyncValidateCommand(object) : null);
    }

    static Stream<Message> messages(InteractionOperand operand) {
        return operand.getFragments().stream().filter(MessageEnd.class::isInstance).map(MessageEnd.class::cast).map(MessageEnd::getMessage).filter(Objects::nonNull).distinct();
    }

    static Stream<ExecutionSpecification> nonOwnedExecutions(InteractionOperand operand) {
        return operand.getFragments().stream().filter(OccurrenceSpecification.class::isInstance).map(OccurrenceSpecification.class::cast).map(AsyncValidateCommand::getExecution).filter(Objects::nonNull).filter(exec -> exec.getOwner() != operand).distinct();
    }

    static ExecutionSpecification getExecution(OccurrenceSpecification occurrence) {
        return Optional.ofNullable(OccurrenceSpecificationHelper.findExecutionWith(occurrence, true)).orElseGet(() -> OccurrenceSpecificationHelper.findExecutionWith(occurrence, false));
    }

    private static class ValidateOperandCommand
    extends ValidateSubtreeCommand {
        private final InteractionOperand operand;

        ValidateOperandCommand(InteractionOperand operand) {
            super((EObject)operand, (IPapyrusDiagnostician)new OperandDiagnostician());
            this.operand = operand;
        }

        protected void handleDiagnostic(IProgressMonitor monitor, Diagnostic diagnostic, EObject validateElement, Shell shell) {
            Resource resource = this.getValidationResource();
            if (resource != null && validateElement != null) {
                List<NamedElement> others = Stream.concat(AsyncValidateCommand.messages(this.operand), AsyncValidateCommand.nonOwnedExecutions(this.operand)).collect(Collectors.toList());
                int markersToCreate = diagnostic.getChildren().size();
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(1 + others.size() + markersToCreate));
                ValidationTool vt = new ValidationTool(validateElement, resource);
                vt.deleteSubMarkers((IProgressMonitor)sub.newChild(1));
                others.forEach(el -> new ValidationTool((EObject)el, resource).deleteSubMarkers((IProgressMonitor)sub.newChild(1)));
                vt.createMarkers(diagnostic, (IProgressMonitor)sub.newChild(markersToCreate));
                sub.done();
            }
        }
    }
}

