/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.ArrayList;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.SenderRequestUtils;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.SequenceReferenceEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.util.LogOptions;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;

public class UpdateConnectionReferenceEditPolicy
extends GraphicalEditPolicy {
    public static String UDPATE_CONNECTION_REFERENCE = "UdpateConnectionReferenceEditPolicy";

    public Command getCommand(Request request) {
        if (request instanceof ChangeBoundsRequest && !"autosize".equals(request.getType())) {
            Point nextLocation = ((ChangeBoundsRequest)request).getLocation();
            UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "+ MOVE at " + nextLocation + " of " + this.getHost());
            PrecisionRectangle locationAndSize = new PrecisionRectangle(this.getHostFigure().getBounds());
            if (this.getHost() instanceof AbstractExecutionSpecificationEditPart) {
                this.getHostFigure().translateToAbsolute((Translatable)locationAndSize);
                locationAndSize = ((ChangeBoundsRequest)request).getTransformedRectangle((Rectangle)locationAndSize);
            }
            if (this.getHost().getEditPolicy((Object)"SEQUENCE_REFERENCE") != null) {
                SequenceReferenceEditPolicy references = (SequenceReferenceEditPolicy)this.getHost().getEditPolicy((Object)"SEQUENCE_REFERENCE");
                if (!SenderRequestUtils.isASender(request, this.getHost())) {
                    CompoundCommand compoundCommand = new CompoundCommand();
                    for (EditPart editPart : references.getStrongReferences().keySet()) {
                        if (SenderRequestUtils.isASender(request, editPart)) continue;
                        UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "+--> try to Move " + editPart.getClass().getName());
                        if (!(editPart instanceof ConnectionEditPart)) continue;
                        ConnectionEditPart connectionEditPart = (ConnectionEditPart)editPart;
                        ArrayList<EditPart> senderList = SenderRequestUtils.getSenders(request);
                        Rectangle endLocation = new Rectangle((Rectangle)locationAndSize);
                        if (connectionEditPart instanceof ConnectionNodeEditPart) {
                            Point startPoint = SequenceUtil.getAbsoluteEdgeExtremity((ConnectionNodeEditPart)connectionEditPart, true);
                            Point endPoint = SequenceUtil.getAbsoluteEdgeExtremity((ConnectionNodeEditPart)connectionEditPart, false);
                            if (endPoint.y() != startPoint.y()) {
                                endLocation.setY(endLocation.y() + (endPoint.y() - startPoint.y()));
                            }
                        }
                        ReconnectRequest reconnectSourceRequest = this.createReconnectRequest(connectionEditPart, (Rectangle)locationAndSize, senderList, "Reconnection source", references);
                        reconnectSourceRequest.getExtendedData().put("do not check horizontality", true);
                        ReconnectRequest reconnectTargetRequest = this.createReconnectRequest(connectionEditPart, endLocation, senderList, "Reconnection target", references);
                        reconnectTargetRequest.getExtendedData().put("do not check horizontality", true);
                        compoundCommand.add(connectionEditPart.getTarget().getCommand((Request)reconnectTargetRequest));
                        compoundCommand.add(connectionEditPart.getSource().getCommand((Request)reconnectSourceRequest));
                    }
                    if (compoundCommand.size() == 0) {
                        return super.getCommand(request);
                    }
                    return compoundCommand;
                }
            }
        }
        return super.getCommand(request);
    }

    protected ReconnectRequest createReconnectRequest(ConnectionEditPart connectionEditPart, Rectangle locationAndSize, ArrayList<EditPart> senderList, String reconnectType, SequenceReferenceEditPolicy references) {
        ReconnectRequest reconnectRequest = new ReconnectRequest();
        reconnectRequest.setConnectionEditPart(connectionEditPart);
        SenderRequestUtils.addRequestSenders((Request)reconnectRequest, senderList);
        SenderRequestUtils.addRequestSender((Request)reconnectRequest, this.getHost());
        if ("START".equals(references.getStrongReferences().get(connectionEditPart))) {
            reconnectRequest.setLocation(new Point(100, locationAndSize.y));
        } else {
            reconnectRequest.setLocation(new Point(100, locationAndSize.y + locationAndSize.height));
        }
        reconnectRequest.setType((Object)reconnectType);
        if ("Reconnection target".equals(reconnectType)) {
            reconnectRequest.setTargetEditPart(connectionEditPart.getTarget());
        } else {
            reconnectRequest.setTargetEditPart(connectionEditPart.getSource());
        }
        return reconnectRequest;
    }
}

