/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.evaluation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.BooleanLiteralExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionItem;
import org.eclipse.ocl.pivot.CollectionLiteralExp;
import org.eclipse.ocl.pivot.CollectionLiteralPart;
import org.eclipse.ocl.pivot.CollectionRange;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteInheritance;
import org.eclipse.ocl.pivot.EnumLiteralExp;
import org.eclipse.ocl.pivot.EnumerationLiteral;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.IfExp;
import org.eclipse.ocl.pivot.IntegerLiteralExp;
import org.eclipse.ocl.pivot.InvalidLiteralExp;
import org.eclipse.ocl.pivot.IterateExp;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.IteratorExp;
import org.eclipse.ocl.pivot.LetExp;
import org.eclipse.ocl.pivot.MapLiteralExp;
import org.eclipse.ocl.pivot.MapLiteralPart;
import org.eclipse.ocl.pivot.MapType;
import org.eclipse.ocl.pivot.MessageExp;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.NullLiteralExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.OppositePropertyCallExp;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.PropertyCallExp;
import org.eclipse.ocl.pivot.RealLiteralExp;
import org.eclipse.ocl.pivot.ShadowExp;
import org.eclipse.ocl.pivot.StateExp;
import org.eclipse.ocl.pivot.StringLiteralExp;
import org.eclipse.ocl.pivot.TupleLiteralExp;
import org.eclipse.ocl.pivot.TupleLiteralPart;
import org.eclipse.ocl.pivot.TupleType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypeExp;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.pivot.UnspecifiedValueExp;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.pivot.evaluation.EvaluationHaltedException;
import org.eclipse.ocl.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.TuplePartId;
import org.eclipse.ocl.pivot.internal.evaluation.AbstractEvaluationVisitor;
import org.eclipse.ocl.pivot.internal.evaluation.ExecutorInternal;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.library.AbstractEvaluatorIterationManager;
import org.eclipse.ocl.pivot.library.EvaluatorMultipleIterationManager;
import org.eclipse.ocl.pivot.library.EvaluatorSingleIterationManager;
import org.eclipse.ocl.pivot.library.LibraryFeature;
import org.eclipse.ocl.pivot.library.LibraryIteration;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.CollectionValue;
import org.eclipse.ocl.pivot.values.IntegerRange;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.Unlimited;
import org.eclipse.ocl.pivot.values.UnlimitedNaturalValue;

public class BasicEvaluationVisitor
extends AbstractEvaluationVisitor {
    public static boolean isSimpleRange(@NonNull CollectionLiteralExp cl) {
        List<CollectionLiteralPart> partsList = cl.getOwnedParts();
        int size = partsList.size();
        if (size == 1) {
            CollectionLiteralPart part = partsList.get(0);
            return part instanceof CollectionRange;
        }
        return false;
    }

    public BasicEvaluationVisitor(@NonNull ExecutorInternal executor) {
        super(executor);
    }

    @Override
    @Deprecated
    public @NonNull EvaluationVisitor createNestedEvaluator() {
        return this;
    }

    @Override
    @Deprecated
    public void dispose() {
    }

    @Override
    public @Nullable Object evaluate(@NonNull OCLExpression body) {
        Object value = body.accept(this.undecoratedVisitor);
        assert (ValueUtil.isBoxed(value));
        return value;
    }

    @Deprecated
    public @NonNull LibraryFeature lookupImplementation(@NonNull Class dynamicType, @NonNull Operation staticOperation) {
        CompleteInheritance inheritance = this.environmentFactory.getMetamodelManager().getInheritance(dynamicType);
        return inheritance.getPivotClass().lookupImplementation(this.standardLibrary, staticOperation);
    }

    @Override
    public Object safeVisit(@Nullable Visitable v) {
        if (v == null) {
            throw new InvalidValueException("null expression", new Object[0]);
        }
        try {
            Object result = v.accept(this.undecoratedVisitor);
            assert (ValueUtil.isBoxed(result));
            return result;
        }
        catch (InvalidValueException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidValueException(e, "Evaluation Failure");
        }
    }

    @Override
    public Object visitBooleanLiteralExp(@NonNull BooleanLiteralExp booleanLiteralExp) {
        boolean value = booleanLiteralExp.isBooleanSymbol();
        return value;
    }

    @Override
    public Object visitCollectionItem(@NonNull CollectionItem item) {
        throw new UnsupportedOperationException("evaluation of CollectionItem");
    }

    @Override
    public Object visitCollectionLiteralExp(@NonNull CollectionLiteralExp cl) {
        List<CollectionLiteralPart> parts = cl.getOwnedParts();
        CollectionType type = (CollectionType)cl.getType();
        boolean isOrdered = type.isOrdered();
        if (isOrdered && BasicEvaluationVisitor.isSimpleRange(cl)) {
            CollectionRange collRange = (CollectionRange)parts.get(0);
            OCLExpression first = collRange.getOwnedFirst();
            OCLExpression last = collRange.getOwnedLast();
            Object firstVal = first.accept(this.undecoratedVisitor);
            Object lastVal = last.accept(this.undecoratedVisitor);
            IntegerValue firstInteger = ValueUtil.asIntegerValue(firstVal);
            IntegerValue lastInteger = ValueUtil.asIntegerValue(lastVal);
            CollectionTypeId typeId = type.getTypeId();
            IntegerRange range = ValueUtil.createRange(firstInteger, lastInteger);
            if (type.isUnique()) {
                return ValueUtil.createOrderedSetRange(typeId, range);
            }
            return ValueUtil.createSequenceRange(typeId, range);
        }
        ArrayList<Object> orderedResults = new ArrayList<Object>();
        HashSet<Object> uniqueResults = type.isUnique() ? new HashSet<Object>() : null;
        block0: for (CollectionLiteralPart part : parts) {
            if (part instanceof CollectionItem) {
                CollectionItem item = (CollectionItem)part;
                OCLExpression itemExp = item.getOwnedItem();
                Object itemVal = itemExp.accept(this.undecoratedVisitor);
                if (uniqueResults != null && !uniqueResults.add(itemVal)) continue;
                orderedResults.add(itemVal);
                continue;
            }
            CollectionRange range = (CollectionRange)part;
            OCLExpression first = range.getOwnedFirst();
            OCLExpression last = range.getOwnedLast();
            Object firstVal = first.accept(this.undecoratedVisitor);
            Object lastVal = last.accept(this.undecoratedVisitor);
            IntegerValue firstInteger = ValueUtil.asIntegerValue(firstVal);
            IntegerValue lastInteger = ValueUtil.asIntegerValue(lastVal);
            Integer firstInt = firstInteger.asInteger();
            Integer lastInt = lastInteger.asInteger();
            if (firstInt > lastInt) continue;
            int i = firstInt;
            while (true) {
                IntegerValue integerValue = ValueUtil.integerValueOf(i);
                if (uniqueResults == null || uniqueResults.add(integerValue)) {
                    orderedResults.add(integerValue);
                }
                if (i >= lastInt) continue block0;
                ++i;
            }
        }
        return this.idResolver.createCollectionOfAll(type.isOrdered(), type.isUnique(), ClassUtil.nonNullModel(type.getElementType()).getTypeId(), orderedResults);
    }

    @Override
    public Object visitCollectionRange(@NonNull CollectionRange range) {
        throw new UnsupportedOperationException("evaluation of CollectionRange");
    }

    @Override
    public Object visitEnumLiteralExp(@NonNull EnumLiteralExp el) {
        EnumerationLiteral enumLiteral = el.getReferredLiteral();
        assert (enumLiteral != null);
        return enumLiteral.getEnumerationLiteralId();
    }

    @Override
    public Object visitExpressionInOCL(@NonNull ExpressionInOCL expression) {
        if (this.isCanceled()) {
            throw new EvaluationHaltedException("Canceled");
        }
        Object result = this.safeVisit(expression.getOwnedBody());
        return result;
    }

    @Override
    public Object visitIfExp(@NonNull IfExp ifExp) {
        OCLExpression condition = ifExp.getOwnedCondition();
        Object acceptedValue = condition.accept(this.undecoratedVisitor);
        Boolean evaluatedCondition = ValueUtil.asBoolean(acceptedValue);
        OCLExpression expression = null;
        expression = evaluatedCondition == ValueUtil.TRUE_VALUE ? ifExp.getOwnedThen() : ifExp.getOwnedElse();
        return expression.accept(this.undecoratedVisitor);
    }

    @Override
    public Object visitIntegerLiteralExp(@NonNull IntegerLiteralExp integerLiteralExp) {
        Number integerSymbol = integerLiteralExp.getIntegerSymbol();
        return integerSymbol != null ? ValueUtil.integerValueOf(integerSymbol) : null;
    }

    @Override
    public Object visitInvalidLiteralExp(@NonNull InvalidLiteralExp invalidLiteralExp) {
        throw ValueUtil.INVALID_VALUE;
    }

    @Override
    public Object visitIterateExp(@NonNull IterateExp iterateExp) {
        if (this.isCanceled()) {
            throw new EvaluationHaltedException("Canceled");
        }
        Iteration staticIteration = ClassUtil.nonNullModel(iterateExp.getReferredIteration());
        OCLExpression source = iterateExp.getOwnedSource();
        Object acceptedValue = source.accept(this.undecoratedVisitor);
        CollectionValue sourceValue = ValueUtil.asCollectionValue(acceptedValue);
        if (iterateExp.isIsSafe()) {
            sourceValue = sourceValue.excluding(null);
        }
        Class dynamicSourceType = this.idResolver.getClass(sourceValue.getTypeId(), null);
        LibraryIteration implementation = (LibraryIteration)dynamicSourceType.lookupImplementation(this.standardLibrary, staticIteration);
        Object result = null;
        try {
            AbstractEvaluatorIterationManager iterationManager;
            Variable accumulator = iterateExp.getOwnedResult();
            Object initValue = accumulator.getOwnedInit().accept(this.undecoratedVisitor);
            Variable accumulatorVariable = accumulator;
            OCLExpression body = ClassUtil.nonNullModel(iterateExp.getOwnedBody());
            List<Variable> iterators = iterateExp.getOwnedIterators();
            int iSize = iterators.size();
            if (iSize == 1) {
                VariableDeclaration firstIterator = ClassUtil.nonNullModel(iterators.get(0));
                iterationManager = new EvaluatorSingleIterationManager((Executor)this.context, iterateExp, body, sourceValue, accumulatorVariable, initValue, firstIterator);
            } else {
                TypedElement[] variables = new VariableDeclaration[iSize];
                int i = 0;
                while (i < iSize) {
                    variables[i] = iterators.get(i);
                    ++i;
                }
                iterationManager = new EvaluatorMultipleIterationManager((Executor)this.context, iterateExp, body, sourceValue, accumulatorVariable, initValue, variables);
            }
            result = implementation.evaluateIteration(iterationManager);
        }
        catch (InvalidValueException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidValueException(e, StringUtil.bind(PivotMessagesInternal.FailedToEvaluate_ERROR_, staticIteration, sourceValue, iterateExp));
        }
        return result;
    }

    @Override
    public Object visitIteratorExp(@NonNull IteratorExp iteratorExp) {
        if (this.isCanceled()) {
            throw new EvaluationHaltedException("Canceled");
        }
        Iteration staticIteration = ClassUtil.nonNullModel(iteratorExp.getReferredIteration());
        OCLExpression source = iteratorExp.getOwnedSource();
        Object sourceVal = source.accept(this.undecoratedVisitor);
        CollectionValue sourceValue = ValueUtil.asCollectionValue(sourceVal);
        if (iteratorExp.isIsSafe()) {
            sourceValue = sourceValue.excluding(null);
        }
        Class dynamicSourceType = this.idResolver.getClass(sourceValue.getTypeId(), null);
        LibraryIteration.LibraryIterationExtension implementation = (LibraryIteration.LibraryIterationExtension)dynamicSourceType.lookupImplementation(this.standardLibrary, staticIteration);
        Object result = null;
        try {
            AbstractEvaluatorIterationManager iterationManager;
            OCLExpression body = iteratorExp.getOwnedBody();
            Type iterationType = PivotUtilInternal.getType(ClassUtil.nonNullModel(iteratorExp.getType()));
            Type bodyType = PivotUtilInternal.getType(ClassUtil.nonNullModel(body.getType()));
            Object accumulatorValue = implementation.createAccumulatorValue((Executor)this.context, iterationType.getTypeId(), bodyType.getTypeId());
            List<Variable> iterators = iteratorExp.getOwnedIterators();
            int iSize = iterators.size();
            if (iSize == 1) {
                VariableDeclaration firstIterator = ClassUtil.nonNullModel(iterators.get(0));
                iterationManager = new EvaluatorSingleIterationManager((Executor)this.context, iteratorExp, body, sourceValue, null, accumulatorValue, firstIterator);
            } else {
                TypedElement[] variables = new VariableDeclaration[iSize];
                int i = 0;
                while (i < iSize) {
                    variables[i] = iterators.get(i);
                    ++i;
                }
                iterationManager = new EvaluatorMultipleIterationManager((Executor)this.context, iteratorExp, body, sourceValue, null, accumulatorValue, variables);
            }
            result = implementation.evaluateIteration(iterationManager);
        }
        catch (InvalidValueException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidValueException(e, PivotMessagesInternal.FailedToEvaluate_ERROR_, staticIteration, sourceValue, iteratorExp);
        }
        return result;
    }

    @Override
    public Object visitLetExp(@NonNull LetExp letExp) {
        Object value;
        OCLExpression expression = letExp.getOwnedIn();
        Variable variable = letExp.getOwnedVariable();
        assert (variable != null);
        try {
            value = variable.accept(this.undecoratedVisitor);
        }
        catch (EvaluationHaltedException e) {
            throw e;
        }
        catch (InvalidValueException e) {
            value = e;
        }
        assert (expression != null);
        EvaluationEnvironment nestedEvaluationEnvironment = ((ExecutorInternal.ExecutorInternalExtension)this.context).pushEvaluationEnvironment((NamedElement)expression, (Object)letExp);
        nestedEvaluationEnvironment.add(variable, value);
        try {
            Object object = expression.accept(this.undecoratedVisitor);
            return object;
        }
        finally {
            ((ExecutorInternal.ExecutorInternalExtension)this.context).popEvaluationEnvironment();
        }
    }

    @Override
    public Object visitMapLiteralExp(@NonNull MapLiteralExp mapLiteralExp) {
        List<MapLiteralPart> parts = mapLiteralExp.getOwnedParts();
        MapType type = (MapType)mapLiteralExp.getType();
        HashMap<Object, Object> mapEntries = new HashMap<Object, Object>();
        for (MapLiteralPart part : parts) {
            OCLExpression key = part.getOwnedKey();
            OCLExpression value = part.getOwnedValue();
            Object keyVal = key.accept(this.undecoratedVisitor);
            Object valueVal = value.accept(this.undecoratedVisitor);
            mapEntries.put(keyVal, valueVal);
        }
        return this.idResolver.createMapOfAll(ClassUtil.nonNullModel(type.getKeyType()).getTypeId(), ClassUtil.nonNullModel(type.getValueType()).getTypeId(), mapEntries);
    }

    @Override
    public Object visitMessageExp(@NonNull MessageExp m) {
        throw new UnsupportedOperationException("evaluation of MessageExp");
    }

    @Override
    public Object visitNullLiteralExp(@NonNull NullLiteralExp nullLiteralExp) {
        return null;
    }

    @Override
    public Object visitOperationCallExp(@NonNull OperationCallExp operationCallExp) {
        Object sourceValue;
        if (this.isCanceled()) {
            throw new EvaluationHaltedException("Canceled");
        }
        Operation apparentOperation = operationCallExp.getReferredOperation();
        assert (apparentOperation != null);
        boolean isValidating = apparentOperation.isIsValidating();
        OCLExpression source = operationCallExp.getOwnedSource();
        if (source == null) {
            sourceValue = null;
        } else if (!isValidating) {
            sourceValue = source.accept(this.undecoratedVisitor);
        } else {
            try {
                sourceValue = source.accept(this.undecoratedVisitor);
                assert (ValueUtil.isBoxed(sourceValue));
            }
            catch (EvaluationHaltedException e) {
                throw e;
            }
            catch (InvalidValueException e) {
                sourceValue = e;
            }
        }
        if (sourceValue == null && operationCallExp.isIsSafe()) {
            return null;
        }
        List<@NonNull OCLExpression> arguments = ClassUtil.nullFree(operationCallExp.getOwnedArguments());
        @Nullable Object[] sourceAndArgumentValues = new Object[1 + arguments.size()];
        int argumentIndex = 0;
        sourceAndArgumentValues[argumentIndex++] = sourceValue;
        for (OCLExpression argument : arguments) {
            Object argValue;
            if (!isValidating) {
                argValue = argument.accept(this.undecoratedVisitor);
            } else {
                try {
                    argValue = argument.accept(this.undecoratedVisitor);
                    assert (ValueUtil.isBoxed(argValue));
                }
                catch (EvaluationHaltedException e) {
                    throw e;
                }
                catch (InvalidValueException e) {
                    argValue = e;
                }
            }
            sourceAndArgumentValues[argumentIndex++] = argValue;
        }
        return ((ExecutorInternal.ExecutorInternalExtension)this.context).internalExecuteOperationCallExp(operationCallExp, sourceAndArgumentValues);
    }

    @Override
    public Object visitOppositePropertyCallExp(@NonNull OppositePropertyCallExp oppositePropertyCallExp) {
        Object sourceValue;
        OCLExpression source;
        Property oppositeReferredProperty = oppositePropertyCallExp.getReferredProperty();
        Property referredProperty = oppositeReferredProperty.getOpposite();
        if (referredProperty != null && (source = oppositePropertyCallExp.getOwnedSource()) != null && (sourceValue = source.accept(this.undecoratedVisitor)) != null) {
            return ((ExecutorInternal.ExecutorInternalExtension)this.context).internalExecuteNavigationCallExp(oppositePropertyCallExp, referredProperty, sourceValue);
        }
        return null;
    }

    @Override
    public Object visitPropertyCallExp(@NonNull PropertyCallExp propertyCallExp) {
        OCLExpression source;
        Property referredProperty = propertyCallExp.getReferredProperty();
        if (referredProperty != null && (source = propertyCallExp.getOwnedSource()) != null) {
            Object sourceValue = source.accept(this.undecoratedVisitor);
            return ((ExecutorInternal.ExecutorInternalExtension)this.context).internalExecuteNavigationCallExp(propertyCallExp, referredProperty, sourceValue);
        }
        return null;
    }

    @Override
    public Object visitRealLiteralExp(@NonNull RealLiteralExp realLiteralExp) {
        Number realSymbol = realLiteralExp.getRealSymbol();
        return realSymbol != null ? ValueUtil.realValueOf(realSymbol) : null;
    }

    @Override
    public Object visitShadowExp(@NonNull ShadowExp ce) {
        return ((ExecutorInternal.ExecutorInternalExtension)this.context).internalExecuteShadowExp(ce);
    }

    @Override
    public Object visitStateExp(@NonNull StateExp s) {
        return s.getReferredState();
    }

    @Override
    public Object visitStringLiteralExp(@NonNull StringLiteralExp stringLiteralExp) {
        String value = stringLiteralExp.getStringSymbol();
        if (value == null) {
            throw new InvalidValueException("Invalid String Value", stringLiteralExp);
        }
        return value;
    }

    @Override
    public Object visitTupleLiteralExp(@NonNull TupleLiteralExp tl) {
        Type type = ClassUtil.nonNullModel(tl.getType());
        HashMap<@NonNull TuplePartId, @Nullable Object> propertyValues = new HashMap<TuplePartId, Object>();
        for (TupleLiteralPart part : ClassUtil.nullFree(tl.getOwnedParts())) {
            propertyValues.put(ClassUtil.nonNull(part.getPartId()), part.accept(this.undecoratedVisitor));
        }
        return ValueUtil.createTupleValue(((TupleType)type).getTupleTypeId(), propertyValues);
    }

    @Override
    public Object visitTupleLiteralPart(@NonNull TupleLiteralPart tp) {
        return tp.getOwnedInit().accept(this.undecoratedVisitor);
    }

    @Override
    public Object visitTypeExp(@NonNull TypeExp t) {
        return t.getReferredType();
    }

    @Override
    public Object visitUnlimitedNaturalLiteralExp(@NonNull UnlimitedNaturalLiteralExp unlimitedNaturalLiteralExp) {
        Number unlimitedNaturalSymbol = unlimitedNaturalLiteralExp.getUnlimitedNaturalSymbol();
        if (unlimitedNaturalSymbol == null) {
            return null;
        }
        if (unlimitedNaturalSymbol instanceof Unlimited) {
            return ValueUtil.UNLIMITED_VALUE;
        }
        if (unlimitedNaturalSymbol instanceof UnlimitedNaturalValue) {
            return unlimitedNaturalSymbol;
        }
        IntegerValue integerValue = ValueUtil.integerValueOf(unlimitedNaturalSymbol);
        if (integerValue.signum() < 0 && integerValue == ValueUtil.integerValueOf(-1)) {
            return ValueUtil.UNLIMITED_VALUE;
        }
        return integerValue.asUnlimitedNaturalValue();
    }

    @Override
    public Object visitUnspecifiedValueExp(@NonNull UnspecifiedValueExp uv) {
        throw new UnsupportedOperationException("evaluation of UnspecifiedValueExp");
    }

    @Override
    public Object visitVariable(@NonNull Variable variable) {
        OCLExpression initExp = variable.getOwnedInit();
        if (initExp == null) {
            throw new InvalidValueException("Uninitialized variable", variable);
        }
        return initExp.accept(this.undecoratedVisitor);
    }

    @Override
    public Object visitVariableExp(@NonNull VariableExp variableExp) {
        VariableDeclaration variableDeclaration = variableExp.getReferredVariable();
        if (variableDeclaration == null) {
            throw new InvalidValueException("Undefined variable", null, null, variableExp);
        }
        Object value = ((ExecutorInternal.ExecutorInternalExtension)this.context).getValueOf(variableDeclaration);
        if (value instanceof InvalidValueException) {
            throw (InvalidValueException)value;
        }
        return value;
    }

    @Override
    public Object visiting(@NonNull Visitable visitable) {
        throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for " + this.getClass().getSimpleName());
    }
}

