/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.components.modellibs.core.transformations;

import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.MARTE.MARTE_DesignModel.SRM.SW_Concurrency.SwSchedulableResource;
import org.eclipse.papyrus.designer.deployment.tools.AllocUtils;
import org.eclipse.papyrus.designer.deployment.tools.DepUtils;
import org.eclipse.papyrus.designer.languages.common.base.ElementUtils;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.m2minterfaces.IM2MTrafoCDP;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.M2MTrafo;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ThreadAllocToConnector
implements IM2MTrafoCDP {
    public void applyTrafo(M2MTrafo trafo, Package deploymentPlan) throws TransformationException {
        for (InstanceSpecification is : DepUtils.getInstances((Package)deploymentPlan)) {
            InstanceSpecification target = AllocUtils.getNodeOrThread((InstanceSpecification)is);
            if (target == null) continue;
            Classifier sourceCl = DepUtils.getClassifier((InstanceSpecification)is);
            Classifier targetCl = DepUtils.getClassifier((InstanceSpecification)target);
            SwSchedulableResource alloc = (SwSchedulableResource)UMLUtil.getStereotypeApplication((Element)targetCl, SwSchedulableResource.class);
            if (alloc == null) continue;
            Class sourceClass = (Class)sourceCl;
            Class targetClass = (Class)targetCl;
            Port lcPortSrc = (Port)ElementUtils.getNamedElementFromList((EList)sourceClass.getAllAttributes(), (String)"run");
            Port lcPortTrg = (Port)ElementUtils.getNamedElementFromList((EList)targetClass.getAllAttributes(), (String)"rRun");
            EList lcSlotsSrc = DepUtils.getReferencingSlots((InstanceSpecification)is);
            EList lcSlotsTrg = DepUtils.getReferencingSlots((InstanceSpecification)target);
            if (lcSlotsSrc.size() <= 0 || lcSlotsTrg.size() <= 0) continue;
            Slot lcSlotSrc = (Slot)lcSlotsSrc.get(0);
            Slot lcSlotTrg = (Slot)lcSlotsTrg.get(0);
            StructuralFeature featureSrc = lcSlotSrc.getDefiningFeature();
            StructuralFeature featureTrg = lcSlotTrg.getDefiningFeature();
            if (!(featureSrc instanceof Property) || !(featureTrg instanceof Property)) continue;
            Class composite = (Class)featureSrc.getFeaturingClassifiers().get(0);
            Connector conn = composite.createOwnedConnector(String.format("alloc %s to %s", featureSrc.getName(), featureTrg.getName()));
            ConnectorEnd end1 = conn.createEnd();
            ConnectorEnd end2 = conn.createEnd();
            end1.setRole((ConnectableElement)lcPortSrc);
            end2.setRole((ConnectableElement)lcPortTrg);
            end1.setPartWithPort((Property)featureSrc);
            end2.setPartWithPort((Property)featureTrg);
        }
    }
}

