/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.reverse.reverse;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.dom.ast.ExpansionOverlapsBoundaryException;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTEqualsInitializer;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTReferenceOperator;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IEnumeration;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.INamespace;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.model.IStructureDeclaration;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.ITypeDef;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Array;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Const;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.External;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Friend;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Inline;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Mutable;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Ptr;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Ref;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Variadic;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Virtual;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Volatile;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ReverseUtils {
    private static ReverseUtils instance;

    public static ReverseUtils getInstance() {
        ReverseUtils _xblockexpression = null;
        boolean _equals = Objects.equal((Object)instance, null);
        if (_equals) {
            ReverseUtils _reverseUtils;
            instance = _reverseUtils = new ReverseUtils();
        }
        _xblockexpression = instance;
        return _xblockexpression;
    }

    public void analyzeDeclaration(List<IASTDeclarator> declarators, Type type, TypedElement typedElement, String langID) {
        for (IASTDeclarator declarator : declarators) {
            this.analyzeDeclaration(declarator, type, typedElement, langID);
        }
    }

    public void analyzeDeclaration(IASTDeclarator declarator, Type type, final TypedElement typedElement, String langID) {
        try {
            boolean _notEquals_3;
            boolean _notEquals_2;
            Functions.Function1<ValueSpecification, Boolean> _function_1;
            IASTPointerOperator[] _pointerOperators;
            boolean _notEquals;
            Object _function;
            int _isApplied;
            if (declarator instanceof ICPPASTArrayDeclarator) {
                boolean _greaterThan;
                ICPPASTArrayDeclarator arrayDeclarator = (ICPPASTArrayDeclarator)declarator;
                IASTArrayModifier[] arrays = arrayDeclarator.getArrayModifiers();
                IASTArrayModifier[] _converted_arrays = arrays;
                int _size = ((List)Conversions.doWrapArray((Object)_converted_arrays)).size();
                boolean bl = _greaterThan = _size > 0;
                if (_greaterThan) {
                    _isApplied = StereotypeUtil.isApplied((Element)typedElement, Array.class);
                    if (_isApplied != 0) {
                        StereotypeUtil.unapply((Element)typedElement, Array.class);
                    }
                    this.applyStereotype((Element)typedElement, true, StereotypeType.ARRAY, "");
                    IASTArrayModifier[] _converted_arrays_1 = arrays;
                    _function = new Consumer<IASTArrayModifier>(){

                        @Override
                        public void accept(IASTArrayModifier it) {
                            boolean _notEquals;
                            IASTExpression expr = it.getConstantExpression();
                            boolean bl = _notEquals = !Objects.equal((Object)expr, null);
                            if (_notEquals) {
                                Array _stereotypeApplication = (Array)UMLUtil.getStereotypeApplication((Element)typedElement, Array.class);
                                String definition = _stereotypeApplication.getDefinition();
                                Array _stereotypeApplication_1 = (Array)UMLUtil.getStereotypeApplication((Element)typedElement, Array.class);
                                String _string = expr.toString();
                                String _plus = String.valueOf(definition) + "[" + _string;
                                String _plus_1 = String.valueOf(_plus) + "]";
                                _stereotypeApplication_1.setDefinition(_plus_1);
                            }
                        }
                    };
                    ((List)Conversions.doWrapArray((Object)_converted_arrays_1)).forEach(_function);
                }
            }
            boolean bl = _notEquals = !Objects.equal((Object)(_pointerOperators = declarator.getPointerOperators()), null);
            if (_notEquals) {
                boolean _isApplied_5;
                IASTPointerOperator[] _pointerOperators_1;
                boolean _isApplied_1 = StereotypeUtil.isApplied((Element)typedElement, Ptr.class);
                if (_isApplied_1) {
                    Ptr _stereotypeApplication = (Ptr)UMLUtil.getStereotypeApplication((Element)typedElement, Ptr.class);
                    _stereotypeApplication.setDeclaration("");
                }
                _function = _pointerOperators_1 = declarator.getPointerOperators();
                int _converted_arrays_1 = _pointerOperators_1.length;
                _isApplied = 0;
                while (_isApplied < _converted_arrays_1) {
                    IASTPointerOperator pointerOperator = _function[_isApplied];
                    if (pointerOperator instanceof ICPPASTReferenceOperator) {
                        boolean _not;
                        ICPPASTReferenceOperator reference = (ICPPASTReferenceOperator)pointerOperator;
                        boolean _isApplied_2 = StereotypeUtil.isApplied((Element)typedElement, Ref.class);
                        boolean bl2 = _not = !_isApplied_2;
                        if (_not) {
                            IToken _syntax = reference.getSyntax();
                            String _string = _syntax.toString();
                            this.applyStereotype((Element)typedElement, true, StereotypeType.REFERENCE, _string);
                        } else {
                            Ref _stereotypeApplication_1 = (Ref)UMLUtil.getStereotypeApplication((Element)typedElement, Ref.class);
                            String value = _stereotypeApplication_1.getDeclaration();
                            Ref _stereotypeApplication_2 = (Ref)UMLUtil.getStereotypeApplication((Element)typedElement, Ref.class);
                            IToken _syntax_1 = reference.getSyntax();
                            String _string_1 = _syntax_1.toString();
                            String _plus = String.valueOf(value) + _string_1;
                            _stereotypeApplication_2.setDeclaration(_plus);
                        }
                    } else if (pointerOperator instanceof IASTPointerOperator) {
                        boolean _not_1;
                        IASTPointerOperator pointer = pointerOperator;
                        boolean _isApplied_3 = StereotypeUtil.isApplied((Element)typedElement, Ptr.class);
                        boolean bl3 = _not_1 = !_isApplied_3;
                        if (_not_1) {
                            IToken _syntax_2 = pointer.getSyntax();
                            String _string_2 = _syntax_2.toString();
                            this.applyStereotype((Element)typedElement, true, StereotypeType.POINTER, _string_2);
                        } else {
                            Ptr _stereotypeApplication_3 = (Ptr)UMLUtil.getStereotypeApplication((Element)typedElement, Ptr.class);
                            String value_1 = _stereotypeApplication_3.getDeclaration();
                            Ptr _stereotypeApplication_4 = (Ptr)UMLUtil.getStereotypeApplication((Element)typedElement, Ptr.class);
                            IToken _syntax_3 = pointer.getSyntax();
                            String _string_3 = _syntax_3.toString();
                            String _plus_1 = String.valueOf(value_1) + _string_3;
                            _stereotypeApplication_4.setDeclaration(_plus_1);
                        }
                    }
                    ++_isApplied;
                }
                boolean _isApplied_4 = StereotypeUtil.isApplied((Element)typedElement, Ptr.class);
                if (_isApplied_4) {
                    String _trim;
                    boolean _equals_1;
                    String _rawSignature;
                    Pattern pattern;
                    Matcher matcher;
                    boolean _find;
                    Ptr _stereotypeApplication_5 = (Ptr)UMLUtil.getStereotypeApplication((Element)typedElement, Ptr.class);
                    String value_2 = _stereotypeApplication_5.getDeclaration();
                    boolean _equals = Objects.equal((Object)value_2, null);
                    if (_equals) {
                        value_2 = "*";
                    }
                    if (_find = (matcher = (pattern = Pattern.compile("(\\*)([\\s]*)(const)")).matcher(_rawSignature = declarator.getRawSignature())).find()) {
                        String _value = value_2;
                        value_2 = String.valueOf(_value) + " const";
                        Ptr _stereotypeApplication_6 = (Ptr)UMLUtil.getStereotypeApplication((Element)typedElement, Ptr.class);
                        _stereotypeApplication_6.setDeclaration(value_2);
                    }
                    if (_equals_1 = (_trim = value_2.trim()).equals("*")) {
                        Ptr _stereotypeApplication_7 = (Ptr)UMLUtil.getStereotypeApplication((Element)typedElement, Ptr.class);
                        _stereotypeApplication_7.setDeclaration(null);
                    }
                }
                if (_isApplied_5 = StereotypeUtil.isApplied((Element)typedElement, Ref.class)) {
                    boolean _notEquals_1;
                    Ref _stereotypeApplication_8 = (Ref)UMLUtil.getStereotypeApplication((Element)typedElement, Ref.class);
                    String value_3 = _stereotypeApplication_8.getDeclaration();
                    boolean _and = false;
                    boolean bl4 = _notEquals_1 = !Objects.equal((Object)value_3, null);
                    if (!_notEquals_1) {
                        _and = false;
                    } else {
                        boolean _equals_2;
                        String _trim_1 = value_3.trim();
                        _and = _equals_2 = _trim_1.equals("&");
                    }
                    if (_and) {
                        Ref _stereotypeApplication_9 = (Ref)UMLUtil.getStereotypeApplication((Element)typedElement, Ref.class);
                        _stereotypeApplication_9.setDeclaration(null);
                    }
                }
            }
            IASTInitializer initilizer = declarator.getInitializer();
            EList _ownedElements = typedElement.getOwnedElements();
            Iterable _filter = Iterables.filter((Iterable)_ownedElements, ValueSpecification.class);
            Iterable _filter_1 = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)(_function_1 = new Functions.Function1<ValueSpecification, Boolean>(){

                public Boolean apply(ValueSpecification it) {
                    String _name = it.getName();
                    return _name.equals("defaultValue");
                }
            }));
            ValueSpecification valueExisting = (ValueSpecification)IterableExtensions.head((Iterable)_filter_1);
            boolean bl5 = _notEquals_2 = !Objects.equal((Object)valueExisting, null);
            if (_notEquals_2) {
                valueExisting.destroy();
            }
            boolean bl6 = _notEquals_3 = !Objects.equal((Object)initilizer, null);
            if (_notEquals_3) {
                ValueSpecification vs = null;
                if (typedElement instanceof Property) {
                    ValueSpecification _createDefaultValue;
                    Type _type = ((Property)typedElement).getType();
                    vs = _createDefaultValue = ((Property)typedElement).createDefaultValue("defaultValue", _type, UMLPackage.Literals.OPAQUE_EXPRESSION);
                } else if (typedElement instanceof Parameter) {
                    ValueSpecification _createDefaultValue_1;
                    Type _type_1 = ((Parameter)typedElement).getType();
                    vs = _createDefaultValue_1 = ((Parameter)typedElement).createDefaultValue("default", _type_1, UMLPackage.Literals.OPAQUE_EXPRESSION);
                }
                boolean _equals_3 = Objects.equal(vs, null);
                if (_equals_3) {
                    return;
                }
                OpaqueExpression oe = (OpaqueExpression)vs;
                EList _languages = oe.getLanguages();
                _languages.add((Object)langID);
                if (initilizer instanceof IASTEqualsInitializer) {
                    boolean _notEquals_4;
                    IASTEqualsInitializer equalsInitialiser = (IASTEqualsInitializer)initilizer;
                    IASTInitializerClause clause = equalsInitialiser.getInitializerClause();
                    boolean bl7 = _notEquals_4 = !Objects.equal((Object)clause, null);
                    if (_notEquals_4) {
                        EList _bodies = oe.getBodies();
                        String _rawSignature_1 = clause.getRawSignature();
                        _bodies.add((Object)_rawSignature_1);
                    }
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void applyStereotype(Element element, boolean isApply, StereotypeType stType, String additional) {
        if (!isApply) {
            return;
        }
        if (stType != null) {
            switch (stType) {
                case CONST: {
                    StereotypeUtil.apply((Element)element, Const.class);
                    break;
                }
                case VOLATILE: {
                    StereotypeUtil.apply((Element)element, Volatile.class);
                    break;
                }
                case ARRAY: {
                    StereotypeUtil.apply((Element)element, Array.class);
                    Array _stereotypeApplication = (Array)UMLUtil.getStereotypeApplication((Element)element, Array.class);
                    _stereotypeApplication.setDefinition(additional);
                    break;
                }
                case POINTER: {
                    StereotypeUtil.apply((Element)element, Ptr.class);
                    Ptr _stereotypeApplication_1 = (Ptr)UMLUtil.getStereotypeApplication((Element)element, Ptr.class);
                    _stereotypeApplication_1.setDeclaration(additional);
                    break;
                }
                case REFERENCE: {
                    StereotypeUtil.apply((Element)element, Ref.class);
                    Ref _stereotypeApplication_2 = (Ref)UMLUtil.getStereotypeApplication((Element)element, Ref.class);
                    _stereotypeApplication_2.setDeclaration(additional);
                    break;
                }
                case EXTERNAL: {
                    StereotypeUtil.apply((Element)element, External.class);
                    break;
                }
                case FRIENDLINE: {
                    StereotypeUtil.apply((Element)element, Friend.class);
                    break;
                }
                case VIRTUAL: {
                    StereotypeUtil.apply((Element)element, Virtual.class);
                    break;
                }
                case INLINE: {
                    StereotypeUtil.apply((Element)element, Inline.class);
                    break;
                }
                case CREATE: {
                    StereotypeUtil.apply((Element)element, (String)"StandardProfile::Create");
                    break;
                }
                case DESTROY: {
                    StereotypeUtil.apply((Element)element, (String)"StandardProfile::Destroy");
                    break;
                }
                case MUTABLE: {
                    StereotypeUtil.apply((Element)element, Mutable.class);
                    break;
                }
                case VARIADIC: {
                    StereotypeUtil.apply((Element)element, Variadic.class);
                    break;
                }
            }
        }
    }

    public String getCppTypeName(IASTDeclSpecifier declarator) {
        String parameterTypeName = "";
        try {
            IToken token = declarator.getSyntax();
            while (!Objects.equal((Object)token, null)) {
                IToken _next;
                boolean _equals_2;
                boolean _equals_1;
                String tokenStr = token.toString();
                boolean _equals = tokenStr.equals("*");
                if (!(_equals || (_equals_1 = tokenStr.equals("&")) || (_equals_2 = tokenStr.equals("const")))) {
                    boolean _greaterThan;
                    int _length = parameterTypeName.length();
                    boolean bl = _greaterThan = _length > 0;
                    if (_greaterThan) {
                        String _parameterTypeName = parameterTypeName;
                        parameterTypeName = String.valueOf(_parameterTypeName) + " ";
                    }
                    String _parameterTypeName_1 = parameterTypeName;
                    parameterTypeName = String.valueOf(_parameterTypeName_1) + tokenStr;
                }
                token = _next = token.getNext();
            }
        }
        catch (Throwable _t) {
            if (_t instanceof ExpansionOverlapsBoundaryException) {
                ExpansionOverlapsBoundaryException expansionOverlapsBoundaryException = (ExpansionOverlapsBoundaryException)_t;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return parameterTypeName;
    }

    public static String getCppTypeName(String name) {
        String _trim;
        String _replace_7;
        String _replace_6;
        String _replace_5;
        String _replace_4;
        String _replace_3;
        String _replace_2;
        String _replace_1;
        String _replace;
        String trimName = name.trim();
        trimName = _replace = trimName.replace("*", "");
        trimName = _replace_1 = trimName.replace("&", "");
        trimName = _replace_2 = trimName.replace("[", "");
        trimName = _replace_3 = trimName.replace("]", "");
        trimName = _replace_4 = trimName.replace("const ", "");
        trimName = _replace_5 = trimName.replace(" const", "");
        trimName = _replace_6 = trimName.replace("volatile", "");
        trimName = _replace_7 = trimName.replace(" volatile", "");
        trimName = _trim = trimName.trim();
        return trimName;
    }

    public List<ICElement> getAllIStructures(IParent parent, boolean allIncludes, boolean lookNestedTypes, ICProject project) {
        try {
            UniqueEList ret = new UniqueEList();
            ICElement[] childrend = parent.getChildren();
            int i = 0;
            while (i < childrend.length) {
                ICElement child = childrend[i];
                boolean _matched = false;
                if (!_matched && child instanceof IStructure) {
                    _matched = true;
                    ret.add((IStructure)child);
                    if (lookNestedTypes) {
                        List<ICElement> _allIStructures = this.getAllIStructures((IParent)((IStructure)child), allIncludes, lookNestedTypes, project);
                        ret.addAll(_allIStructures);
                    }
                }
                if (!_matched && child instanceof IEnumeration) {
                    _matched = true;
                    ret.add((IEnumeration)child);
                }
                if (!_matched && child instanceof IParent) {
                    _matched = true;
                    List<ICElement> _allIStructures_1 = this.getAllIStructures((IParent)child, allIncludes, lookNestedTypes, project);
                    ret.addAll(_allIStructures_1);
                }
                if (!_matched && child instanceof IInclude) {
                    _matched = true;
                    if (allIncludes) {
                        boolean _notEquals;
                        ITranslationUnit unit = this.getTranslationUnitFromInclude((IInclude)child, project);
                        boolean bl = _notEquals = !Objects.equal((Object)unit, null);
                        if (_notEquals) {
                            List<ICElement> _allIStructures_2 = this.getAllIStructures((IParent)unit, allIncludes, lookNestedTypes, project);
                            ret.addAll(_allIStructures_2);
                        }
                    }
                }
                if (!_matched && child instanceof ITypeDef) {
                    _matched = true;
                    ret.add(child);
                }
                if (!_matched && child instanceof IStructureDeclaration) {
                    _matched = true;
                    ret.add(child);
                }
                ++i;
            }
            return ret;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public ITranslationUnit getTranslationUnitFromInclude(IInclude include, ICProject project) {
        boolean _notEquals;
        boolean _not;
        String _elementName;
        String _fullFileName = include.getFullFileName();
        boolean _contains = _fullFileName.contains(_elementName = project.getElementName());
        boolean bl = _not = !_contains;
        if (_not) {
            return null;
        }
        ITranslationUnit ret = null;
        String _fullFileName_1 = include.getFullFileName();
        String _elementName_1 = project.getElementName();
        String[] _split = _fullFileName_1.split(_elementName_1);
        String fileIncludePath = (String)IterableExtensions.last((Iterable)((Iterable)Conversions.doWrapArray((Object)_split)));
        IProject _project = project.getProject();
        IFile file = _project.getFile(fileIncludePath);
        boolean bl2 = _notEquals = !Objects.equal((Object)file, null);
        if (_notEquals) {
            ITranslationUnit unit = CoreModelUtil.findTranslationUnit((IFile)file);
            boolean _equals = Objects.equal((Object)unit, null);
            if (_equals) {
                ITranslationUnit _createTranslationUnitFrom;
                CoreModel _default = CoreModel.getDefault();
                IPath _location = file.getLocation();
                unit = _createTranslationUnitFrom = _default.createTranslationUnitFrom(project, _location);
            }
            ret = unit;
        }
        return ret;
    }

    public ITranslationUnit getTranslationUnitFromElement(ICElement element) {
        ICElement owner = element.getParent();
        while (!Objects.equal((Object)owner, null) && !(owner instanceof ITranslationUnit)) {
            ICElement _parent;
            owner = _parent = owner.getParent();
        }
        return (ITranslationUnit)owner;
    }

    public boolean isSatisfyNamespace(List<String> iUsings, ICElement istructure) {
        ICElement _parent_1;
        boolean _not_1;
        boolean _not;
        boolean _and = false;
        ICElement _parent = istructure.getParent();
        boolean bl = _not = !(_parent instanceof INamespace);
        _and = !_not ? false : (_not_1 = !((_parent_1 = istructure.getParent()) instanceof IStructure));
        if (_and) {
            return true;
        }
        final StringBuilder namespaces = new StringBuilder();
        ICElement owner = istructure.getParent();
        String _elementName = owner.getElementName();
        namespaces.append(_elementName);
        while (owner.getParent() instanceof INamespace || owner.getParent() instanceof IStructure) {
            ICElement _parent_3;
            ICElement _parent_2 = owner.getParent();
            String _elementName_1 = ((INamespace)_parent_2).getElementName();
            String _plus = String.valueOf(_elementName_1) + "::";
            namespaces.insert(0, _plus);
            owner = _parent_3 = owner.getParent();
        }
        Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                boolean _or = false;
                String _string = namespaces.toString();
                boolean _equals = it.equals(_string);
                if (_equals) {
                    _or = true;
                } else {
                    boolean _contains;
                    String _string_1 = namespaces.toString();
                    String _trim = _string_1.trim();
                    _or = _contains = it.contains(_trim);
                }
                return _or;
            }
        };
        Iterable _filter = IterableExtensions.filter(iUsings, (Functions.Function1)_function);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)_filter);
        return !_isEmpty;
    }

    public List<String> getContextNamespaces(ICElement element) {
        UniqueEList ret = new UniqueEList();
        ICElement owner = element.getParent();
        while (!Objects.equal((Object)owner, null)) {
            ICElement _parent;
            boolean _or = false;
            _or = owner instanceof INamespace || owner instanceof IStructure ? true : owner instanceof ICContainer;
            if (_or) {
                boolean _greaterThan;
                String _elementName = owner.getElementName();
                ret.add(_elementName);
                UniqueEList _converted_ret = ret;
                int _length = ((Object[])Conversions.unwrapArray((Object)_converted_ret, Object.class)).length;
                boolean bl = _greaterThan = _length > 1;
                if (_greaterThan) {
                    String n = (String)IterableExtensions.head((Iterable)ret);
                    UniqueEList _converted_ret_1 = ret;
                    int len = ((Object[])Conversions.unwrapArray((Object)_converted_ret_1, Object.class)).length;
                    int i = 1;
                    while (i < len) {
                        boolean _not;
                        String _get = (String)ret.get(i);
                        boolean _contains = _get.contains("::");
                        boolean bl2 = _not = !_contains;
                        if (_not) {
                            String _plus_1;
                            String _get_1 = (String)ret.get(i);
                            String _plus = String.valueOf(_get_1) + "::";
                            n = _plus_1 = String.valueOf(_plus) + n;
                        }
                        ++i;
                    }
                    ret.add(n);
                }
            }
            owner = _parent = owner.getParent();
        }
        return ret;
    }

    public Package getNearestPackage(Element element) {
        return element.getNearestPackage();
    }

    public void unapplyAllStereotypes(final Element element) {
        EList stereotypeAppList = element.getStereotypeApplications();
        Consumer<EObject> _function = new Consumer<EObject>(){

            @Override
            public void accept(EObject it) {
                Stereotype stereotype = UMLUtil.getStereotype((EObject)it);
                element.unapplyStereotype(stereotype);
            }
        };
        stereotypeAppList.forEach((Consumer)_function);
    }

    public static enum StereotypeType {
        CONST,
        VOLATILE,
        ARRAY,
        POINTER,
        REFERENCE,
        EXTERNAL,
        FRIENDLINE,
        VIRTUAL,
        INLINE,
        CREATE,
        DESTROY,
        MUTABLE,
        VARIADIC;

    }
}

